package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ItemInfoSkuReqDto", description = "商品规格请求DTO对象")
public class ItemInfoSkuReqDto extends RequestDto {

    @ApiModelProperty(name = "code", value = "物料编码(商品编码) 必填")
    private String code;//物料编码

    @ApiModelProperty(name = "unit", value = "转换单位，都转换成基本单位（如：箱）可不填")
    private String unit;//转换单位

    @ApiModelProperty(name = "num", value = "转换数量 可不填")
    private BigDecimal num;

    @ApiModelProperty(name = "toUnit", value = "转换单位，都转换成目标单位（如：箱）可不填")
    private String toUnit;//转换单位
}
