package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ProductPriceRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
* 供应商和产品的供货价格Eo对象
*
* @author 迪迦
* @since 2021-09-10
*/
@ApiModel(value = "SellerSkuPriceReqDto", description = "供应商和产品的供货价格Eo对象")
public class SellerSkuPriceReqDto extends RequestDto{
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  卖家（商家/大B）ID
    */
    @ApiModelProperty(name = "sellerId", value = "卖家（商家/大B）ID")
    private Long sellerId;
    /**
    *  买家（客户/小B）ID
    */
    @ApiModelProperty(name = "customerId", value = "买家（客户/小B）ID")
    private Long customerId;
    /**
    *  item ID
    */
    @ApiModelProperty(name = "itemId", value = "item ID")
    private Long itemId;
    /**
     * 商铺ID
     */
    @ApiModelProperty(name = "shopId", value = "shopId")
    private Long shopId;
    /**
     * 商铺名称
     */
    @ApiModelProperty(name = "shopName", value = "shopName")
    private String shopName;
    /**
     * 商铺名称
     */
    @ApiModelProperty(name = "routeKey", value = "routeKey")
    private String routeKey;

    /**
    *  SKU ID
    */
    @ApiModelProperty(name = "skuId", value = "SKU ID")
    private Long skuId;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     *  零售价
     */
    @ApiModelProperty(name = "retailPrice", value = "零售价")
    private BigDecimal retailPrice;
    /**
    *  供货价
    */
    @ApiModelProperty(name = "supplyPrice", value = "供货价")
    private BigDecimal supplyPrice;

    // 增加字段，查价使用，支持in查询
    /**
     *  卖家（商家/大B）ID
     */
    @ApiModelProperty(name = "sellerIdList", value = "卖家（商家/大B）ID")
    private List<Long> sellerIdList;
    /**
     *  买家（客户/小B）ID
     */
    @ApiModelProperty(name = "customerId", value = "买家（客户/小B）ID")
    private List<Long> customerIdList;
    /**
     *  item ID
     */
    @ApiModelProperty(name = "itemId", value = "item ID")
    private List<Long> itemIdList;
    /**
     *  SKU ID
     */
    @ApiModelProperty(name = "skuId", value = "SKU ID")
    private List<Long> skuIdList;

    private List<Long> idList;

    @ApiModelProperty(name = "productPriceRespDto", value = "productPriceRespDto")
    private ProductPriceRespDto productPriceRespDto;

    private String errorMsg;

    public List<Long> getSellerIdList() {
        return sellerIdList;
    }

    public void setSellerIdList(List<Long> sellerIdList) {
        this.sellerIdList = sellerIdList;
    }

    public List<Long> getCustomerIdList() {
        return customerIdList;
    }

    public void setCustomerIdList(List<Long> customerIdList) {
        this.customerIdList = customerIdList;
    }

    public List<Long> getItemIdList() {
        return itemIdList;
    }

    public void setItemIdList(List<Long> itemIdList) {
        this.itemIdList = itemIdList;
    }

    public List<Long> getSkuIdList() {
        return skuIdList;
    }

    public void setSkuIdList(List<Long> skuIdList) {
        this.skuIdList = skuIdList;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setSellerId(Long sellerId){
    this.sellerId = sellerId;
    }
    public Long getSellerId(){
    return this.sellerId;
    }
    public void setCustomerId(Long customerId){
    this.customerId = customerId;
    }
    public Long getCustomerId(){
    return this.customerId;
    }
    public void setSkuId(Long skuId){
    this.skuId = skuId;
    }
    public Long getSkuId(){
    return this.skuId;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setSupplyPrice(BigDecimal supplyPrice){
    this.supplyPrice = supplyPrice;
    }
    public BigDecimal getSupplyPrice(){
    return this.supplyPrice;
    }

    public BigDecimal getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(BigDecimal retailPrice) {
        this.retailPrice = retailPrice;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public ProductPriceRespDto getProductPriceRespDto() {
        return productPriceRespDto;
    }

    public void setProductPriceRespDto(ProductPriceRespDto productPriceRespDto) {
        this.productPriceRespDto = productPriceRespDto;
    }

    public String getRouteKey() {
        return routeKey;
    }

    public void setRouteKey(String routeKey) {
        this.routeKey = routeKey;
    }

    public List<Long> getIdList() {
        return idList;
    }

    public void setIdList(List<Long> idList) {
        this.idList = idList;
    }

    @Override
    public String toString() {
        return new StringBuffer("SellerSkuPriceReqDto{").append(
                "id=").append( id).append(
                ", sellerId=").append( sellerId).append(
                ", customerId=").append( customerId).append(
                ", itemId=").append( itemId).append(
                ", shopId=").append( shopId).append(
                ", shopName='").append( shopName).append( '\'').append(
                ", routeKey='").append( routeKey).append( '\'').append(
                ", skuId=").append( skuId).append(
                ", remark='").append( remark).append( '\'').append(
                ", retailPrice=").append( retailPrice).append(
                ", supplyPrice=").append( supplyPrice).append(
                ", sellerIdList=").append( sellerIdList).append(
                ", customerIdList=").append( customerIdList).append(
                ", itemIdList=").append( itemIdList).append(
                ", skuIdList=").append( skuIdList).append(
                ", idList=").append( idList).append(
                ", productPriceRespDto=").append( productPriceRespDto).append(
                ", errorMsg='").append( errorMsg).append( '\'').append(
                '}').toString();
    }
}
