package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.CategoryAttributesRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
* 产品型号核算品类关系服务接口
*
* @author yiyun
* @since 2022-07-19
*/
@Api(tags = {"产品型号核算品类关系服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-center-item-api-query-ICategoryAttributesQueryApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/categoryAttributes",
    url = "${yundt.cube.center.item.api:}"
)
public interface ICategoryAttributesQueryApi {

    /**
    * 根据id查询产品型号核算品类关系
    *
    * @param id 产品型号核算品类关系id
    * @return   产品型号核算品类关系数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询产品型号核算品类关系", notes = "根据id查询产品型号核算品类关系")
    RestResponse<CategoryAttributesRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 产品型号核算品类关系分页数据
    *
    * @param filter   产品型号核算品类关系查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 产品型号核算品类关系分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "产品型号核算品类关系分页数据", notes = "根据filter查询条件查询产品型号核算品类关系数据，filter=CategoryAttributesReqDto")
    RestResponse<PageInfo<CategoryAttributesRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                  @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
