package com.dtyunxi.yundt.cube.center.item.api.common.enums;

public enum ProductModelTypeEnum {

//    BD50 是虚拟物料(有库存)  比如玻璃险
//    BD51 是无物料商品
//    BD52 是等风来的商品
//    BD53 是财务的虚拟物料，比如快递费等等

    GLASS("BD50", "玻璃险虚拟商品"), //玻璃险虚拟商品
    NOT_MATERIAL("BD51", "无物料商品"), //无物料商品
    ISOPEAK("BD52", "等蜂来"), //等蜂来
    EDITED("BD53", "分快递费虚拟商品/借贷项等其他虚拟商品"); //分快递费虚拟商品/借贷项等其他虚拟商品

    private String status;
    private String desc;

    ProductModelTypeEnum(String status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static String getType(String index) {
        for (ProductModelTypeEnum statusEnum : ProductModelTypeEnum.values()) {
            if (statusEnum.getStatus().equals(index)) {
                return statusEnum.getStatus();
            }
        }
        return index;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
