//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.dtyunxi.yundt.cube.center.item.api.b2b.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Api(
    tags = {"商品中心：商品授权"}
)
@FeignClient(
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/item-auth",
    contextId = "com-dtyunxi-yundt-cube-center-item-api-b2b-query-IItemAuthQueryApi",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemAuthQueryApi {
    @GetMapping({"/list"})
    @ApiOperation("指定目标值得商品授权列表")
    RestResponse<List<ItemAuthRespDto>> list(@ModelAttribute @Valid ItemAuthReqDto itemAuthReqDto);

    @GetMapping({"/listByPage"})
    @ApiOperation("指定目标值得商品授权列表分页查询")
    RestResponse<PageInfo<ItemAuthRespDto>> listByPage(@ModelAttribute @Valid ItemAuthPageReqDto itemAuthPageReqDto);

    @GetMapping({"/page"})
    @ApiOperation("商品授权列表")
    RestResponse<PageInfo<ItemAuthQueryRespDto>> queryItemAuthPage(@ModelAttribute @Valid ItemAuthQueryReqDto itemAuthQueryReqDto);

    @GetMapping({"/{id}"})
    @ApiOperation(
        value = "根据id查询商品授权表",
        notes = "根据id查询商品授权表"
    )
    RestResponse<ItemAuthRespDto> queryById(@PathVariable("id") Long id);

   @GetMapping({"/query-page"})
    @ApiOperation(
        value = "商品授权表分页数据",
        notes = "根据filter查询条件查询商品授权表数据，filter=ItemAuthReqDto"
    )
    RestResponse<PageInfo<ItemAuthRespDto>> queryByPage(@RequestParam("filter") String filter, @RequestParam(name = "pageNum",required = false,defaultValue = "1") Integer pageNum, @RequestParam(name = "pageSize",required = false,defaultValue = "10") Integer pageSize);

    @PostMapping({"/query-by-target-ids"})
    @ApiOperation("根据目标ids获取商品授权信息")
    RestResponse<List<ItemAuthRespDto>> queryByTargetIds(@RequestBody @Valid ItemAuthReqDto itemAuthReqDto);
}
