/**
 * @(#)ItemSkuStatusEnum 1.0 2019/3/25
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.constants;

/**
 * @author shuangqing  2019/3/25
 */
public enum ItemSkuStatusEnum {
    ONSHELF(1, "已上架"),
    OFFSHELF(2, "已下架");

    private Integer status;
    private String desc;

    ItemSkuStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static String getDesc(Integer index) {
        for (ItemSkuStatusEnum statusEnum : ItemSkuStatusEnum.values()) {
            if (statusEnum.getStatus().equals(index)) {
                return statusEnum.getDesc();
            }
        }
        return null;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
