package com.dtyunxi.yundt.cube.center.item.api.base.dto;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropNameReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "ItemAttrDto", description = "商品属性表")
public class ItemAttrDto {
    @ApiModelProperty(name = "sellPoint", value = "商品卖点")
    private String sellPoint;

    @ApiModelProperty(name = "itemBarCode", value = "商品条码")
    private String itemBarCode;

    @ApiModelProperty(name = "frontDirList", value = "前台类目")
    private List<Long> frontDirList;

    @ApiModelProperty(name = "shopDirs", value = "店铺类目列表")
    private List<ItemShopDto> shopDirs;

    @ApiModelProperty(name = "publishChannel", value = "发布渠道")
    private String publishChannel;

    @ApiModelProperty(name = "shippingTemplateId", value = "运费模板id")
    private Long shippingTemplateId;

    @ApiModelProperty(name = "uniformFreight", value = "统一运费")
    private BigDecimal uniformFreight;

    @ApiModelProperty(name = "propList", value = "属性列表")
    private List<PropNameReqDto> propList;

    @ApiModelProperty(name = "backDirList", value = "后端类目：[1级，2级，3级]形式")
    private List<Long> backDirList;

    @ApiModelProperty(name = "logisticTypeList", value = "物流方式列表：fastDispatch 快递配送；cityDispatch 同城配送;")
    private List<String> logisticTypeList;

    public String getSellPoint() {
        return sellPoint;
    }

    public void setSellPoint(String sellPoint) {
        this.sellPoint = sellPoint;
    }

    public String getItemBarCode() {
        return itemBarCode;
    }

    public void setItemBarCode(String itemBarCode) {
        this.itemBarCode = itemBarCode;
    }

    public List<Long> getFrontDirList() {
        return frontDirList;
    }

    public void setFrontDirList(List<Long> frontDirList) {
        this.frontDirList = frontDirList;
    }

    public List<ItemShopDto> getShopDirs() {
        return shopDirs;
    }

    public void setShopDirs(List<ItemShopDto> shopDirs) {
        this.shopDirs = shopDirs;
    }

    public String getPublishChannel() {
        return publishChannel;
    }

    public void setPublishChannel(String publishChannel) {
        this.publishChannel = publishChannel;
    }

    public Long getShippingTemplateId() {
        return shippingTemplateId;
    }

    public void setShippingTemplateId(Long shippingTemplateId) {
        this.shippingTemplateId = shippingTemplateId;
    }

    public BigDecimal getUniformFreight() {
        return uniformFreight;
    }

    public void setUniformFreight(BigDecimal uniformFreight) {
        this.uniformFreight = uniformFreight;
    }

    public List<PropNameReqDto> getPropList() {
        return propList;
    }

    public void setPropList(List<PropNameReqDto> propList) {
        this.propList = propList;
    }

    public List<Long> getBackDirList() {
        return backDirList;
    }

    public void setBackDirList(List<Long> backDirList) {
        this.backDirList = backDirList;
    }

    public List<String> getLogisticTypeList() {
        return logisticTypeList;
    }

    public void setLogisticTypeList(List<String> logisticTypeList) {
        this.logisticTypeList = logisticTypeList;
    }
}
