/**
 * @(#) ItemSearchQueryReqDto.java 1.0 2019-01-09
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.List;

/**
 * 商品查询入参Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ItemSearchQueryReqDto", description = "商品查询入参Dto")
public class ItemSearchQueryReqDto extends BaseReqDto {

    /**
     * 商品搜索关键词
     */
    @ApiModelProperty(name = "keyword", value = "商品搜索关键词")
    private String keyword;
    /**
     * 商品类型
     */
    @ApiModelProperty(name = "type", value = "商品类型")
    private Integer type;
    /**
     * 品牌ID
     */
    @ApiModelProperty(name = "brandId", value = "品牌ID")
    private Long brandId;
    /**
     * 在品牌id集合内查询(B端专用)
     */
    @ApiModelProperty(name = "inBrandIds", value = "在品牌id集合内查询(B端专用)")
    private List<Long> inBrandIds;
    /**
     * 商品属性
     */
    @ApiModelProperty(name = "prop", value = "商品属性，请求格式为：propName:propValue;propName:propValue")
    private String prop;

    /**
     * 商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    /**
     * 商品id集
     */
    @ApiModelProperty(name = "itemIds", value = "商品ID集")
    private List<Long> itemIds;

    /**
     * 在商品id集合内查询
     */
    @ApiModelProperty(name = "inItemIds", value = "在商品id集合内查询")
    private List<Long> inItemIds;

    /**
     * 在商品id集合外查询
     */
    @ApiModelProperty(name = "outItemIds", value = "在商品id集合外查询")
    private List<Long> outItemIds;

    /**
     * 按该值降序排列查询(目前支持，sales、price、shelfTime)，不可和orderBy同时使用，同时使用时默认使用orderByDesc
     */
    @ApiModelProperty(name = "orderByDesc", value = "按该值降序排列查询(目前支持，sales、price、shelfTime)，不可和orderBy同时使用，同时使用时默认使用orderByDesc")
    private String orderByDesc;
    /**
     * 按该值升序排列查询(目前支持，sales、price、shelfTime)，不可和orderByDesc同时使用，同时使用时默认使用orderByDesc
     */
    @ApiModelProperty(name = "orderBy", value = "按该值升序排列查询(目前支持，sales、price、shelfTime)，不可和orderByDesc同时使用，同时使用时默认使用orderByDesc")
    private String orderBy;
    /**
     * 最大价格
     */
    @ApiModelProperty(name = "maxPrice", value = "最大价格")
    private Double maxPrice;
    /**
     * 最小价格
     */
    @ApiModelProperty(name = "minPrice", value = "最小价格")
    private Double minPrice;

    /**
     * 类目id集
     */
    @ApiModelProperty(name = "dirIds", value = "类目id集")
    private List<Long> dirIds;

    private String neType;

    /**
     * 搜索响应属性
     */
    @ApiModelProperty(name = "search", value = "是否响应商品attributesList商品属性列表及directoryItemList商品目录列表,默认true")
    private Boolean search = true;

    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购  默认0")
    private Integer busType;
    @ApiModelProperty(name = "lon", value = "经度")
    private Double lon;
    @ApiModelProperty(name = "lat", value = "纬度")
    private Double lat;
    @ApiModelProperty(name = "filterShop", value = "是否过滤店铺：如果选择过滤，会选择最近的店铺过滤,默认true")
    private Boolean filterShop;
    @ApiModelProperty(name = "itemType", value = "1普通商品 2积分商品")
    private Integer itemType;
    @ApiModelProperty(name = "shopIds", value = "店铺id列表")
    private List<Long> shopIds;
    @ApiModelProperty(name = "busTypeList", value = "商品业务类型列表,优先级大于单个")
    private List<Integer> busTypeList;
    @ApiModelProperty(name = "status", value = "商品状态 0已发布 1上架 2下架 3未发布 4已禁用")
    private Integer status;


    @ApiModelProperty(name = "isOffShelf", value = "是否过滤下架商品：默认true")
    private Boolean isOffShelf = true;

       @ApiModelProperty(name = "distribType", value = "分销员类型：1佣金分销，2加价分销,如果是分销员，该值不能为空")
    private Integer distribType;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "backDirId", value = "后端类目id")
    private Long backDirId;

    @ApiModelProperty(name = "backDirId", value = "商品sku编码")
    private String itemSkuCode;

    @ApiModelProperty(name = "updateBeginTime", value = "商品(商品库)更新开始时间")
    private String updateBeginTime;

    @ApiModelProperty(name = "updateEndTime", value = "商品(商品库)更新结束时间")
    private String updateEndTime;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "subTypeList", value = "商品子类型，1-产品，2-赠品，3-物料，多选")
    private List<Integer> subTypeList;

    @ApiModelProperty(name = "dosageForm", value = "剂型")
    private String dosageForm;

    public String getDosageForm() {
        return dosageForm;
    }

    public void setDosageForm(String dosageForm) {
        this.dosageForm = dosageForm;
    }

    public List<Integer> getSubTypeList() {
        return subTypeList;
    }

    public void setSubTypeList(List<Integer> subTypeList) {
        this.subTypeList = subTypeList;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Integer getDistribType() {
        return distribType;
    }

    public void setDistribType(Integer distribType) {
        this.distribType = distribType;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Boolean getFilterShop() {
        return filterShop;
    }

    public void setFilterShop(Boolean filterShop) {
        this.filterShop = filterShop;
    }

    public Double getLon() {
        return lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Double getLat() {
        return lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getProp() {
        return prop;
    }

    public void setProp(String prop) {
        this.prop = prop;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public Double getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(Double maxPrice) {
        this.maxPrice = maxPrice;
    }

    public Double getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(Double minPrice) {
        this.minPrice = minPrice;
    }

    public List<Long> getDirIds() {
        return dirIds;
    }

    public void setDirIds(List<Long> dirIds) {
        this.dirIds = dirIds;
    }

    public List<Long> getItemIds() {
        return itemIds;
    }

    public void setItemIds(List<Long> itemIds) {
        this.itemIds = itemIds;
    }

    public List<Long> getInItemIds() {
        return inItemIds;
    }

    public void setInItemIds(List<Long> inItemIds) {
        this.inItemIds = inItemIds;
    }

    public String getNeType() {
        return neType;
    }

    public void setNeType(String neType) {
        this.neType = neType;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Boolean getSearch() {
        return search;
    }

    public void setSearch(Boolean search) {
        this.search = search;
    }

    public List<Long> getShopIds() {
        return shopIds;
    }

    public void setShopIds(List<Long> shopIds) {
        this.shopIds = shopIds;
    }

    public List<Integer> getBusTypeList() {
        return busTypeList;
    }

    public void setBusTypeList(List<Integer> busTypeList) {
        this.busTypeList = busTypeList;
    }

    public List<Long> getOutItemIds() {
        return outItemIds;
    }

    public void setOutItemIds(List<Long> outItemIds) {
        this.outItemIds = outItemIds;
    }

    public List<Long> getInBrandIds() {
        return inBrandIds;
    }

    public void setInBrandIds(List<Long> inBrandIds) {
        this.inBrandIds = inBrandIds;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setIsOffShelf(Boolean isOffShelf) {
        this.isOffShelf = isOffShelf;
    }

    public Boolean getIsOffShelf() {
        return isOffShelf;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Long getBackDirId() {
        return backDirId;
    }

    public void setBackDirId(Long backDirId) {
        this.backDirId = backDirId;
    }

    public String getItemSkuCode() {
        return itemSkuCode;
    }

    public void setItemSkuCode(String itemSkuCode) {
        this.itemSkuCode = itemSkuCode;
    }

    public String getUpdateBeginTime() {
        return updateBeginTime;
    }

    public void setUpdateBeginTime(String updateBeginTime) {
        this.updateBeginTime = updateBeginTime;
    }

    public String getUpdateEndTime() {
        return updateEndTime;
    }

    public void setUpdateEndTime(String updateEndTime) {
        this.updateEndTime = updateEndTime;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}

