package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

@ApiModel(value = "ItemCycleBuyRespDto", description = "商品的周期购信息")
public class ItemCycleBuyRespDto {

    @ApiModelProperty(name = "shopId", value = "店铺ID", required = true)
    @NotNull(message = "店铺ID不能为空")
    private Long shopId;

    @ApiModelProperty(name = "itemId", value = "商品ID", required = true)
    @NotNull(message = "商品ID不能为空")
    private Long itemId;

    @ApiModelProperty(name = "deliveryType", value = "周期购配送类型: 0 按天, 1 按周, 2 按月", required = true)
    @NotNull(message = "周期购配送类型")
    private Integer deliveryType;

    @ApiModelProperty(name = "deliveryRate", value = "周期购配送频率", required = true)
    @NotNull(message = "周期购配送频率不能为空")
    private Integer[] deliveryRate;

    @ApiModelProperty(name = "currentDelivery", value = "是否支持当期配送")
    private Boolean currentDelivery;

    @ApiModelProperty(name = "latestDays", value = "当期配送的最晚提前下单天数")
    private Integer latestDays;

    @ApiModelProperty(name = "latestHour", value = "当期配送的最晚下单时间(小时)")
    private Integer latestHour;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Integer[] getDeliveryRate() {
        return deliveryRate;
    }

    public void setDeliveryRate(Integer[] deliveryRate) {
        this.deliveryRate = deliveryRate;
    }

    public Boolean getCurrentDelivery() {
        return currentDelivery;
    }

    public void setCurrentDelivery(Boolean currentDelivery) {
        this.currentDelivery = currentDelivery;
    }

    public Integer getLatestDays() {
        return latestDays;
    }

    public void setLatestDays(Integer latestDays) {
        this.latestDays = latestDays;
    }

    public Integer getLatestHour() {
        return latestHour;
    }

    public void setLatestHour(Integer latestHour) {
        this.latestHour = latestHour;
    }
}
