/*
 * @(#)ItemExtendOnShelfReqDto.java 1.0 2021年09月07日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemCycleBuyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemMediasReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Title:ItemExtendOnShelfReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/7 21:27
 * @since 0.1.0
 */
@ApiModel(value = "ItemExtendOnShelfReqDto", description = "商品上架信息DTO")
public class ItemExtendOnShelfReqDto extends BaseReqDto {

    @ApiModelProperty(
            name = "id",
            value = ""
    )
    private Long id;

    @ApiModelProperty(
            name = "busType",
            value = "上架业务类型：0普通商品 2 积分商品"
    )
    private Integer busType;

    @ApiModelProperty(
            name = "cashType",
            value = "兑换类型：1积分2积分+金额"
    )
    private Integer cashType;

    @ApiModelProperty(
            name = "商品的周期购信息"
    )
    private List<ItemCycleBuyReqDto> cycleBuyReqDtos;

    @ApiModelProperty(
            name = "freightTemplateId",
            value = "运费模板id"
    )
    private Long freightTemplateId;


    @ApiModelProperty(
            name = "freightTemplateId",
            value = "运费模板"
    )
    private String freightTemplateName;

    @ApiModelProperty(
            name = "frontDirIds",
            value = "前台类目"
    )
    private List<Long> frontDirIds;

    @ApiModelProperty(
            name = "itemType",
            value = "商品类型：同产品库的商品类型"
    )
    private Integer itemType;

    @ApiModelProperty(
            name = "pointDirIds"
    )
    private List<Integer> pointDirIds;

    @ApiModelProperty(
            name = "ruleRemark",
            value = "规则说明"
    )
    private String ruleRemark;

    @ApiModelProperty(
            name = "shopDirIds",
            value = "店铺List"
    )
    private List<Long> shopDirIds;

    @ApiModelProperty(
            name = "shopId",
            value = "店铺ID"
    )
    private Long shopId;

    @ApiModelProperty(
            name = "skus",
            value = "skus信息"
    )
    private List<ItemExtendSkuReqDto> skus = new ArrayList<>();

    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "dirPrefixIds", value = "前台类目数组")
    private List<String> dirPrefixIds;

    @ApiModelProperty(name = "dirPrefixId", value = "前台类目")
    private Long dirPrefixId;

    @ApiModelProperty(name = "dirPrefixName", value = "前台类目名称")
    private String dirPrefixName;

    @ApiModelProperty(
            name = "skuId",
            value = "skuId，选填，为空时会上架商品的所有规格，填写为只上架该商品的该规格"
    )
    private Long skuId;

    @ApiModelProperty(name = "domesticB2b", value = "国内B2B卖点")
    private String domesticB2b;

    @ApiModelProperty(name = "internalB2b", value = "国外B2B卖点")
    private String internalB2b;

    @ApiModelProperty(name = "specContent", value = "规格")
    private String specContent;

    @ApiModelProperty(
            name = "medias",
            value = "商品多媒体，选填，商品的多媒体信息"
    )
    private List<ItemMediasReqDto> medias;

    @ApiModelProperty(
            name = "brief",
            value = "描述”，富文本格式，选填"
    )
    private String brief;

    @ApiModelProperty(
            name = "extInfo",
            value = "附加信息，选填"
    )
    private String extInfo;


    @ApiModelProperty(
            name = "organizationId",
            value = "组织Id"
    )
    private Long organizationId;
    @ApiModelProperty(
            name = "organizationName",
            value = "组织名称"
    )
    private String organizationName;
    @ApiModelProperty(
            name = "shelfAddress",
            value = "上架地址(0:国内B2B商城,1:国外B2B商城)"
    )
    private String shelfAddress;
    /**
     *  虚拟商品
     */
    @ApiModelProperty(name = "vitrual", value = "虚拟商品")
    private String vitrual;

    public String getVitrual() {
        return vitrual;
    }

    public void setVitrual(String vitrual) {
        this.vitrual = vitrual;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Integer getCashType() {
        return cashType;
    }

    public void setCashType(Integer cashType) {
        this.cashType = cashType;
    }

    public List<ItemCycleBuyReqDto> getCycleBuyReqDtos() {
        return cycleBuyReqDtos;
    }

    public void setCycleBuyReqDtos(List<ItemCycleBuyReqDto> cycleBuyReqDtos) {
        this.cycleBuyReqDtos = cycleBuyReqDtos;
    }

    public Long getFreightTemplateId() {
        return freightTemplateId;
    }

    public void setFreightTemplateId(Long freightTemplateId) {
        this.freightTemplateId = freightTemplateId;
    }

    public String getFreightTemplateName() {
        return freightTemplateName;
    }

    public void setFreightTemplateName(String freightTemplateName) {
        this.freightTemplateName = freightTemplateName;
    }

    public List<Long> getFrontDirIds() {
        return frontDirIds;
    }

    public void setFrontDirIds(List<Long> frontDirIds) {
        this.frontDirIds = frontDirIds;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public List<Integer> getPointDirIds() {
        return pointDirIds;
    }

    public void setPointDirIds(List<Integer> pointDirIds) {
        this.pointDirIds = pointDirIds;
    }

    public String getRuleRemark() {
        return ruleRemark;
    }

    public void setRuleRemark(String ruleRemark) {
        this.ruleRemark = ruleRemark;
    }

    public List<Long> getShopDirIds() {
        return shopDirIds;
    }

    public void setShopDirIds(List<Long> shopDirIds) {
        this.shopDirIds = shopDirIds;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public List<ItemExtendSkuReqDto> getSkus() {
        return skus;
    }

    public void setSkus(List<ItemExtendSkuReqDto> skus) {
        this.skus = skus;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getDomesticB2b() {
        return domesticB2b;
    }

    public void setDomesticB2b(String domesticB2b) {
        this.domesticB2b = domesticB2b;
    }

    public String getInternalB2b() {
        return internalB2b;
    }

    public void setInternalB2b(String internalB2b) {
        this.internalB2b = internalB2b;
    }

    public String getSpecContent() {
        return specContent;
    }

    public void setSpecContent(String specContent) {
        this.specContent = specContent;
    }

    public List<ItemMediasReqDto> getMedias() {
        return medias;
    }

    public void setMedias(List<ItemMediasReqDto> medias) {
        this.medias = medias;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }


    public Long getDirPrefixId() {
        return dirPrefixId;
    }

    public void setDirPrefixId(Long dirPrefixId) {
        this.dirPrefixId = dirPrefixId;
    }

    public String getDirPrefixName() {
        return dirPrefixName;
    }

    public void setDirPrefixName(String dirPrefixName) {
        this.dirPrefixName = dirPrefixName;
    }

    public String getShelfAddress() {
        return shelfAddress;
    }

    public void setShelfAddress(String shelfAddress) {
        this.shelfAddress = shelfAddress;
    }

    public List<String> getDirPrefixIds() {
        return dirPrefixIds;
    }

    public void setDirPrefixIds(List<String> dirPrefixIds) {
        this.dirPrefixIds = dirPrefixIds;
    }
}
