package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
* 商品扩展参数表Eo对象
*
* @author yuangui
* @since 2022-05-11
*/
@Data
@ApiModel(value = "ItemExtendRespDto", description = "商品扩展参数表Eo对象")
public class ItemExtendRespDto extends BaseRespDto{
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  编码
    */
    @ApiModelProperty(name = "itemCode", value = "编码")
    private String itemCode;

    /**
     * e3物料编码
     */
    @ApiModelProperty(name = "e3ItemCode", value = "e3物料编码")
    private String e3ItemCode;

    /**
    *  长度
    */
    @ApiModelProperty(name = "length", value = "长度")
    private BigDecimal length;
    /**
    *  高度
    */
    @ApiModelProperty(name = "height", value = "高度")
    private BigDecimal height;
    /**
    *  宽度
    */
    @ApiModelProperty(name = "width", value = "宽度")
    private BigDecimal width;
    /**
    *  长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
    */
    @ApiModelProperty(name = "lengthUnit", value = "长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String lengthUnit;
    /**
    *  高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
    */
    @ApiModelProperty(name = "heightUnit", value = "高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String heightUnit;
    /**
    *  宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
    */
    @ApiModelProperty(name = "widthUnit", value = "宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String widthUnit;
    /**
    *  体积
    */
    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;
    /**
    *  体积单独
    */
    @ApiModelProperty(name = "volumnUnit", value = "体积单独")
    private String volumnUnit;
    /**
    *  毛重
    */
    @ApiModelProperty(name = "grossWeight", value = "毛重")
    private BigDecimal grossWeight;
    /**
    *  毛重单位
    */
    @ApiModelProperty(name = "grossWeightUnit", value = "毛重单位")
    private String grossWeightUnit;
    /**
    *  净重
    */
    @ApiModelProperty(name = "netWeight", value = "净重")
    private BigDecimal netWeight;
    /**
    *  净重单位
    */
    @ApiModelProperty(name = "netWeightUnit", value = "净重单位")
    private String netWeightUnit;
    /**
    *  重量
    */
    @ApiModelProperty(name = "quantity", value = "重量")
    private BigDecimal quantity;
    /**
    *  重量单位
    */
    @ApiModelProperty(name = "quantityUnit", value = "重量单位")
    private String quantityUnit;
    /**
    *  大包系数
    */
    @ApiModelProperty(name = "bigRatio", value = "大包系数")
    private Long bigRatio;
    /**
    *  中包系数
    */
    @ApiModelProperty(name = "middleRatio", value = "中包系数")
    private Long middleRatio;
    /**
    *  小包系数
    */
    @ApiModelProperty(name = "smallRatio", value = "小包系数")
    private Long smallRatio;
    /**
    *  防伪码
    */
    @ApiModelProperty(name = "securityCode", value = "防伪码")
    private String securityCode;
    /**
    *  保质期
    */
    @ApiModelProperty(name = "expirationDate", value = "保质期")
    private String expirationDate;
    /**
    *  保质期单位
    */
    @ApiModelProperty(name = "expirationUnit", value = "保质期单位")
    private String expirationUnit;
    /**
    *  是否免检
    */
    @ApiModelProperty(name = "exemption", value = "是否免检")
    private String exemption;

    private String specifications;
    private BigDecimal recommendPrice;
    private String imeiCodeFlag;
    private String standardApproval;
    private Integer itemDrug;

    @ApiModelProperty(name = "storageCondition", value = "存储条件")
    private String storageCondition;

    @ApiModelProperty(name = "saleUnit", value = "销售单位")
    private String saleUnit;

    /**
     *  索赔价格
     */
    @ApiModelProperty(name = "claimPrice", value = "索赔价格")
    private BigDecimal claimPrice;


    @ApiModelProperty(name = "itemType", value = "商品类型")
    private String itemType;

    @ApiModelProperty(name = "typeDescribe", value = "类型描述")
    private String typeDescribe;

    /**
     *  大包箱数
     */
    @ApiModelProperty(name = "bigBox",value = "大包箱数")
    private Long bigBox;
    /**
     *  中包系数
     */
    @ApiModelProperty(name = "middleMax",value = "中包箱数")
    private Long middleMax;
    /**
     *  小包箱数
     */
    @ApiModelProperty(name = "smallBox",value = "小包箱数")
    private Long smallBox;

    /**
     * 过敏原
     */
    @ApiModelProperty(name = "pictureNumber",value = "过敏原")
    private String pictureNumber;

    /**
     * 添加剂
     */
    @ApiModelProperty(name = "cfadditive",value = "添加剂")
    private String cfadditive;

    /**
     * 货品属性 成品/半成品
     */
    @ApiModelProperty(name = "property",value = "货品属性 成品/半成品")
    private String property;

    /**
     * 预警期 天
     */
    @ApiModelProperty(name = "alertLeadingDays",value = "预警期 天")
    private Integer alertLeadingDays;

    /**
     * 销售投保单价
     */
    @ApiModelProperty(name = "saleInsurePrice",value = "销售投保单价")
    private BigDecimal saleInsurePrice;

    /**
     * 进口代码
     */
    @ApiModelProperty(name = "importsCode",value = "进口代码")
    private String importsCode;

    /**
     * 码盘箱数
     */
    @ApiModelProperty(name = "palletSoildQuantity",value = "码盘箱数")
    private Integer palletSoildQuantity;

    /**
     * 物料描述
     */
    @ApiModelProperty(name = "description",value = "物料描述")
    private String description;
}
