/*
 * @(#)InventoryException.java 1.0 2018-08-22
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 商品属性响应Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "ItemAttributesRespDto", description = "商品属性响应Dto")
public class ItemAttributesRespDto extends BaseRespDto {

    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;

    /**
     * 商品id
     */
    @ApiModelProperty(name = "itemId",value = "商品ID")
    private Long itemId;

    /**
     * 商品属性
     */
    @ApiModelProperty(name = "attrs",value = "属性")
    private String attrs;

    /**
     * 附加属性
     */
    @ApiModelProperty(name = "searchAttrs",value = "附加属性")
    private String searchAttrs;

    /**
     * 实例ID
     */
    @ApiModelProperty(name = "appInstanceId",value = "实例ID")
    private Long appInstanceId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getAttrs() {
        return attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public String getSearchAttrs() {
        return searchAttrs;
    }

    public void setSearchAttrs(String searchAttrs) {
        this.searchAttrs = searchAttrs;
    }

    public Long getAppInstanceId() {
        return appInstanceId;
    }

    public void setAppInstanceId(Long appInstanceId) {
        this.appInstanceId = appInstanceId;
    }
}