/**
 * @(#)OffItemReqDto 1.0 2019/3/21
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author shuangqing  2019/3/21
 */
@Data
public class OffItemReqDto extends BaseReqDto {
    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "itemId", value = "商品id，必填")
    private Long itemId;

    @ApiModelProperty(name = "skuId", value = "规格Id，选填，填写时只下架该规格")
    private Long skuId;

    @ApiModelProperty(name = "dirId", value = "目录id，选填，填写时只下架该目录的商品(商品可能会上架在多个目录)")
    private Long dirId;

    @ApiModelProperty(name = "shopId", value = "店铺id，必填")
    private Long shopId;

    @ApiModelProperty(name = "snapshotId", value = "快照id，选填")
    private Long snapshotId;

    @ApiModelProperty(name = "isTiming", value = "是否定时下架 true/false，选填")
    private boolean isTiming;

    @ApiModelProperty(name = "offTime", value = "定时下架时间，选填，配合isTiming使用，当isTiming为true时")
    private Date offTime;
    @ApiModelProperty(name = "itemType", value = "商品类型:1普通商品 2积分商品")
    private Integer itemType;
    @ApiModelProperty(name = "busType", value = "上架业务类型：0普通商品 1社区团购 2 积分商品")
    private Integer busType;

    @ApiModelProperty(name = "shopAuth", value = "商品sku是否已取消店铺授权：0否 1是")
    private Integer shopAuth;

    @ApiModelProperty(name = "shelfAddress", value = "上架地址(0:国内B2B商城,1:国外B2B商城),不传默认国内")
    private String shelfAddress;
}