/**
 * @(#) IExampleService.java 1.1.0 2018-08-20
 * <p>
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 批量修改上架信息的店铺授权标识dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "ShelfModifyShopAuthReqDto", description = "批量修改上架信息的店铺授权标识dto")
public class ShelfModifyShopAuthReqDto extends BaseReqDto {

    @ApiModelProperty(name = "skuIds", value = "skuId集合")
    private List<Long> skuIds;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(name = "shopAuth", value = "商品sku是否已取消店铺授权：0否 1是")
    private Integer shopAuth;

    public List<Long> getSkuIds() {
        return skuIds;
    }

    public void setSkuIds(List<Long> skuIds) {
        this.skuIds = skuIds;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Integer getShopAuth() {
        return shopAuth;
    }

    public void setShopAuth(Integer shopAuth) {
        this.shopAuth = shopAuth;
    }
}
