/**
 * @(#) IExampleService.java 1.1.0 2018-08-20
 * <p>
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 标签请求参数Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "TagReqDto", description = "标签请求参数Dto")
public class TagReqDto extends BaseReqDto {
    /**
     * 主键ID
     */
    @ApiModelProperty(name = "id", value = "主键id，新增时可选，修改时必填")
    private Long id;
    /**
     * 状态
     */
    @ApiModelProperty(name = "status", value = "0禁用 1启用，选填")
    private Integer status;
    /**
     * 关键字
     */
    @NotNull(message = "标签关键字不能为空")
    @ApiModelProperty(name = "keywords", value = "关键字，必填")
    private String keywords;
    /**
     * 创建开始时间
     */
    @ApiModelProperty(name = "createBeginTime", value = "创建开始时间，查询时使用")
    private String createBeginTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(name = "createEndTime", value = "创建结束时间，查询时使用")
    private String createEndTime;
    /**
     * 更新开始时间
     */
    @ApiModelProperty(name = "updateBeginTime", value = "更新开始时间，查询时使用")
    private String updateBeginTime;
    /**
     * 更新结束时间
     */
    @ApiModelProperty(name = "updateEndTime", value = "更新结束时间，查询时使用")
    private String updateEndTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreateBeginTime() {
        return createBeginTime;
    }

    public void setCreateBeginTime(String createBeginTime) {
        this.createBeginTime = createBeginTime;
    }

    public String getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(String createEndTime) {
        this.createEndTime = createEndTime;
    }

    public String getUpdateBeginTime() {
        return updateBeginTime;
    }

    public void setUpdateBeginTime(String updateBeginTime) {
        this.updateBeginTime = updateBeginTime;
    }

    public String getUpdateEndTime() {
        return updateEndTime;
    }

    public void setUpdateEndTime(String updateEndTime) {
        this.updateEndTime = updateEndTime;
    }

    /**
     * 品牌请求Dto
     *
     * @author 风影
     * @since 2.0.0
     */
    @ApiModel(value = "BrandReqDto", description = "品牌请求信息")
    public static class BrandReqDto extends BaseReqDto {
        /**
         * 品牌id
         */
        @ApiModelProperty(name = "code", value = "品牌id，新增时不填，修改时必填")
        private Long id;
        /**
         * 品牌编码
         */
        @ApiModelProperty(name = "code", value = "品牌code，选填")
        private String code;
        /**
         * 品牌商名称
         */
        @ApiModelProperty(name = "name", value = "品牌名称，必填")
        private String name;
        /**
         * 多媒体url
         */
        @ApiModelProperty(name = "logoUrl", value = "多媒体url，选填")
        private String logoUrl;
        /**
         * 官方地址
         */
        @ApiModelProperty(name = "homePageUrl", value = "官方地址，选填")
        private String homePageUrl;
        /**
         * 状态 0 禁用 1 启用
         */
        @ApiModelProperty(name = "status", value = "状态 0 禁用 1 启用，选填")
        private Integer status;
        /**
         * 品牌简述
         */
        @ApiModelProperty(name = "brief", value = "品牌简述，选填")
        private String brief;
        /**
         * 所属人ID
         */
        @ApiModelProperty(name = "ownerId", value = "所属人ID，选填")
        private Long ownerId;
        /**
         * 品牌详情
         */
        @ApiModelProperty(name = "detail", value = "品牌商详情，选填")
        private String detail;
        /**
         * 创建开始时间
         */
        @ApiModelProperty(name = "createBeginTime", value = "创建开始时间，查询使用")
        private String createBeginTime;
        /**
         * 创建结束时间
         */
        @ApiModelProperty(name = "createEndTime", value = "创建结束时间，查询使用")
        private String createEndTime;
        /**
         * 更新开始时间
         */
        @ApiModelProperty(name = "updateBeginTime", value = "更新开始时间，查询使用")
        private String updateBeginTime;
        /**
         * 更新结束时间
         */
        @ApiModelProperty(name = "updateEndTime", value = "更新结束时间，查询使用")
        private String updateEndTime;

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLogoUrl() {
            return logoUrl;
        }

        public void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        public String getHomePageUrl() {
            return homePageUrl;
        }

        public void setHomePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
        }

        public Integer getStatus() {
            return status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getBrief() {
            return brief;
        }

        public void setBrief(String brief) {
            this.brief = brief;
        }

        public Long getOwnerId() {
            return ownerId;
        }

        public void setOwnerId(Long ownerId) {
            this.ownerId = ownerId;
        }

        public String getDetail() {
            return detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public String getCreateBeginTime() {
            return createBeginTime;
        }

        public void setCreateBeginTime(String createBeginTime) {
            this.createBeginTime = createBeginTime;
        }

        public String getCreateEndTime() {
            return createEndTime;
        }

        public void setCreateEndTime(String createEndTime) {
            this.createEndTime = createEndTime;
        }

        public String getUpdateBeginTime() {
            return updateBeginTime;
        }

        public void setUpdateBeginTime(String updateBeginTime) {
            this.updateBeginTime = updateBeginTime;
        }

        public String getUpdateEndTime() {
            return updateEndTime;
        }

        public void setUpdateEndTime(String updateEndTime) {
            this.updateEndTime = updateEndTime;
        }
    }
}
