package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemRundleSupplyPriceRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>Titile:IRItemRundleSupplyPriceQueryApi</p>
 *
 * @author liangjiu
 * @date 2023/3/910:07
 */
@Api(tags = {"商品中心：套餐子商品供价"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-item-api-query-IRItemRundleSupplyPriceQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/item/supplyPrice",
        url = "${yundt.cube.center.item.api:}"
)
public interface IRItemRundleSupplyPriceQueryApi {

    /**
     * 根据子商品编码列表和客户编码查询供货价
     * @param subItemCodes 子商品编码列表
     * @param customerCode 客户编码
     * @return
     */
    @PostMapping("/queryBundleItemSupplyPriceList")
    @ApiOperation(value = "根据商品编码列表查询组合商品集合", notes = "根据商品编码列表查询组合商品集合")
    RestResponse<List<ItemRundleSupplyPriceRespDto>> queryBundleItemSupplyPriceList(@RequestBody List<String> subItemCodes,
                                                                                    @RequestParam(required = true) String customerCode);

}
