//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@ApiModel(
    value = "ItemAuthAddBatchRespDto",
    description = "商品授权批量操作"
)
public class ItemAuthAddBatchRespDto extends BaseRespDto {
    @NotNull(
        message = "目标类型不允许为空"
    )
    @ApiModelProperty(
        name = "targetType",
        value = "目标类型，1-客户，2-店铺",
        required = true
    )
    private Integer targetType;
    @NotNull(
        message = "目标id不允许为空"
    )
    @ApiModelProperty(
        name = "targetId",
        value = "目标id(根据target_type)，如客户id，店铺id",
        required = true
    )
    private Long targetId;
    @NotBlank(
        message = "业务类型不允许为空"
    )
    @ApiModelProperty(
        name = "businessType",
        value = "业务类型（CATEGORY：类目、BRAND：品牌、SKU：商品sku、BANSKU：禁止的商品sku）",
        required = true
    )
    private String businessType;
    @NotEmpty(
        message = "业务ID不允许为空"
    )
    @ApiModelProperty(
        name = "businessIdList",
        value = "业务ID（类目，品牌，商品sku，禁止的商品sku等ID）",
        required = true
    )
    private List<Long> businessIdList;

    public ItemAuthAddBatchRespDto() {
    }

    public Integer getTargetType() {
        return this.targetType;
    }

    public void setTargetType(Integer targetType) {
        this.targetType = targetType;
    }

    public Long getTargetId() {
        return this.targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public List<Long> getBusinessIdList() {
        return this.businessIdList;
    }

    public void setBusinessIdList(List<Long> businessIdList) {
        this.businessIdList = businessIdList;
    }
}
