package com.dtyunxi.yundt.cube.center.item.api.b2b.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.MatchAuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.AuthItemRuleRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 客户商品授权规则服务接口
 *
 * @author cijian
 * @since 2022-11-14
 */
@Api(tags = {"客户商品授权规则服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-icom-bundle-base-center-item-api-api-query-IAuthItemRuleQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/auth/item/rule",
        url = "${yundt.cube.center.item.api:}"
)
public interface IAuthItemRuleQueryApi {

    /**
     * 根据id查询客户商品授权规则
     *
     * @param id 客户商品授权规则id
     * @return 客户商品授权规则数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询客户商品授权规则", notes = "根据id查询客户商品授权规则")
    RestResponse<AuthItemRuleRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据客户id查询客户商品授权规则
     *
     * @param customerId 客户id
     * @return   客户商品授权规则数据
     */
    @GetMapping("/queryByCustomerId")
    @ApiOperation(value = "根据客户id查询客户商品授权规则", notes = "根据客户id查询客户商品授权规则")
    RestResponse<AuthItemRuleRespDto> queryByCustomerId(@RequestParam("customerId") Long customerId);

    /**
     * 客户商品授权规则分页数据
     *
     * @return 客户商品授权规则分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "客户商品授权规则分页数据", notes = "根据查询条件查询客户商品授权规则数据")
    RestResponse<PageInfo<AuthItemRuleRespDto>> queryByPage(@RequestBody AuthItemRuleReqDto authItemRuleReqDto);

    /**
     * 查询指定商品已授权客户
     *
     * @return 根据商品信息查询已授权客户
     */
    @PostMapping("/match/page")
    @ApiOperation(value = "查询指定商品已授权客户", notes = "查询指定商品已授权客户")
    RestResponse<PageInfo<AuthItemRuleRespDto>> queryRulePageByCondition(@RequestBody @Valid MatchAuthItemRuleReqDto matchAuthItemRuleReqDto);

}
