package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 商品转换关系记录表Eo对象
 *
 * @author author
 * @since 2022-09-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ItemUnitRecordReqDto", description = "商品转换关系记录表Eo对象")
public class ItemUnitRecordReqDto extends RequestDto {
    /**
     *  类型
     */
    @ApiModelProperty(name = "type", value = "类型（表明）")
    private String type;
    /**
     *  单据编码
     */
    @ApiModelProperty(name = "documentCode", value = "单据编码")
    private String documentCode;
    /**
     *  商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    /**
     *  批次
     */
    @ApiModelProperty(name = "itemBatch", value = "批次")
    private String itemBatch;
    /**
     *  商品数量
     */
    @ApiModelProperty(name = "itemNum", value = "商品数量")
    private BigDecimal itemNum;
    /**
     *  商品单位
     */
    @ApiModelProperty(name = "itemUnit", value = "商品单位")
    private String itemUnit;
    /**
     *  商品单价-原始单价
     */
    @ApiModelProperty(name = "itemPrice", value = "商品单价-原始单价")
    private BigDecimal itemPrice;
    /**
     *  商品单位
     */
    @ApiModelProperty(name = "toItemUnit", value = "转换方商品单位(不填)")
    private String toItemUnit;
}