/*
 * @(#)ItemBundlesReqDto.java 1.0 2021年10月06日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>Title:ItemBundlesReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/10/6 0:10
 * @since 0.1.0
 */
@ApiModel(value = "ItemBundlesRespDto",description = "ItemBundlesRespDto对象")
public class ItemBundlesRespDto extends RequestDto {

    @ApiModelProperty(name = "id", value = "")
    private Long id;
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    @ApiModelProperty(name = "itemCode", value = "商品编码，系统自动生成")
    private String itemCode;
    @NotNull(message = "商品名称不能为空")
    @Length(max = 100,message = "商品名称不能超过100个字符")
    @ApiModelProperty(name = "itemName", value = "商品名称，必填，支持修改，不超过50个字")
    private String itemName;
    @ApiModelProperty(name = "dirIds", value = "后台类目数组")
    private List<String> dirIds;
    @NotNull(message = "后台类目不能为空")
    @ApiModelProperty(name = "dirId", value = "后台类目ID")
    private Long dirId;
    @ApiModelProperty(name = "dirName", value = "后台类目名称")
    private String dirName;
    @NotNull(message = "前台类目不能为空")
    @ApiModelProperty(name = "dirPrefixId", value = "前台类目ID")
    private Long dirPrefixId;
    @ApiModelProperty(name = "dirPrefixName", value = "前台类目名称")
    private String dirPrefixName;
    @ApiModelProperty(name = "dirPrefixIds", value = "前台类目数组")
    private List<String> dirPrefixIds;
    @ApiModelProperty(name = "bundleReqDtos", value = "组合商品List")
    private List<RItemBundleRespDto> bundleReqDtos;
    @ApiModelProperty(name = "domesticB2b", value = "国内B2B卖点")
    private String domesticB2b;
    @ApiModelProperty(name = "internalB2b", value = "国外B2B卖点")
    private String internalB2b;
    @ApiModelProperty(name = "specContent", value = "规格")
    private String specContent;
    @ApiModelProperty(name = "medias", value = "商品主图、视频")
    private List<ItemMediasRespDto> medias;
    @ApiModelProperty(name = "brief", value = "商品介绍")
    private String brief;

    /**
     * 单价
     */
    @ApiModelProperty(name = "unitPrice",value = "单价")
    private BigDecimal unitPrice;

    /**
     * 总价
     */
    @ApiModelProperty(name = "totalPrice",value = "总价")
    private BigDecimal totalPrice;

    @ApiModelProperty(name = "saleGroup", value = "销售组")
    private String saleGroup;

    @ApiModelProperty(name = "prodLargeClass", value = "产品大类")
    private String prodLargeClass;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public Long getDirPrefixId() {
        return dirPrefixId;
    }

    public void setDirPrefixId(Long dirPrefixId) {
        this.dirPrefixId = dirPrefixId;
    }

    public String getDirPrefixName() {
        return dirPrefixName;
    }

    public void setDirPrefixName(String dirPrefixName) {
        this.dirPrefixName = dirPrefixName;
    }


    public String getDomesticB2b() {
        return domesticB2b;
    }

    public void setDomesticB2b(String domesticB2b) {
        this.domesticB2b = domesticB2b;
    }

    public String getInternalB2b() {
        return internalB2b;
    }

    public void setInternalB2b(String internalB2b) {
        this.internalB2b = internalB2b;
    }

    public String getSpecContent() {
        return specContent;
    }

    public void setSpecContent(String specContent) {
        this.specContent = specContent;
    }



    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public List<RItemBundleRespDto> getBundleReqDtos() {
        return bundleReqDtos;
    }

    public void setBundleReqDtos(List<RItemBundleRespDto> bundleReqDtos) {
        this.bundleReqDtos = bundleReqDtos;
    }

    public List<ItemMediasRespDto> getMedias() {
        return medias;
    }

    public void setMedias(List<ItemMediasRespDto> medias) {
        this.medias = medias;
    }

    public List<String> getDirIds() {
        return dirIds;
    }

    public void setDirIds(List<String> dirIds) {
        this.dirIds = dirIds;
    }

    public List<String> getDirPrefixIds() {
        return dirPrefixIds;
    }

    public void setDirPrefixIds(List<String> dirPrefixIds) {
        this.dirPrefixIds = dirPrefixIds;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public String getSaleGroup() {
        return saleGroup;
    }

    public void setSaleGroup(String saleGroup) {
        this.saleGroup = saleGroup;
    }

    public String getProdLargeClass() {
        return prodLargeClass;
    }

    public void setProdLargeClass(String prodLargeClass) {
        this.prodLargeClass = prodLargeClass;
    }
}
