package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.CollectionItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.CollectionQueryReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 商品|收藏商品定义服务接口
 *
 * @author yiyun
 * @since 2021-10-08
 */
@Api(tags = {"商品中心：收藏商品定义服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-item-api-query-ICollectionExtItemQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/ext/collection",
        url = "${yundt.cube.center.item.api:}"
)
public interface ICollectionExtQueryApi {

    /**
     * 我的收藏分页
     * @param queryReqDto
     * @return
     */
    @PostMapping("/collection/page")
    @ApiOperation(value = "我的收藏分页", notes = "我的收藏分页")
    RestResponse<PageInfo<CollectionItemRespDto>> queryItemCollectionPage(@RequestBody CollectionQueryReqDto queryReqDto);


}
