/**
 * @(#) ItemStorageQueryReqDto.java 1.0 2018-12-04
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 商品库存查询Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ItemStorageQueryReqDto", description = "商品库存查询Dto")
public class ItemStorageQueryReqDto extends BaseReqDto {

    /**
     * 店铺ID
     */
    @NotNull(message = "店铺ID不允许为空")
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     * 渠道ID
     */
    @ApiModelProperty(name = "channelId", value = "渠道ID")
    private Long channelId;
    /**
     * skuId集合
     */
    @ApiModelProperty(name = "skuIds", value = "skuId集合")
    private List<Long> skuIds;
    /**
     * 库存有效日期(今天 未来 yyyy-MM-dd)
     */
    @ApiModelProperty(name = "inventoryEffectiveDate", value = "库存有效日期(今天 未来 yyyy-MM-dd)")
    private String inventoryEffectiveDate;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public List<Long> getSkuIds() {
        return skuIds;
    }

    public void setSkuIds(List<Long> skuIds) {
        this.skuIds = skuIds;
    }

    public String getInventoryEffectiveDate() {
        return inventoryEffectiveDate;
    }

    public void setInventoryEffectiveDate(String inventoryEffectiveDate) {
        this.inventoryEffectiveDate = inventoryEffectiveDate;
    }
}
