/**
 * @(#) IExampleService.java 1.1.0 2018-08-20
 * <p>
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 商品sku响应listDto
 *
 * @author 风影
 * @since 2.0.0
 */
@ApiModel(value = "ItemRespDto", description = "商品响应Dto")
public class ItemSkuListRespDto extends BaseRespDto {
    /**
     * 商品集合
     */
    @ApiModelProperty(name = "itemRespDtos", value = "商品集合")
    private List<ItemRespDto> itemRespDtos;
    /**
     * 商品sku集合
     */
    @ApiModelProperty(name = "itemSkuRespDtos", value = "商品sku集合")
    private List<ItemSkuRespDto> itemSkuRespDtos;

    public List<ItemRespDto> getItemRespDtos() {
        return itemRespDtos;
    }

    public void setItemRespDtos(List<ItemRespDto> itemRespDtos) {
        this.itemRespDtos = itemRespDtos;
    }

    public List<ItemSkuRespDto> getItemSkuRespDtos() {
        return itemSkuRespDtos;
    }

    public void setItemSkuRespDtos(List<ItemSkuRespDto> itemSkuRespDtos) {
        this.itemSkuRespDtos = itemSkuRespDtos;
    }
}
