package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
* 商品关系对照表Eo对象
*
* @author yiyun
* @since 2021-09-08
*/
@ApiModel(value = "ItemExtRelationComparisonReqDto", description = "商品关系对照表对象")
@Data
public class ItemExtRelationComparisonReqDto extends RequestDto {
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;

    /**
    *  所属渠道编码
    */
    @ApiModelProperty(name = "channelCode", value = "所属渠道编码")
    private String channelCode;

    /**
    *  所属渠道名称
    */
    @ApiModelProperty(name = "channelName", value = "所属渠道名称")
    private String channelName;
    /**
    *  所属店铺编码
    */
    @ApiModelProperty(name = "shopCode", value = "所属店铺编码")
    private String shopCode;

    /**
     * 所属店铺名称，多个店铺名称以逗号隔开
     */
    @ApiModelProperty(name = "shopName", value = "所属店铺名称")
    private String shopName;

    @ApiModelProperty(name = "channelItemId", value = "平台商品ID")
    private String channelItemId;
    /**
    *  渠道商品编码
    */
    @ApiModelProperty(name = "channelItemCode", value = "渠道商品编码")
    private String channelItemCode;
    /**
    *  渠道商品名称
    */
    @ApiModelProperty(name = "channelItemName", value = "渠道商品名称")
    private String channelItemName;

    @ApiModelProperty(name = "channelSkuId", value = "平台skuID")
    private String channelSkuId;
    /**
    *  渠道sku编码
    */
    @ApiModelProperty(name = "channelSkuCode", value = "渠道sku编码")
    private String channelSkuCode;
    /**
    *  渠道状态，0-关闭，1-开启
    */
    @ApiModelProperty(name = "channelStatus", value = "渠道状态，0-关闭，1-开启")
    private Integer channelStatus;
    /**
    *  渠道备注
    */
    @ApiModelProperty(name = "channelRemark", value = "渠道备注")
    private String channelRemark;
    /**
    *  商品编码
    */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    /**
     *  商品编码
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    /**
    *  sku编码
    */
    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;
    /**
    *  对照类型：0商品，1套餐
    */
    @ApiModelProperty(name = "relationType", value = "对照类型：0商品，1套餐")
    private Integer relationType;

    /**
     *  所属渠道
     */
    @ApiModelProperty(name = "channel", value = "渠道")
    private String channel;

    @ApiModelProperty(name = "channelItemJson", value = "平台拉取数据JSON")
    private String channelItemJson;

    @ApiModelProperty(name = "channelItemKey", value = "平台商品校验key")
    private String channelItemKey;
}
