package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ItemDataQueryRespDto", description = "商品数据DTO对象")
public class ItemDataQueryRespDto  extends BaseRespDto {

    @ApiModelProperty(name = "code", value = "商品编码")
    private String code;

    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;

    @ApiModelProperty(name = "specifications", value = "规格")
    private String specifications;

    @ApiModelProperty(name = "packageSpecification", value = "包装规格")
    private String packageSpecification;

    @ApiModelProperty(name = "outFactoryPrice", value = "出厂价格")
    private BigDecimal outFactoryPrice;

    @ApiModelProperty(name = "outFactoryUnit", value = "出厂价单位")
    private String outFactoryUnit;

    @ApiModelProperty(name = "unitList", value = "单位列表")
    private List<String> unitList;

    @ApiModelProperty(name = "conversionRespDtoList", value = "单位换算列表")
    private List<ItemUnitConversionRespDto> conversionRespDtoList;

    @ApiModelProperty(name = "taxRate", value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(name = "baseUnit", value = "基本单位")
    private String baseUnit;

    @ApiModelProperty(name = "saleUnit", value = "销售单位")
    private String saleUnit;

    @ApiModelProperty(name = "storageCondition", value = "存储条件")
    private String storageCondition;

    @ApiModelProperty(name = "productType", value = "产品类")
    private String productType;//'产品类',

    @ApiModelProperty(name = "productTypeDescribe", value = "产品类型名称")
    private String productTypeDescribe;

    @ApiModelProperty(name = "itemType",value = "商品类型")
    private String itemType;
    /**
     *  保质期
     */
    @ApiModelProperty(name = "expirationDate", value = "保质期")
    private String expirationDate;
    /**
     *  保质期单位
     */
    @ApiModelProperty(name = "expirationUnit", value = "保质期单位")
    private String expirationUnit;
}

