/**
 * @(#) IExampleService.java 1.1.0 2018-08-20
 * <p>
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.TagReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 标签增删改API接口
 *
 * @author 佐助
 * @since 2.0.0
 */
@Api(tags = {"商品中心：标签接口服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-base-IItemTagApi",
        path = "/v1/tag",
        url = "${yundt.cube.center.item.api:}")
public interface IItemTagApi {

    /**
     * 批量插入标签
     *
     * @param requestTags 标签请求参数Dto
     * @return 操作结果
     */
    @PostMapping(value = "/batch")
    @ApiOperation(value = "批量插入标签", notes = "批量插入标签")
    RestResponse<Void> addTagBatch(@Validated @RequestBody List<TagReqDto> requestTags);

    /**
     * 新增标签
     *
     * @param requestTag 标签Dto
     * @return RestResponse<Long> 主键ID
     */
    @PostMapping("")
    @ApiOperation(value = "新增标签", notes = "新增标签")
    RestResponse<Long> addTag(@Validated @RequestBody TagReqDto requestTag);

    /**
     * 修改标签
     *
     * @param requestTag 标签Dto
     * @return RestResponse<Long> 主键ID
     */
    @PutMapping("")
    @ApiOperation(value = "修改标签", notes = "修改标签")
    RestResponse<Long> modifyTag(@Validated @RequestBody TagReqDto requestTag);

    /**
     * 修改标签状态
     *
     * @param id
     * @param status
     * @return RestResponse
     */
    @PutMapping(value = "/{id}/status/{status}")
    @ApiOperation(value = "修改标签", notes = "修改标签，status=0禁用 1启用")
    RestResponse<Void> modifyTagStatus(@PathVariable("id") Long id, @PathVariable("status") Integer status);

    /**
     * 删除标签(逻辑删除)
     *
     * @param ids 标签ID
     * @return RestResponse 统一返回响应对象，业务数据data为空
     */
    @DeleteMapping(value = "/{ids}")
    @ApiOperation(value = "删除标签", notes = "删除标签")
    RestResponse<Void> removeTag(@NotNull(message = "标签id不能为空") @PathVariable("ids") String ids);
}
