package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 商品变更记录申请
 *
 * @author 风影
 * @since 2.0.0
 */

@ApiModel(value = "ItemChangeApplyDto", description = "商品变更记录申请")
public class ItemChangeApplyDto extends BaseReqDto {

    @ApiModelProperty(name = "changeId", value = "变更记录id  选填")
    private Long changeId;

    @ApiModelProperty(name = "name", value = "商品|产品名称itemName保持一致")
    private String itemName;
    @ApiModelProperty(name = "itemId", value = "商品id  必填")
    private Long itemId;
    @ApiModelProperty(name = "itemStatus", value = "商品状态")
    private  Integer itemStatus;
    @ApiModelProperty(name = "status", value = "状态,0草稿、1待审核、2审核通过、3审核不通过")
    private Integer status;
    @ApiModelProperty(name = "isAfterSale", value = "是否需要售后: 0否 1 是")
    private Integer isAfterSale;


    @ApiModelProperty(name = "displayName", value = "显示名称，选填")
    private String displayName;

    @ApiModelProperty(name = "code", value = "商品编码（条码），选填")
    private String itemCode;

    @ApiModelProperty(name = "brand", value = "品牌名称或品牌代码，选填")
    private String brand;

    @ApiModelProperty(name = "brandId", value = "品牌ID，选填")
    private Long brandId;

    @ApiModelProperty(name = "virtual", value = "是|否:虚拟商品标记，选填")
    private Boolean virtual;

    @ApiModelProperty(name = "brief", value = "简介”，富文本格式，选填")
    private String brief;

    @ApiModelProperty(name = "details", value = "详情:富文本格式，选填")
    private String detail;

    @ApiModelProperty(name = "returnType", value = "退货类型：1不可退 2手动可退 3过期自动退，选填")
    private Integer returnType;

    @ApiModelProperty(name = "allowReturnTime", value = "允许退货时间点，选填")
    private String allowReturnTime;

    @ApiModelProperty(name = "shelfAmount", value = "可卖数量=所有规格的可卖数量之和，选填")
    private Long shelfAmount;

    @ApiModelProperty(name = "spuid", value = "商品spuId，选填")
    private Long spuid;

    @ApiModelProperty(name = "sellerId", value = "商户ID，选填")
    private Long sellerId;

    @ApiModelProperty(name = "shopId", value = "店铺ID，选填")
    private Long shopId;

    @ApiModelProperty(name = "type", value = "商品类型，1商品 3组合商品，选填，默认1")
    private Integer type;

    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购  默认0")
    private Integer busType;

    @ApiModelProperty(name = "tags", value = "商品标签，选填")
    private List<Long> tags;

    @ApiModelProperty(name = "dirId", value = "分类目录，选填")
    private Long dirId;

    @ApiModelProperty(name = "dirName", value = "分类目录名称，选填")
    private String dirName;

    @ApiModelProperty(name = "ownerId", value = "创建人，选填")
    private Long ownerId;


    @ApiModelProperty(name = "skus", value = "商品规格，必填，对应的规格数据")
    private List<ItemBundleReqDto> skus;

    @ApiModelProperty(name = "medias", value = "商品多媒体，选填，商品的多媒体信息")
    private List<ItemMediasReqDto> medias;

    @ApiModelProperty(name = "attrs", value = "商品属性，选填")
    private String attrs;

    @ApiModelProperty(name = "searchAttrs", value = "附加属性:参与搜索，选填")
    private String searchAttrs;

    @ApiModelProperty(name = "propGroupDtoList", value = "商品的基础属性组信息")
    private List<ItemPropGroupDto> propGroupDtoList;

    @ApiModelProperty(name = "itemPropRelationReqDtos", value = "商品属性组关联列表 ps:先不做属性名的维度，选填(该属性随属性池内容变动而变动)")
    private List<ItemPropRelationReqDto> itemPropRelationReqDtos;

    /**
     * 供应商Id
     */
    @ApiModelProperty(name = "supplierId", value = "供应商id")
    private Long supplierId;

    @ApiModelProperty(name = "saleChannel", value = "可售渠道,多个用英文逗号隔开,如：JD,TM")
    private String saleChannel;

    @ApiModelProperty(name = "year", value = "所属年份")
    private Integer year;

    /**
     * 组织Id
     */
    @ApiModelProperty(name = "organizationId", value = "组织Id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    /**
     * 所属组织id集合，用于树状回显
     */
    @ApiModelProperty(name = "organizationIds", value = "所属组织Id集合")
    private List<Long> organizationIds;

    /**
     * 零售限购周期
     */
    @ApiModelProperty(name = "retailLimitPeriod", value = "零售限购周期")
    private String retailLimitPeriod;
    /**
     * 零售限购
     */
    @ApiModelProperty(name = "retailLimit", value = "零售限购")
    private String retailLimit;
    /**
     * 最小起售量（单次购买）
     */
    @ApiModelProperty(name = "retailLimitMin", value = "最小起售量（单次购买）")
    private String retailLimitMin;
    /**
     * 最大零售量（单次购买）
     */
    @ApiModelProperty(name = "retailLimitMax", value = "最大零售量（单次购买）")
    private String retailLimitMax;
    /**
     * 订货限购周期
     */
    @ApiModelProperty(name = "wholesaleLimitPeriod", value = "订货限购周期")
    private String wholesaleLimitPeriod;
    /**
     * 订货限购
     */
    @ApiModelProperty(name = "wholesaleLimit", value = "订货限购")
    private String wholesaleLimit;
    /**
     * 最小订货量（单次购买）
     */
    @ApiModelProperty(name = "wholesaleLimitMin", value = "最小订货量（单次购买）")
    private String wholesaleLimitMin;
    /**
     * 最大订货量（单次购买）
     */
    @ApiModelProperty(name = "wholesaleLimitMax", value = "最大订货量（单次购买）")
    private String wholesaleLimitMax;

    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "dosageForm", value = "剂型")
    private String dosageForm;

    @ApiModelProperty(
            name = "giftBox",
            value = "是否礼盒（0：是、1：否）"
    )
    private Integer giftBox;


    @ApiModelProperty(name = "oldLongCode", value = "旧编码")
    private String oldLongCode;

    public String getOldLongCode() {
        return oldLongCode;
    }

    public void setOldLongCode(String oldLongCode) {
        this.oldLongCode = oldLongCode;
    }


    // ==== 北鼎字段start ====
    String productType = null;

    Integer editStatus = null;

    String saleStatus = null;

    Integer tag = null;

    String domesticB2b = null;

    Integer internalB2b = null;

    String principalPerson = null;

    String enCode = null;
    // ==== 北鼎字段end ====

    public Integer getGiftBox() {
        return giftBox;
    }

    public void setGiftBox(Integer giftBox) {
        this.giftBox = giftBox;
    }

    public String getDosageForm() {
        return dosageForm;
    }

    public void setDosageForm(String dosageForm) {
        this.dosageForm = dosageForm;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getRetailLimitPeriod() {
        return retailLimitPeriod;
    }

    public void setRetailLimitPeriod(String retailLimitPeriod) {
        this.retailLimitPeriod = retailLimitPeriod;
    }

    public String getRetailLimit() {
        return retailLimit;
    }

    public void setRetailLimit(String retailLimit) {
        this.retailLimit = retailLimit;
    }

    public String getRetailLimitMin() {
        return retailLimitMin;
    }

    public void setRetailLimitMin(String retailLimitMin) {
        this.retailLimitMin = retailLimitMin;
    }

    public String getRetailLimitMax() {
        return retailLimitMax;
    }

    public void setRetailLimitMax(String retailLimitMax) {
        this.retailLimitMax = retailLimitMax;
    }

    public String getWholesaleLimitPeriod() {
        return wholesaleLimitPeriod;
    }

    public void setWholesaleLimitPeriod(String wholesaleLimitPeriod) {
        this.wholesaleLimitPeriod = wholesaleLimitPeriod;
    }

    public String getWholesaleLimit() {
        return wholesaleLimit;
    }

    public void setWholesaleLimit(String wholesaleLimit) {
        this.wholesaleLimit = wholesaleLimit;
    }

    public String getWholesaleLimitMin() {
        return wholesaleLimitMin;
    }

    public void setWholesaleLimitMin(String wholesaleLimitMin) {
        this.wholesaleLimitMin = wholesaleLimitMin;
    }

    public String getWholesaleLimitMax() {
        return wholesaleLimitMax;
    }

    public void setWholesaleLimitMax(String wholesaleLimitMax) {
        this.wholesaleLimitMax = wholesaleLimitMax;
    }

    public Integer getIsAfterSale() {
        return isAfterSale;
    }

    public void setIsAfterSale(Integer isAfterSale) {
        this.isAfterSale = isAfterSale;
    }

    public Integer getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(Integer itemStatus) {
        this.itemStatus = itemStatus;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Boolean getVirtual() {
        return virtual;
    }

    public void setVirtual(Boolean virtual) {
        this.virtual = virtual;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Integer getReturnType() {
        return returnType;
    }

    public void setReturnType(Integer returnType) {
        this.returnType = returnType;
    }

    public String getAllowReturnTime() {
        return allowReturnTime;
    }

    public void setAllowReturnTime(String allowReturnTime) {
        this.allowReturnTime = allowReturnTime;
    }

    public Long getShelfAmount() {
        return shelfAmount;
    }

    public void setShelfAmount(Long shelfAmount) {
        this.shelfAmount = shelfAmount;
    }

    public Long getSpuid() {
        return spuid;
    }

    public void setSpuid(Long spuid) {
        this.spuid = spuid;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public List<Long> getTags() {
        return tags;
    }

    public void setTags(List<Long> tags) {
        this.tags = tags;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public List<ItemBundleReqDto> getSkus() {
        return skus;
    }

    public void setSkus(List<ItemBundleReqDto> skus) {
        this.skus = skus;
    }

    public List<ItemMediasReqDto> getMedias() {
        return medias;
    }

    public void setMedias(List<ItemMediasReqDto> medias) {
        this.medias = medias;
    }

    public String getAttrs() {
        return attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public String getSearchAttrs() {
        return searchAttrs;
    }

    public void setSearchAttrs(String searchAttrs) {
        this.searchAttrs = searchAttrs;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public List<ItemPropGroupDto> getPropGroupDtoList() {
        return propGroupDtoList;
    }

    public void setPropGroupDtoList(List<ItemPropGroupDto> propGroupDtoList) {
        this.propGroupDtoList = propGroupDtoList;
    }

    public List<ItemPropRelationReqDto> getItemPropRelationReqDtos() {
        return itemPropRelationReqDtos;
    }

    public void setItemPropRelationReqDtos(List<ItemPropRelationReqDto> itemPropRelationReqDtos) {
        this.itemPropRelationReqDtos = itemPropRelationReqDtos;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Integer getBusType() {
        return busType;
    }
    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public String getSaleChannel() {
        return saleChannel;
    }

    public void setSaleChannel(String saleChannel) {
        this.saleChannel = saleChannel;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public List<Long> getOrganizationIds() {
        return organizationIds;
    }

    public void setOrganizationIds(List<Long> organizationIds) {
        this.organizationIds = organizationIds;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public Integer getEditStatus() {
        return editStatus;
    }

    public void setEditStatus(Integer editStatus) {
        this.editStatus = editStatus;
    }

    public String getSaleStatus() {
        return saleStatus;
    }

    public void setSaleStatus(String saleStatus) {
        this.saleStatus = saleStatus;
    }

    public Integer getTag() {
        return tag;
    }

    public void setTag(Integer tag) {
        this.tag = tag;
    }

    public String getDomesticB2b() {
        return domesticB2b;
    }

    public void setDomesticB2b(String domesticB2b) {
        this.domesticB2b = domesticB2b;
    }

    public Integer getInternalB2b() {
        return internalB2b;
    }

    public void setInternalB2b(Integer internalB2b) {
        this.internalB2b = internalB2b;
    }

    public String getPrincipalPerson() {
        return principalPerson;
    }

    public void setPrincipalPerson(String principalPerson) {
        this.principalPerson = principalPerson;
    }

    public String getEnCode() {
        return enCode;
    }

    public void setEnCode(String enCode) {
        this.enCode = enCode;
    }

}
