
/*
 * @(#)DirectoryItemReqDto.java 1.0 2018-09-03
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.dtyunxi.cube.commons.dto.TreeNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 目录响应Dto
 *
 * @author 诺克
 * @since 2.0.0
 */
@ApiModel(value = "DirectoryItemRespDto", description = "目录响应Dto")
public class DirectoryItemRespDto extends BaseRespDto implements TreeNode {

    @ApiModelProperty(name = "id", value = "目录项ID")
    private Long id;

    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    @ApiModelProperty(name = "name", value = "目录名")
    private String name;

    @ApiModelProperty(name = "parentId", value = "父节点")
    private Long parentId;

    @ApiModelProperty(name = "link", value = "引用目录")
    private Long link;

    @ApiModelProperty(name = "links", value = "引用目录集合")
    private List<Long> links;

    @ApiModelProperty(name = "attrs", value = "其他属性")
    private String attrs;

    @ApiModelProperty(name = "ownerId", value = "创建人ID")
    private Long ownerId;

    @ApiModelProperty(name = "rootId", value = "根节点")
    private Long rootId;

    @ApiModelProperty(name = "status", value = "状态 0禁用1启用")
    private Integer status;

    /**
     * 排序
     */
    @ApiModelProperty(name = "sort", value = "排序值")
    private Integer sort;

    @ApiModelProperty(name = "description", value = "描述")
    private String description;

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public Long getParentId() {
        return parentId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getLink() {
        return link;
    }

    public void setLink(Long link) {
        this.link = link;
    }

    public List<Long> getLinks() {
        return links;
    }

    public void setLinks(List<Long> links) {
        this.links = links;
    }

    public String getAttrs() {
        return attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getRootId() {
        return rootId;
    }

    public void setRootId(Long rootId) {
        this.rootId = rootId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }
}
