package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 模板区域Dto
 *
 * @author 东海
 * @since 2.0.0
 */
@ApiModel(value = "TemplateRegionRespDto", description = "模板区域")
public class TemplateRegionRespDto implements Serializable {

	private static final long serialVersionUID = -3029711453525165803L;

	@ApiModelProperty(name = "warehouseId", value = "仓库ID")
	private Long warehouseId;


	private String  type = "polygon";

	private  List<List<List<Double>>> coordinates;

	public TemplateRegionRespDto() {
	}

	public TemplateRegionRespDto(List<List<List<Double>>> coordinates) {
		this.warehouseId = 0L;
		this.type = "polygon";
		this.coordinates = coordinates;
	}

	public Long getWarehouseId() {
		return warehouseId;
	}
	public void setWarehouseId(Long warehouseId) {
		this.warehouseId = warehouseId;
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	public List<List<List<Double>>> getCoordinates() {
		return coordinates;
	}
	public void setCoordinates(List<List<List<Double>>> coordinates) {
		this.coordinates = coordinates;
	}
}