package com.dtyunxi.yundt.cube.center.item.api.dto;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemMediasReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商品|产品定义dto对象
 *
 * @author yiyun
 * @since 2021-08-18
 */
@ApiModel(value = "ItemExtDto", description = "商品|产品定义dto对象")
@Data
public class ItemExtDto extends RequestDto {
    /**
     *
     */
    @ApiModelProperty(name = "id", value ="id")
    private Long id;
    /**
     *  名称
     */
    @ApiModelProperty(name = "name", value = "名称")
    private String name;
    /**
     *  显示名
     */
    @ApiModelProperty(name = "displayName", value = "显示名(简称)")
    private String displayName;
    /**
     *  编码
     */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;
    /**
     *
     */
    @ApiModelProperty(name = "brandId", value = "品牌id")
    private Long brandId;
    /**
     *  品牌名称
     */
    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;
    /**
     *后台类目
     */
    @ApiModelProperty(name = "dirId", value = "后台类目")
    private Long dirId;
    /**
     *后台类目名称
     */
    @ApiModelProperty(name = "dirName", value = "后台类目名称")
    private String dirName;

    /**
     *前台类目
     */
    @ApiModelProperty(name = "dirPrefixId", value = "前台类目")
    private Long dirPrefixId;
    /**
     *前台类目名称
     */
    @ApiModelProperty(name = "dirPrefixName", value = "前台类目名称")
    private String dirPrefixName;

    /**
     *  虚拟商品
     */
    @ApiModelProperty(name = "vitrual", value = "虚拟商品 0-否,1-是")
    private String vitrual;
    /**
     *  商品介绍
     */
    @ApiModelProperty(name = "brief", value = "商品介绍")
    private String brief;
    /**
     *  详情
     */
    @ApiModelProperty(name = "detail", value = "详情")
    private String detail;
    /**
     *  状态(0已发布 1上架 2下架 3未发布 4禁用状态)
     */
    @ApiModelProperty(name = "status", value = "状态(0已发布 1上架 2下架 3未发布 4禁用状态)")
    private Integer status;
    /**
     *  退货类型：1不可退 2手动可退 3过期自动退
     */
    @ApiModelProperty(name = "returnType", value = "退货类型：1不可退 2手动可退 3过期自动退")
    private Integer returnType;
    /**
     *  允许退货时间点
     */
    @ApiModelProperty(name = "allowReturnTime", value = "允许退货时间点")
    private String allowReturnTime;
    /**
     *  审核状态(0草稿 1待审核 2审核通过 3审核拒绝)
     */
    @ApiModelProperty(name = "auditStatus", value = "审核状态(0草稿 1待审核 2审核通过 3审核拒绝)")
    private Integer auditStatus;
    /**
     *
     */
    @ApiModelProperty(name = "shelfAmount", value = "")
    private Long shelfAmount;
    /**
     *
     */
    @ApiModelProperty(name = "shippingTpl", value = "")
    private Long shippingTpl;
    /**
     *  1-商品，2.产品 3组合商品 4虚拟商品 5赠品商品
     */
    @ApiModelProperty(name = "type", value = "1-商品，2.产品 3组合商品 4虚拟商品 5赠品商品")
    private Integer type;
    /**
     *  是否售后:0否 1是
     */
    @ApiModelProperty(name = "isAfterSale", value = "是否售后:0否 1是")
    private Integer isAfterSale;
    /**
     *  产品id
     */
    @ApiModelProperty(name = "spuid", value = "产品id")
    private Long spuid;
    /**
     *  商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;
    /**
     *  店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     *  所属人ID
     */
    @ApiModelProperty(name = "ownerId", value = "所属人ID")
    private Long ownerId;
    /**
     *  版本号--审核通过后+1
     */
    @ApiModelProperty(name = "version", value = "版本号--审核通过后+1")
    private Long version;
    /**
     *  销售渠道
     */
    @ApiModelProperty(name = "saleChannel", value = "销售渠道")
    private String saleChannel;
    /**
     *  组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
     *  组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    /**
     *  年份 例如：2020
     */
    @ApiModelProperty(name = "year", value = "年份 例如：2020")
    private Integer year;
    /**
     *  0 表示普通商品，1社区团购
     */
    @ApiModelProperty(name = "busType", value = "0 表示普通商品，1社区团购")
    private Integer busType;
    /**
     *  零售限购周期
     */
    @ApiModelProperty(name = "retailLimitPeriod", value = "零售限购周期")
    private String retailLimitPeriod;
    /**
     *  零售限购
     */
    @ApiModelProperty(name = "retailLimit", value = "零售限购")
    private BigDecimal retailLimit;
    /**
     *  最小起售量（单次购买）
     */
    @ApiModelProperty(name = "retailLimitMin", value = "最小起售量（单次购买）")
    private BigDecimal retailLimitMin;
    /**
     *  最大零售量（单次购买）
     */
    @ApiModelProperty(name = "retailLimitMax", value = "最大零售量（单次购买）")
    private BigDecimal retailLimitMax;
    /**
     *  订货限购周期
     */
    @ApiModelProperty(name = "wholesaleLimitPeriod", value = "订货限购周期")
    private String wholesaleLimitPeriod;
    /**
     *  订货限购
     */
    @ApiModelProperty(name = "wholesaleLimit", value = "订货限购")
    private BigDecimal wholesaleLimit;
    /**
     *  最小订货量（单次购买）
     */
    @ApiModelProperty(name = "wholesaleLimitMin", value = "最小订货量（单次购买）")
    private BigDecimal wholesaleLimitMin;
    /**
     *  最大订货量（单次购买）
     */
    @ApiModelProperty(name = "wholesaleLimitMax", value = "最大订货量（单次购买）")
    private BigDecimal wholesaleLimitMax;


    /**
     *  销售组织
     */
    @ApiModelProperty(name = "saleOrganization",value = "销售组织")
    private String saleOrganization;


    /**
     *  分销渠道
     */
    @ApiModelProperty(name = "distributionChannel",value = "分销渠道")
    private String distributionChannel;

    /**
     *  MWSI税码
     */
    @ApiModelProperty(name = "nwsiCode",value = "MWSI税码")
    private String nwsiCode;

    /**
     *  交货工厂
     */
    @ApiModelProperty(name = "deliveryFactory",value = "交货工厂")
    private String deliveryFactory;

    /**
     *  物料运输组
     */
    @ApiModelProperty(name = "materialGroup",value = "物料运输组")
    private String materialGroup;

    /**
     *  项目类别组
     */
    @ApiModelProperty(name = "projectGroup",value = "项目类别组")
    private String projectGroup;

    /**
     *  科目设置组
     */
    @ApiModelProperty(name = "accountSettingGroup",value = "科目设置组")
    private String accountSettingGroup;


    /**
     *  产品实际上市日期
     */
    @ApiModelProperty(name = "actualLaunchDate",value = "产品实际上市日期")
    private String actualLaunchDate;


    /**
     *  产品实际下市日期
     */
    @ApiModelProperty(name = "actualDelistingDate",value = "产品实际下市日期")
    private String actualDelistingDate;


    /**
     *  商品的等级分类
     */
    @ApiModelProperty(name = "productGradeClassify",value = "商品的等级分类")
    private String productGradeClassify;


    /**
     *  产品大类
     */
    @ApiModelProperty(name = "prodLargeClass",value = "产品大类")
    private String prodLargeClass;

    /**
     *  产品二级分类
     */
    @ApiModelProperty(name = "prodSecClassify",value = "产品二级分类")
    private String prodSecClassify;


    /**
     *  产品负责人
     */
    @ApiModelProperty(name = "principalPerson",value = "产品负责人")
    private String principalPerson;

    /**
     *  EN（69码）
     */
    @ApiModelProperty(name = "enCode",value = "EN（69码）")
    private String enCode;

    /**
     *  内包装规格（PC长宽高）
     */
    @ApiModelProperty(name = "pcSpecs",value = "内包装规格（PC长宽高）")
    private BigDecimal pcSpecs;

    /**
     *  外包装规格（CAR长宽高）
     */
    @ApiModelProperty(name = "carSpecs",value = "外包装规格（CAR长宽高）")
    private BigDecimal carSpecs;


    /**
     *  国内B2B卖点
     */
    @ApiModelProperty(name = "domesticB2b",value = "国内B2B卖点")
    private String domesticB2b;


    /**
     *  国外B2B卖点
     */
    @ApiModelProperty(name = "internalB2b",value = "国外B2B卖点")
    private String internalB2b;

    /**
     *  物料类型
     */
    @ApiModelProperty(name = "materialsType",value = "物料类型")
    private String materialsType;

    /**
     *  食材(保质期)
     */
    @ApiModelProperty(name = "ingredientsShelfLife",value = "食材(保质期)")
    private String ingredientsShelfLife;

    /**
     * 负责部门
     */
    @ApiModelProperty(name = "department",value = "负责部门")
    private String department;
    /*
    * spec_content规格
    * */
    @ApiModelProperty(name = "specContent",value = "规格")
    private String specContent;
    /*
    * 供应商名称
    * */
    @ApiModelProperty(name = "supplier",value = "供应商名称")
    private String supplier;
    /**
     *  供应商id
     */
    @ApiModelProperty(name = "supplierId", value = "供应商id")
    private Long supplierId;
    /*产品定位*/
    @ApiModelProperty(name = "productPositioning", value = "产品定位")
    private String productPositioning;
    /*税收分类名称*/
    @ApiModelProperty(name = "taxCategoryName", value = "税收分类名称")
    private String taxCategoryName;
    /*销售组*/
    @ApiModelProperty(name = "saleGroup", value = "销售组")
    private String saleGroup;

    /**
     *  计量单位
     */
    @ApiModelProperty(name = "calcuUnit", value = "计量单位")
    private String calcuUnit;
    /**
     *  毛重
     */
    @ApiModelProperty(name = "grossWeight", value = "毛重")
    private BigDecimal grossWeight;
    /**
     *  净重
     */
    @ApiModelProperty(name = "netWeight", value = "净重")
    private BigDecimal netWeight;
    /**
     *  重量单位
     */
    @ApiModelProperty(name = "weightUnit", value = "重量单位")
    private String weightUnit;


    /*
    * 商品多媒体，选填，商品的多媒体信息
    * */
    @ApiModelProperty(name = "medias", value = "商品多媒体，选填，商品的多媒体信息")
    private List<ItemMediasReqDto> medias;


}
