package com.yunxi.adapter.api.dto.response;

import com.yunxi.dg.base.commons.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
* 商品扩展参数表Eo对象
*
* @author yuangui
* @since 2022-05-11
*/
@Data
@ApiModel(value = "ItemExtendAdapterRespDto", description = "商品扩展参数表Eo对象")
public class ItemExtendAdapterRespDto extends BaseDto {
    /**
     *  编码
     */
    @ApiModelProperty(name = "itemCode", value = "编码")
    private String itemCode;

    /**
     * e3物料编码
     */
    @ApiModelProperty(name = "e3ItemCode", value = "e3物料编码")
    private String e3ItemCode;

    /**
    *  长度
    */
    @ApiModelProperty(name = "length", value = "长度")
    private BigDecimal length;
    /**
    *  高度
    */
    @ApiModelProperty(name = "height", value = "高度")
    private BigDecimal height;
    /**
    *  宽度
    */
    @ApiModelProperty(name = "width", value = "宽度")
    private BigDecimal width;
    /**
    *  长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
    */
    @ApiModelProperty(name = "lengthUnit", value = "长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String lengthUnit;
    /**
    *  高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
    */
    @ApiModelProperty(name = "heightUnit", value = "高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String heightUnit;
    /**
    *  宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
    */
    @ApiModelProperty(name = "widthUnit", value = "宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String widthUnit;
    /**
    *  体积
    */
    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;
    /**
    *  体积单独
    */
    @ApiModelProperty(name = "volumnUnit", value = "体积单独")
    private String volumnUnit;
    /**
    *  毛重
    */
    @ApiModelProperty(name = "grossWeight", value = "毛重")
    private BigDecimal grossWeight;
    /**
    *  毛重单位
    */
    @ApiModelProperty(name = "grossWeightUnit", value = "毛重单位")
    private String grossWeightUnit;
    /**
    *  净重
    */
    @ApiModelProperty(name = "netWeight", value = "净重")
    private BigDecimal netWeight;
    /**
    *  净重单位
    */
    @ApiModelProperty(name = "netWeightUnit", value = "净重单位")
    private String netWeightUnit;
    /**
    *  重量
    */
    @ApiModelProperty(name = "quantity", value = "重量")
    private BigDecimal quantity;
    /**
    *  重量单位
    */
    @ApiModelProperty(name = "quantityUnit", value = "重量单位")
    private String quantityUnit;
    /**
    *  大包系数
    */
    @ApiModelProperty(name = "bigRatio", value = "大包系数")
    private Long bigRatio;
    /**
    *  中包系数
    */
    @ApiModelProperty(name = "middleRatio", value = "中包系数")
    private Long middleRatio;
    /**
    *  小包系数
    */
    @ApiModelProperty(name = "smallRatio", value = "小包系数")
    private Long smallRatio;
    /**
    *  防伪码
    */
    @ApiModelProperty(name = "securityCode", value = "防伪码")
    private String securityCode;
    /**
    *  保质期
    */
    @ApiModelProperty(name = "expirationDate", value = "保质期")
    private String expirationDate;
    /**
    *  保质期单位
    */
    @ApiModelProperty(name = "expirationUnit", value = "保质期单位")
    private String expirationUnit;
    /**
    *  是否免检
    */
    @ApiModelProperty(name = "exemption", value = "是否免检")
    private String exemption;

    private String specifications;
    @ApiModelProperty(name = "recommendPrice", value = "建议零售价")
    private BigDecimal recommendPrice;
    private String imeiCodeFlag;
    private String standardApproval;
    private Integer itemDrug;

    /**
     *  索赔价格
     */
    @ApiModelProperty(name = "claimPrice", value = "索赔价格")
    private BigDecimal claimPrice;

    /**
     *  大包系数
     */
    @ApiModelProperty(name = "bigBox",value = "大包系数")
    private Long bigBox;
    /**
     *  中包系数
     */
    @ApiModelProperty(name = "middleMax",value = "中包系数")
    private Long middleMax;
    /**
     *  小包系数
     */
    @ApiModelProperty(name = "smallBox",value = "小包系数")
    private Long smallBox;

    /**
     *  出厂价
     *  todo 销售计划使用，妙可出厂价在it_item_department_price表
     */
    @ApiModelProperty(name = "exFactoryPrice", value = "出厂价")
    private BigDecimal exFactoryPrice;

    /**
     *  unitId
     */
    @ApiModelProperty(name = "unitId", value = "NC单位ID")
    private String unitId;

}
