package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 商品扩展表导入dto
 *
 * @author dingxiu
 * @since 2022-11-17
 */
@ApiModel(value = "ItemExtendImportDto", description = "商品扩展表导入dto")
public class ItemExtendImportDto extends RequestDto{

    @ApiModelProperty(name = "goodsLongCode", value = "商品长编码")
    @NotBlank(message = "商品长编码不能为空。")
    private String itemCode;


    @ApiModelProperty(name = "goodsType", value = "商品类型 1:产品 2:赠品 3: 促销物料")
    private String itemType;

    @Valid
    @ApiModelProperty(name = "goodsRetailPrice", value = "建议零售价（元）")
    private BigDecimal recommendPrice;


    @ApiModelProperty(name = "claimPrice", value = "索赔价格")
    private BigDecimal claimPrice;

    @ApiModelProperty(name = "zhTrayNum", value = "珠海仓码拖数")
    private Long zhTrayNum;

    @ApiModelProperty(name = "claimPrice", value = "索赔价格")
    private Long bigBox;

    @ApiModelProperty(name = "bigRatio", value = "大包系数")
    private Long bigRatio;

    @ApiModelProperty(name = "smallBox", value = "小箱瓶数")
    private Long smallBox;


    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public BigDecimal getRecommendPrice() {
        return recommendPrice;
    }

    public void setRecommendPrice(BigDecimal recommendPrice) {
        this.recommendPrice = recommendPrice;
    }

    public BigDecimal getClaimPrice() {
        return claimPrice;
    }

    public void setClaimPrice(BigDecimal claimPrice) {
        this.claimPrice = claimPrice;
    }

    public Long getZhTrayNum() {
        return zhTrayNum;
    }

    public void setZhTrayNum(Long zhTrayNum) {
        this.zhTrayNum = zhTrayNum;
    }

    public Long getBigBox() {
        return bigBox;
    }

    public void setBigBox(Long bigBox) {
        this.bigBox = bigBox;
    }

    public Long getBigRatio() {
        return bigRatio;
    }

    public void setBigRatio(Long bigRatio) {
        this.bigRatio = bigRatio;
    }

    public Long getSmallBox() {
        return smallBox;
    }

    public void setSmallBox(Long smallBox) {
        this.smallBox = smallBox;
    }
}
