/*
 * @(#)ItemSkuReqDto.java 1.0 2018-09-03
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商品规格Dto
 *
 * @author 诺克
 * @since 2.0.0
 */
@Data
@ApiModel(value = "ItemSkuReqDto", description = "sku信息")
public class ItemSkuReqDto extends BaseReqDto {

    @ApiModelProperty(name = "id", value = "id，选填(修改重新发布，要想规格id不变动可填)")
    private Long id;

    @ApiModelProperty(name = "itemId", value = "商品Id，必填")
    private Long itemId;

    @ApiModelProperty(name = "code", value = "编码，选填")
    private String code;

    @ApiModelProperty(name = "name", value = "规格名，必填")
    private String name;

    @ApiModelProperty(name = "cspuid", value = "产品规格，选填")
    private Long cspuid;

    @ApiModelProperty(name = "attr", value = "属性，必填")
    private String attr;

    @ApiModelProperty(name = "status", value = "状态，选填")
    private Integer status;

    @ApiModelProperty(name = "unit", value = "单位，选填")
    private String unit;

    @ApiModelProperty(name = "outterCode", value = "外部编码，选填(要跟库存关联则必填，为货品ID)")
    private String outterCode;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "barCode", value = "识别码，选填")
    private String barCode;

    @ApiModelProperty(name = "bundles", value = "组合信息，选填")
    private String bundles;

    /**
     * 有效的起始时间（例12:00）,有效日期上架当天
     */
    @ApiModelProperty(name = "effectiveStartTime", value = "有效的起始时间（例12:00）,有效日期上架当天，选填(虚拟商品用)")
    private String effectiveStartTime;
    /**
     * 有效的结束时间（例13:00）,有效日期上架当天
     */
    @ApiModelProperty(name = "effectiveEndTime", value = "有效的结束时间（例13:00）,有效日期上架当天，选填(虚拟商品用)")
    private String effectiveEndTime;
    /**
     * 库存数量
     */
    @ApiModelProperty(name = "inventoryQuantity", value = "库存数量，选填(虚拟商品用)")
    private Long inventoryQuantity;
    /**
     * 是否预售(1是 2否)
     */
    @ApiModelProperty(name = "advanceSale", value = "是否预售(1是 2否)，选填(虚拟商品用)")
    private Integer advanceSale;
    /**
     * 停售日期
     */
    @ApiModelProperty(name = "discontinuationDate", value = "停售日期，选填(虚拟商品用)")
    private String discontinuationDate;

    @ApiModelProperty(name = "shelfAmount", value = "可卖数量=所有规格的可卖数量之和，选填")
    private Long shelfAmount;

    @ApiModelProperty(name = "safetyStock", value = "安全库存数")
    private Integer safetyStock;

    @ApiModelProperty(name = "ifAvailableOffline", value = "是否线下可售，0-否，1-是")
    private Integer ifAvailableOffline;

    /**
     * 毛重
     */
    @ApiModelProperty(name="gross_weight", value = "毛重，选填")
    private BigDecimal grossWeight;

    /**
     * 毛重单位
     */
    @ApiModelProperty(name="gross_weight_unit", value = "毛重单位，选填")
    private String grossWeightUnit;

    /**
     * 净重
     */
    @ApiModelProperty(name="net_weight", value = "净重，选填")
    private BigDecimal netWeight;

    /**
     * 净重单位
     */
    @ApiModelProperty(name="net_weight_unit", value = "净重单位，选填")
    private String netWeightUnit;
    /**
     * 体积
     */
    @ApiModelProperty(name="volume", value = "体积")
    private BigDecimal volume;
    /**
     * 体积单位
     */
    @ApiModelProperty(name="volumeUnit", value = "体积单位：1 立方米 2 立方厘米 3立方分米")
    private String volumeUnit;

    @ApiModelProperty(name = "balance", value = "库存数量")
    private Long balance;

    @ApiModelProperty(name = "price", value = "定价")
    private BigDecimal price;

    @ApiModelProperty(name = "salePrice", value = "零售价")
    private BigDecimal salePrice;

    @ApiModelProperty(name = "distribution", value = "是否分销：1是，0否")
    private Integer distribution;

    @ApiModelProperty(name = "distribution", value = "分销佣金")
    private BigDecimal distributionFee;

    @ApiModelProperty(name = "costPrice",value = "成本价")
    private BigDecimal costPrice;


    @ApiModelProperty(name = "addPriceStatus",value = "0:关闭加价限制;1:开启加价限制")
    private Integer addPriceStatus;
    /**
     * 加价限制设置关闭则不显示
     * @return
     */
    @ApiModelProperty(name = "addPriceMode",value = "加价方式,0:使用默认值;1:自定义比例;2:自定义设置(固定值)")
    private Integer addPriceMode;

    @ApiModelProperty(name = "addPriceMin",value = "限制加价下限;addPriceMod的值为0,1就位百分比;2为固定值(单位元)")
    private String addPriceMin;

    @ApiModelProperty(name = "addPriceMax",value = "限制加价上限")
    private String addPriceMax;

    @ApiModelProperty(name = "minPackage",value = "最小包装数")
    private Integer minPackage;

    // ==== 北鼎字段start ====
    /**
     * 规格单位
     */
    String specsUnit = null;

    /**
     *  计量单位
     */
    String calcuUnit = null;

    /**
     *  重量单位
     */
    String weightUnit = null;

    /**
     * 内包装规格（PC长宽高）
     */
    String pcSpecs = null;

    /**
     * 外包装规格（CAR长宽高）
     */
    String carSpecs = null;

    /**
     * 换算因子
     */
    String matrixing = null;


    List<ItemPriceRespDto> itemPriceList = Lists.newArrayList();

    String launchDate = null;

    String delistingDate = null;

    String materialType = null;
    // ==== 北鼎字段end ====

    // ==== 华帝字段start ====
    /*大小/量纲*/
    String capacitySize = null;
    /*面板材质/特征效果*/
    String panelMaterial = null;
    /*容积*/
    //String volume = null;
    /*毛质量*/
    String totalQuality = null;
    /*包装参考物料*/
    String packingMaterial = null;
    /*包装外形尺寸*/
    String packingSize = null;
    /*额定容积*/
    String nominalVolume = null;
    /*净质量*/
    String netQuality = null;
    /*嵌装开孔尺寸*/
    String insertOpeningSize = null;
    /*基本单位*/
    String basicUnit = null;
    /**
     *冻结标识
     * */
    String freezeMark = null;
    // ==== 华帝字段end ====

    /**
     *销售单位
     * */
    @ApiModelProperty(name = "saleUnit",value = "销售单位")
    private String saleUnit;
    /**
     *计价单位
     * */
    @ApiModelProperty(name = "priceUnit",value = "计价单位")
    private String priceUnit;
    /**
     *计价换算系数
     * */
    @ApiModelProperty(name = "priceConversionNum",value = "计价换算系数")
    private String priceConversionNum;

    public Integer getMinPackage() {
        return minPackage;
    }

    public void setMinPackage(Integer minPackage) {
        this.minPackage = minPackage;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCspuid() {
        return cspuid;
    }

    public void setCspuid(Long cspuid) {
        this.cspuid = cspuid;
    }

    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getOutterCode() {
        return outterCode;
    }

    public void setOutterCode(String outterCode) {
        this.outterCode = outterCode;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getBundles() {
        return bundles;
    }

    public void setBundles(String bundles) {
        this.bundles = bundles;
    }

    public String getEffectiveStartTime() {
        return effectiveStartTime;
    }

    public void setEffectiveStartTime(String effectiveStartTime) {
        this.effectiveStartTime = effectiveStartTime;
    }

    public String getEffectiveEndTime() {
        return effectiveEndTime;
    }

    public void setEffectiveEndTime(String effectiveEndTime) {
        this.effectiveEndTime = effectiveEndTime;
    }

    public Long getInventoryQuantity() {
        return inventoryQuantity;
    }

    public void setInventoryQuantity(Long inventoryQuantity) {
        this.inventoryQuantity = inventoryQuantity;
    }

    public Integer getAdvanceSale() {
        return advanceSale;
    }

    public void setAdvanceSale(Integer advanceSale) {
        this.advanceSale = advanceSale;
    }

    public String getDiscontinuationDate() {
        return discontinuationDate;
    }

    public void setDiscontinuationDate(String discontinuationDate) {
        this.discontinuationDate = discontinuationDate;
    }

    public Long getShelfAmount() {
        return shelfAmount;
    }

    public void setShelfAmount(Long shelfAmount) {
        this.shelfAmount = shelfAmount;
    }

    public Integer getSafetyStock() {
        return safetyStock;
    }

    public void setSafetyStock(Integer safetyStock) {
        this.safetyStock = safetyStock;
    }

    public Integer getIfAvailableOffline() {
        return ifAvailableOffline;
    }

    public void setIfAvailableOffline(Integer ifAvailableOffline) {
        this.ifAvailableOffline = ifAvailableOffline;
    }

    public BigDecimal getGrossWeight() {
        return grossWeight;
    }

    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }

    public String getGrossWeightUnit() {
        return grossWeightUnit;
    }

    public void setGrossWeightUnit(String grossWeightUnit) {
        this.grossWeightUnit = grossWeightUnit;
    }

    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public String getNetWeightUnit() {
        return netWeightUnit;
    }

    public void setNetWeightUnit(String netWeightUnit) {
        this.netWeightUnit = netWeightUnit;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public String getVolumeUnit() {
        return volumeUnit;
    }

    public void setVolumeUnit(String volumeUnit) {
        this.volumeUnit = volumeUnit;
    }

    public Long getBalance() {
        return balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public Integer getDistribution() {
        return distribution;
    }

    public void setDistribution(Integer distribution) {
        this.distribution = distribution;
    }

    public BigDecimal getDistributionFee() {
        return distributionFee;
    }

    public void setDistributionFee(BigDecimal distributionFee) {
        this.distributionFee = distributionFee;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Integer getAddPriceStatus() {
        return addPriceStatus;
    }

    public void setAddPriceStatus(Integer addPriceStatus) {
        this.addPriceStatus = addPriceStatus;
    }

    public Integer getAddPriceMode() {
        return addPriceMode;
    }

    public void setAddPriceMode(Integer addPriceMode) {
        this.addPriceMode = addPriceMode;
    }

    public String getAddPriceMin() {
        return addPriceMin;
    }

    public void setAddPriceMin(String addPriceMin) {
        this.addPriceMin = addPriceMin;
    }

    public String getAddPriceMax() {
        return addPriceMax;
    }

    public void setAddPriceMax(String addPriceMax) {
        this.addPriceMax = addPriceMax;
    }

    public String getSpecsUnit() {
        return specsUnit;
    }

    public void setSpecsUnit(String specsUnit) {
        this.specsUnit = specsUnit;
    }

    public String getCalcuUnit() {
        return calcuUnit;
    }

    public void setCalcuUnit(String calcuUnit) {
        this.calcuUnit = calcuUnit;
    }

    public String getWeightUnit() {
        return weightUnit;
    }

    public void setWeightUnit(String weightUnit) {
        this.weightUnit = weightUnit;
    }

    public String getPcSpecs() {
        return pcSpecs;
    }

    public void setPcSpecs(String pcSpecs) {
        this.pcSpecs = pcSpecs;
    }

    public String getCarSpecs() {
        return carSpecs;
    }

    public void setCarSpecs(String carSpecs) {
        this.carSpecs = carSpecs;
    }

    public String getMatrixing() {
        return matrixing;
    }

    public void setMatrixing(String matrixing) {
        this.matrixing = matrixing;
    }

    public List<ItemPriceRespDto> getItemPriceList() {
        return itemPriceList;
    }

    public void setItemPriceList(List<ItemPriceRespDto> itemPriceList) {
        this.itemPriceList = itemPriceList;
    }

    public String getLaunchDate() {
        return launchDate;
    }

    public void setLaunchDate(String launchDate) {
        this.launchDate = launchDate;
    }

    public String getDelistingDate() {
        return delistingDate;
    }

    public void setDelistingDate(String delistingDate) {
        this.delistingDate = delistingDate;
    }

    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }
}
