/**
 * @(#)PropNameReqDto 1.0 2018-11-29
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 属性名请求入参
 *
 * @author 双清
 */
@ApiModel(value = "PropNameReqDto", description = "属性名请求入参")
public class PropNameReqDto extends BaseReqDto {

    @ApiModelProperty(name = "id", value = "主键id，修改时必填")
    private Long id;

    @ApiModelProperty(name = "code", value = "编码，选填")
    private String code;

    @ApiModelProperty(name = "name", value = "名称，选填")
    private String name;

    @ApiModelProperty(name = "inputType", value = "编辑方式：1 选择  2 输入")
    private Integer inputType;

    @ApiModelProperty(name = "required", value = "是否必选: 1 是 0 否")
    private Integer required;

    @ApiModelProperty(name = "charSizeLimit", value = "字符数限制")
    private Integer charSizeLimit;

    @ApiModelProperty(name = "prompt", value = "提示语")
    private String prompt;

    @ApiModelProperty(name = "description", value = "描述，选填")
    private String description;

    @ApiModelProperty(name = "propValueList", value = "属性值内容，修改时会删除旧属性值再创建新的属性值，选填")
    private List<String> propValueList;

    @ApiModelProperty(name = "sellerId", value = "商户id，选填")
    private Long sellerId;

    /**
     * 创建开始时间
     */
    @ApiModelProperty(name = "createBeginTime", value = "创建时间--范围开始")
    private String createBeginTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(name = "createEndTime", value = "创建时间--范围结束")
    private String createEndTime;
    /**
     * 更新开始时间
     */
    @ApiModelProperty(name = "updateBeginTime", value = "更新时间--范围开始")
    private String updateBeginTime;
    /**
     * 更新结束时间
     */
    @ApiModelProperty(name = "updateEndTime", value = "更新时间--范围结束")
    private String updateEndTime;

    @ApiModelProperty(name = "dirId", value = "组合查询条件--目录ID")
    private Long dirId;

    @ApiModelProperty(name = "costPrice",value = "成本价")
    private BigDecimal costPrice;

    @ApiModelProperty(name = "addPriceStatus",value = "0:关闭加价限制;1:开启加价限制")
    private Integer addPriceStatus;
    /**
     * 加价限制设置关闭则不显示
     * @return
     */
    @ApiModelProperty(name = "addPriceMode",value = "加价方式,0:使用默认值;1:自定义比例;2:自定义设置(固定值)")
    private Integer addPriceMode;

    @ApiModelProperty(name = "addPriceMin",value = "限制加价下限;addPriceMod的值为0,1就位百分比;2为固定值(单位元)")
    private String addPriceMin;

    @ApiModelProperty(name = "addPriceMax",value = "限制加价上限")
    private String addPriceMax;

    public Integer getAddPriceStatus() {
        return addPriceStatus;
    }

    public void setAddPriceStatus(Integer addPriceStatus) {
        this.addPriceStatus = addPriceStatus;
    }

    public Integer getAddPriceMode() {
        return addPriceMode;
    }

    public void setAddPriceMode(Integer addPriceMode) {
        this.addPriceMode = addPriceMode;
    }

    public String getAddPriceMin() {
        return addPriceMin;
    }

    public void setAddPriceMin(String addPriceMin) {
        this.addPriceMin = addPriceMin;
    }

    public String getAddPriceMax() {
        return addPriceMax;
    }

    public void setAddPriceMax(String addPriceMax) {
        this.addPriceMax = addPriceMax;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getInputType() {
        return inputType;
    }

    public void setInputType(Integer inputType) {
        this.inputType = inputType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getPropValueList() {
        return propValueList;
    }

    public void setPropValueList(List<String> propValueList) {
        this.propValueList = propValueList;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getCreateBeginTime() {
        return createBeginTime;
    }

    public void setCreateBeginTime(String createBeginTime) {
        this.createBeginTime = createBeginTime;
    }

    public String getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(String createEndTime) {
        this.createEndTime = createEndTime;
    }

    public String getUpdateBeginTime() {
        return updateBeginTime;
    }

    public void setUpdateBeginTime(String updateBeginTime) {
        this.updateBeginTime = updateBeginTime;
    }

    public String getUpdateEndTime() {
        return updateEndTime;
    }

    public void setUpdateEndTime(String updateEndTime) {
        this.updateEndTime = updateEndTime;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Integer getRequired() {
        return required;
    }

    public void setRequired(Integer required) {
        this.required = required;
    }

    public Integer getCharSizeLimit() {
        return charSizeLimit;
    }

    public void setCharSizeLimit(Integer charSizeLimit) {
        this.charSizeLimit = charSizeLimit;
    }

    public String getPrompt() {
        return prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }
}