package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @author yufan
 * @time 2020/10/15 10:53
 */
@ApiModel(value = "UnitReqDto", description = "单位请求参数Dto")
public class UnitReqDto extends BaseReqDto {

    @ApiModelProperty(name = "id", value = "主键id，新增不填")
    private Long id;
    /**
     * 单位编号
     */
    @ApiModelProperty(name = "code", value = "单位编号")
    @NotNull
    private String code;
    /**
     * 单位名称
     */
    @ApiModelProperty(name = "name", value = "单位名称，必填")
    @NotNull
    private String name;
    /**
     * 单位英文名称
     */
    @ApiModelProperty(name = "englishName", value = "单位英文名称，必填")
    @NotNull
    private String englishName;
    /**
     * 单位类型
     */
    @ApiModelProperty(name = "type", value = "单位类型，必填")
    @NotNull
    private String type;
    /**
     * 状态 0 禁用 1 启用
     */
    @ApiModelProperty(name = "status", value = "态 0 禁用 1 启用")
    private Integer status;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 修改时间，起始
     */
    @ApiModelProperty(name = "updateTimeStart", value = "修改时间，起始")
    private String updateTimeStart;

    /**
     * 修改时间，截止
     */
    @ApiModelProperty(name = "updateTimeEnd", value = "修改时间，截止")
    private String updateTimeEnd;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEnglishName() {
        return englishName;
    }

    public void setEnglishName(String englishName) {
        this.englishName = englishName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getUpdateTimeStart() {
        return updateTimeStart;
    }

    public void setUpdateTimeStart(String updateTimeStart) {
        this.updateTimeStart = updateTimeStart;
    }

    public String getUpdateTimeEnd() {
        return updateTimeEnd;
    }

    public void setUpdateTimeEnd(String updateTimeEnd) {
        this.updateTimeEnd = updateTimeEnd;
    }
}
