package com.dtyunxi.yundt.cube.center.item.api.dg;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.dg.ItemPriceDgRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author mubei
 * @since 1.0.0
 */
@Api(tags = {"商品中心：商品销售计划价格服务"})
@FeignClient( contextId = "com-yx-tcbj-center-api-IItemPriceDgQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/dg/itemPrice",
        url = "${yundt.cube.center.item.api:}")
public interface IItemPriceDgQueryApi {

    @PostMapping(value = "/queryBySkuIds")
    @ApiOperation(value = "根据skuIds获取商品价格", notes = "根据skuIds获取商品价格", response = ItemPriceDgRespDto.class)
    RestResponse<List<ItemPriceDgRespDto>> queryBySkuIds(@RequestBody List<Long> skuIds);

}
