package com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 商品SKU授权请求DTO
 * 
 * @author system
 * @date 2024-01-01
 */
@ApiModel(value = "ItemSkuAuthReqDto", description = "商品SKU授权请求DTO")
public class ItemSkuAuthReqDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * SKU ID列表
     */
    @NotNull(message = "SKU ID列表不能为空")
    @ApiModelProperty(value = "SKU ID列表", required = true)
    private List<Long> skuIds;

    /**
     * 组织ID
     */
    @NotNull(message = "组织ID不能为空")
    @ApiModelProperty(value = "组织ID", required = true)
    private Long organizationId;

    /**
     * 授权状态：0-未授权，1-已授权
     */
    @NotNull(message = "授权状态不能为空")
    @ApiModelProperty(value = "授权状态：0-未授权，1-已授权", required = true)
    private Integer authStatus;

    /**
     * 状态：0-禁用，1-启用
     */
    @ApiModelProperty(value = "状态：0-禁用，1-启用")
    private Integer status = 1;

    /**
     * 实例ID
     */
    @ApiModelProperty(value = "实例ID")
    private Long instanceId;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    // Getters and Setters
    public List<Long> getSkuIds() {
        return skuIds;
    }

    public void setSkuIds(List<Long> skuIds) {
        this.skuIds = skuIds;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public Integer getAuthStatus() {
        return authStatus;
    }

    public void setAuthStatus(Integer authStatus) {
        this.authStatus = authStatus;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
} 