/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemRelationQueryConditionReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemComparisonRelationRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtRelationComparisonRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemRelationInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemSkuPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.RItemBundleQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.RItemBundleRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtRelationComparisonQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemExtRelationComparisonService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IRItemBundleService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import liquibase.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ItemExtRelationComparisonQueryApiImpl
implements IItemExtRelationComparisonQueryApi {
    @Resource
    private IItemExtRelationComparisonService itemExtRelationComparisonService;
    @Resource(name="${project.domain.prefix:tcbj}RItemBundleService")
    private IRItemBundleService irItemBundleService;

    public RestResponse<ItemExtRelationComparisonRespDto> queryById(Long id) {
        return new RestResponse((Object)this.itemExtRelationComparisonService.queryById(id));
    }

    public RestResponse<ItemComparisonRelationRespDto> queryRelationById(Long id) {
        return new RestResponse((Object)this.itemExtRelationComparisonService.queryRelationById(id));
    }

    public RestResponse<PageInfo<ItemExtRelationComparisonRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.itemExtRelationComparisonService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<List<ItemExtRelationComparisonRespDto>> queryRelationByShopList(List<String> shopCodes) {
        return new RestResponse(this.itemExtRelationComparisonService.queryRelationByShopList(shopCodes));
    }

    public RestResponse<PageInfo<ItemRelationInfoRespDto>> queryItemRelationByPage(ItemRelationQueryConditionReqDto queryConditionReqDto) {
        return new RestResponse(this.itemExtRelationComparisonService.queryItemRelationByPage(queryConditionReqDto));
    }

    public RestResponse<PageInfo<ItemRelationInfoRespDto>> exportRelation(ItemRelationQueryConditionReqDto queryConditionReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.itemExtRelationComparisonService.exportRelation(queryConditionReqDto, pageNum, pageSize));
    }

    public RestResponse<String> export(ItemRelationQueryConditionReqDto queryConditionReqDto) {
        return new RestResponse((Object)this.itemExtRelationComparisonService.export(queryConditionReqDto));
    }

    public RestResponse<ItemSkuPriceRespDto> queryItemSkuPriceByChnSkuCode(String channelSkuCode) {
        ItemSkuPriceRespDto dto = null;
        if (StringUtils.isNotEmpty((String)channelSkuCode)) {
            ArrayList<String> channelSkuCodeList = new ArrayList<String>();
            channelSkuCodeList.add(channelSkuCode);
            List<ItemSkuPriceRespDto> dtoList = this.itemExtRelationComparisonService.queryItemSkuPriceByChnSkuCodeList(channelSkuCodeList);
            if (CollectionUtils.isNotEmpty(dtoList)) {
                dto = dtoList.get(0);
            }
        }
        return new RestResponse(dto);
    }

    public RestResponse<List<ItemSkuPriceRespDto>> queryItemSkuPriceByChnSkuCodeList(List<String> channelSkuCodeList) {
        return new RestResponse(this.itemExtRelationComparisonService.queryItemSkuPriceByChnSkuCodeList(channelSkuCodeList));
    }

    public RestResponse<List<ItemRelationInfoRespDto>> queryByChannelItemCodes(List<String> channelItemCodes) {
        return new RestResponse(this.itemExtRelationComparisonService.queryByChannelItemCodes(channelItemCodes));
    }

    public RestResponse<List<ItemSkuPriceRespDto>> queryRelationByTypeCodeList(List<String> codeList, String codeType) {
        return new RestResponse(this.itemExtRelationComparisonService.queryRelationByTypeCodeList(codeList, codeType));
    }

    public RestResponse<List<ItemSkuPriceRespDto>> queryRelationByTypeCodeListNew(List<String> codeList, String codeType, String shopCode) {
        return new RestResponse(this.itemExtRelationComparisonService.queryRelationByTypeCodeListNew(codeList, codeType, shopCode));
    }

    public RestResponse<List<RItemBundleRespDto>> queryRItemBundleByItemIds(List<Long> itemIdList) {
        return new RestResponse(this.irItemBundleService.queryRItemBundleByItemIds(itemIdList));
    }

    public RestResponse<List<RItemBundleQueryRespDto>> queryRItemBundleBySkuCodes(List<String> skuCodeList) {
        return new RestResponse(this.irItemBundleService.queryBundleItemSku(skuCodeList));
    }

    public RestResponse<List<ItemSkuPriceRespDto>> queryRelationByItemKeysAndShopCode(List<String> channelItemKeyList, String shopCode) {
        return new RestResponse(this.itemExtRelationComparisonService.queryRelationByItemKeysAndShopCode(channelItemKeyList, shopCode));
    }
}

