/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.scheduler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfTaskStatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfTaskTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.AllowOrderTimeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.OffItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfTimeDetailReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfTimeReqDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemShelfService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfTaskDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfTaskEo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="shelfTask")
@Scope(value="prototype")
public class ShelfTask
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(ShelfTask.class);
    @Resource
    private IItemShelfService itemShelfService;
    @Resource
    private ShelfTaskDas shelfTaskDas;

    public void before(TaskMsg taskMsg) {
        System.out.println("\u6267\u884c\u4efb\u52a1\u524d..");
    }

    public boolean execute(TaskMsg taskMsg) {
        block7: {
            logger.info("\u4efb\u52a1\u8c03\u5ea6\u6267\u884c\uff0c\u6267\u884c\u4e0a\u4e0b\u67b6\u5b9a\u5236\u4efb\u52a1\uff0c\u53c2\u6570:{}", (Object)taskMsg.getTaskId());
            Long taskId = taskMsg.getTaskId();
            ShelfTaskEo shelfTaskEo = ShelfTaskEo.newInstance();
            shelfTaskEo.setTaskId(taskId);
            try {
                ArrayList<ItemShelfReqDto> onShelfReqDtos = new ArrayList<ItemShelfReqDto>();
                ArrayList<OffItemReqDto> offItemReqDtos = new ArrayList<OffItemReqDto>();
                shelfTaskEo.setStatus(ShelfTaskStatusEnum.UNPROCESSED.getStatus());
                List shelfTaskEoList = this.shelfTaskDas.select((BaseEo)shelfTaskEo);
                for (ShelfTaskEo eo : shelfTaskEoList) {
                    if (ShelfTaskTypeEnum.ON.getType().equals(eo.getType())) {
                        ItemShelfReqDto itemShelfReqDto = new ItemShelfReqDto();
                        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)itemShelfReqDto);
                        JSONObject jsonObject = JSON.parseObject((String)taskMsg.getContent());
                        if (jsonObject != null) {
                            itemShelfReqDto.setPrice(jsonObject.getBigDecimal("price"));
                            itemShelfReqDto.setPriceId(jsonObject.getLong("priceId"));
                        }
                        ShelfTimeReqDto shelfTimeReqDto = new ShelfTimeReqDto();
                        ArrayList<ShelfTimeDetailReqDto> shelfTimeDetailReqDtos = new ArrayList<ShelfTimeDetailReqDto>();
                        ShelfTimeDetailReqDto shelfTimeDetailReqDto = new ShelfTimeDetailReqDto();
                        List allowOrderTimeReqDtos = JSON.parseArray((String)eo.getAllowOrderTime(), AllowOrderTimeReqDto.class);
                        shelfTimeDetailReqDto.setOnShelfTime(eo.getShelfTime());
                        shelfTimeDetailReqDto.setAllowOrderTimeReqDtoList(allowOrderTimeReqDtos);
                        shelfTimeDetailReqDtos.add(shelfTimeDetailReqDto);
                        shelfTimeReqDto.setShelfTimeDetailReqDtoList(shelfTimeDetailReqDtos);
                        itemShelfReqDto.setShelfTimeReqDto(shelfTimeReqDto);
                        itemShelfReqDto.setTiming(false);
                        onShelfReqDtos.add(itemShelfReqDto);
                        continue;
                    }
                    if (!ShelfTaskTypeEnum.OFF.getType().equals(eo.getType())) continue;
                    OffItemReqDto offItemReqDto = new OffItemReqDto();
                    DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)offItemReqDto);
                    offItemReqDto.setOffTime(eo.getShelfTime());
                    offItemReqDtos.add(offItemReqDto);
                }
                if (CollectionUtils.isNotEmpty(onShelfReqDtos)) {
                    this.itemShelfService.onShelfOperation(onShelfReqDtos, false, taskId);
                }
                if (!CollectionUtils.isNotEmpty(offItemReqDtos)) break block7;
                this.itemShelfService.offShelfOperation(offItemReqDtos, false, taskId);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                List queryEos = this.shelfTaskDas.select((BaseEo)shelfTaskEo);
                for (ShelfTaskEo eo : queryEos) {
                    eo.setStatus(ShelfTaskStatusEnum.FAIL.getStatus());
                    this.shelfTaskDas.updateSelective((BaseEo)eo);
                }
            }
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        System.out.println("\u6267\u884c\u4efb\u52a1\u540e..");
    }
}

