/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemPriceLogReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemProductLogReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemPriceLogRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemPriceLogService;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemPriceLogDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemPriceLogEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemPriceLogServiceImpl
implements IItemPriceLogService {
    @Resource
    private ItemPriceLogDas itemPriceLogDas;

    @Override
    public Long addItemPriceLog(ItemPriceLogReqDto addReqDto) {
        ItemPriceLogEo itemPriceLogEo = new ItemPriceLogEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemPriceLogEo);
        this.itemPriceLogDas.insert((BaseEo)itemPriceLogEo);
        return itemPriceLogEo.getId();
    }

    @Override
    public void batchAddItemPriceLog(List<ItemPriceLogReqDto> addReqList) {
        ArrayList<ItemPriceLogEo> itemPriceLogEoList = new ArrayList<ItemPriceLogEo>();
        if (CollectionUtils.isNotEmpty(addReqList)) {
            for (ItemPriceLogReqDto addReqDto : addReqList) {
                ItemPriceLogEo itemPriceLogEo = new ItemPriceLogEo();
                DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemPriceLogEo);
                itemPriceLogEoList.add(itemPriceLogEo);
            }
        }
        if (CollectionUtils.isNotEmpty(addReqList)) {
            this.itemPriceLogDas.insertBatch(itemPriceLogEoList);
        }
    }

    @Override
    public void modifyItemPriceLog(ItemPriceLogReqDto modifyReqDto) {
        ItemPriceLogEo itemPriceLogEo = new ItemPriceLogEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemPriceLogEo);
        this.itemPriceLogDas.updateSelective((BaseEo)itemPriceLogEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemPriceLog(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemPriceLogDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ItemPriceLogRespDto queryById(Long id) {
        ItemPriceLogEo itemPriceLogEo = (ItemPriceLogEo)this.itemPriceLogDas.selectByPrimaryKey(id);
        ItemPriceLogRespDto itemPriceLogRespDto = new ItemPriceLogRespDto();
        DtoHelper.eo2Dto((BaseEo)itemPriceLogEo, (BaseVo)itemPriceLogRespDto);
        return itemPriceLogRespDto;
    }

    @Override
    public PageInfo<ItemPriceLogRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemPriceLogReqDto itemPriceLogReqDto = (ItemPriceLogReqDto)JSON.parseObject((String)filter, ItemPriceLogReqDto.class);
        ItemPriceLogEo itemPriceLogEo = new ItemPriceLogEo();
        DtoHelper.dto2Eo((BaseVo)itemPriceLogReqDto, (BaseEo)itemPriceLogEo);
        PageInfo eoPageInfo = this.itemPriceLogDas.selectPage((BaseEo)itemPriceLogEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemPriceLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ItemPriceLogRespDto> queryByPage(ItemProductLogReqDto reqDto) {
        ItemPriceLogEo itemPriceLogEo = new ItemPriceLogEo();
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getProductCode())) {
            itemPriceLogEo.setProductCode(reqDto.getProductCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCode())) {
            itemPriceLogEo.setCode(reqDto.getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getName())) {
            itemPriceLogEo.setName(reqDto.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getProductUnit())) {
            itemPriceLogEo.setProductUnit(reqDto.getProductUnit());
        }
        PageInfo eoPageInfo = this.itemPriceLogDas.selectPage((BaseEo)itemPriceLogEo, reqDto.getPageNum(), reqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemPriceLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

