/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfStatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.Constant;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.FileType;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemExtExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemType;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ShelfAddressEnum;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.StatisticsType;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemEffectiveReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemMoveReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemQueryConditionReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemStatisticsReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.EffectiveStaticsItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemStatisticsRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemStatisticsService;
import com.dtyunxi.yundt.cube.center.item.biz.utils.PageInfoUtil;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemStorageDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemStatisticsDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.RItemBundleDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemStatisticsEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.RItemBundleEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemStorageEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemStorageEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.vo.ItemStatisticsReqVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ItemStatisticsServiceImpl
implements IItemStatisticsService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ItemStatisticsDas itemStatisticsDas;
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemMediasDas mediasDas;
    @Resource
    private ItemSkuDas skuDas;
    @Resource
    private ItemStorageDas itemStorageDas;
    static final Integer PRICE_SYSTEM = 1;
    @Value(value="${item.statistics.size:50}")
    private Integer statisticsSize = 50;
    @Resource
    private RItemBundleDas rItemBundleDas;
    @Resource
    private ShelfDas shelfDas;
    @Value(value="${item.storage.isVirStorage:false}")
    private boolean isVirStorage;

    @Override
    public Long addItemStatistics(ItemStatisticsReqDto addReqDto) {
        ItemStatisticsEo itemStatisticsEo = new ItemStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemStatisticsEo);
        this.itemStatisticsDas.insert((BaseEo)itemStatisticsEo);
        return itemStatisticsEo.getId();
    }

    @Override
    public void addBatchItemStatistics(List<ItemStatisticsReqDto> reqDtos) {
        List itemStatisticsEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemStatisticsDas.filter().eq((Object)"effective_status", (Object)StatisticsType.EFFECTIVE_STATUS.getStatus())).orderByDesc((Object)"sort")).list();
        if (itemStatisticsEoList.size() >= this.statisticsSize) {
            throw new BizException(ItemExtExceptionCode.STATISTICS_OVER_COUNT.getCode(), ItemExtExceptionCode.STATISTICS_OVER_COUNT.getMsg());
        }
        List itemCodes = reqDtos.stream().map(ItemStatisticsReqDto::getItemCode).collect(Collectors.toList());
        List itemEos = ((ExtQueryChainWrapper)this.itemDas.filter().in((Object)"code", itemCodes)).list();
        Map itemEoMap = itemEos.stream().collect(Collectors.toMap(StdItemEo::getCode, Function.identity(), (k1, k2) -> k1));
        ItemStatisticsEo currentStatisticsEo = null;
        Integer currentSort = 0;
        if (!CollectionUtils.isEmpty((Collection)itemStatisticsEoList)) {
            currentStatisticsEo = (ItemStatisticsEo)itemStatisticsEoList.get(0);
            currentSort = currentStatisticsEo.getSort();
        }
        ArrayList<ItemStatisticsEo> statisticsEos = new ArrayList<ItemStatisticsEo>();
        Integer maxSort = this.itemStatisticsDas.getMaxSort();
        for (ItemStatisticsReqDto v : reqDtos) {
            ItemStatisticsEo statisticsEo = new ItemStatisticsEo();
            statisticsEo.setItemId(v.getItemId());
            statisticsEo.setItemCode(v.getItemCode());
            statisticsEo.setTop(Integer.valueOf(0));
            List itemStatisticsEos = this.itemStatisticsDas.select((BaseEo)statisticsEo, false);
            if (!CollectionUtils.isEmpty((Collection)itemStatisticsEos)) continue;
            if (!CollectionUtils.isEmpty(itemEoMap)) {
                ItemEo itemEo = (ItemEo)itemEoMap.get(v.getItemCode());
                statisticsEo.setSpecContent(null == itemEo ? null : itemEo.getSpecContent());
            }
            statisticsEo.setEffectiveStatus(StatisticsType.EFFECTIVE_STATUS.getStatus());
            statisticsEo.setIsDisable(StatisticsType.ENABLE.getStatus());
            statisticsEo.setSort(Integer.valueOf(maxSort + 1));
            statisticsEo.setId(null);
            Integer n = maxSort;
            Integer n2 = maxSort = Integer.valueOf(maxSort + 1);
            statisticsEos.add(statisticsEo);
        }
        this.saveStatistics(statisticsEos);
        List statisticsEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemStatisticsDas.filter().eq((Object)"effective_status", (Object)StatisticsType.EFFECTIVE_STATUS.getStatus())).orderByDesc((Object)"sort")).list();
        ItemStatisticsEo nextStatisticsEo = null;
        Integer nextSort = 0;
        if (!CollectionUtils.isEmpty((Collection)statisticsEoList)) {
            nextStatisticsEo = (ItemStatisticsEo)statisticsEoList.get(0);
            nextSort = nextStatisticsEo.getSort();
        }
        if (null != currentStatisticsEo && null != nextStatisticsEo) {
            currentStatisticsEo.setSort(nextSort);
            nextStatisticsEo.setSort(currentSort);
            this.itemStatisticsDas.updateSelective((BaseEo)currentStatisticsEo);
            this.itemStatisticsDas.updateSelective((BaseEo)nextStatisticsEo);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveStatistics(List<ItemStatisticsEo> statisticsEos) {
        if (!CollectionUtils.isEmpty(statisticsEos)) {
            this.itemStatisticsDas.insertBatch(statisticsEos);
        }
    }

    @Override
    public void modifyItemStatistics(ItemStatisticsReqDto modifyReqDto) {
        ItemStatisticsEo itemStatisticsEo = new ItemStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemStatisticsEo);
        this.itemStatisticsDas.updateSelective((BaseEo)itemStatisticsEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemStatistics(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemStatisticsDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void removeStatistics(Long id) {
        this.itemStatisticsDas.logicDeleteById(id);
    }

    @Override
    public void enableStatisticsItem(Long id) {
        ItemStatisticsEo statisticsEo = (ItemStatisticsEo)this.itemStatisticsDas.selectByPrimaryKey(id);
        if (statisticsEo == null) {
            throw new BizException(ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getMsg());
        }
        if (StatisticsType.ENABLE.getStatus() == statisticsEo.getIsDisable()) {
            statisticsEo.setIsDisable(StatisticsType.DISABLE.getStatus());
            statisticsEo.setEffectiveStatus(StatisticsType.LOSE_EFFECTIVE.getStatus());
        } else {
            List itemStatisticsEos = ((ExtQueryChainWrapper)this.itemStatisticsDas.filter().eq((Object)"effective_status", (Object)StatisticsType.EFFECTIVE_STATUS.getStatus())).list();
            if (itemStatisticsEos.size() >= this.statisticsSize) {
                throw new BizException(ItemExtExceptionCode.STATISTICS_ITEM_COUNT.getCode(), ItemExtExceptionCode.STATISTICS_ITEM_COUNT.getMsg());
            }
            statisticsEo.setIsDisable(StatisticsType.ENABLE.getStatus());
            statisticsEo.setEffectiveStatus(StatisticsType.EFFECTIVE_STATUS.getStatus());
        }
        this.itemStatisticsDas.updateSelective((BaseEo)statisticsEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void moveUp(ItemMoveReqDto reqDto) {
        if (reqDto == null) {
            throw new BizException(ItemExtExceptionCode.METHOD_PARAM_EMPTY.getCode(), ItemExtExceptionCode.METHOD_PARAM_EMPTY.getMsg());
        }
        if (null == reqDto.getPreId()) {
            throw new BizException(ItemExtExceptionCode.ITEM_NOT_MOVE_UP.getCode(), ItemExtExceptionCode.ITEM_NOT_MOVE_UP.getMsg());
        }
        ItemStatisticsEo statisticsEo = (ItemStatisticsEo)((ExtQueryChainWrapper)this.itemStatisticsDas.filter().eq((Object)"id", (Object)reqDto.getCurrentId())).one();
        if (statisticsEo == null) {
            throw new BizException(ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getMsg());
        }
        Integer currentSort = statisticsEo.getSort();
        ItemStatisticsEo statisticsEoPrev = (ItemStatisticsEo)((ExtQueryChainWrapper)this.itemStatisticsDas.filter().eq((Object)"id", (Object)reqDto.getPreId())).one();
        if (statisticsEoPrev == null) {
            throw new BizException(ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getMsg());
        }
        Integer preSort = statisticsEoPrev.getSort();
        statisticsEo.setSort(preSort);
        statisticsEoPrev.setSort(currentSort);
        if ("1".equals(reqDto.getTop())) {
            statisticsEo.setTop(Integer.valueOf(1));
            statisticsEoPrev.setTop(Integer.valueOf(0));
        }
        this.itemStatisticsDas.updateSelective((BaseEo)statisticsEo);
        this.itemStatisticsDas.updateSelective((BaseEo)statisticsEoPrev);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void moveDown(ItemMoveReqDto reqDto) {
        if (reqDto == null) {
            throw new BizException(ItemExtExceptionCode.METHOD_PARAM_EMPTY.getCode(), ItemExtExceptionCode.METHOD_PARAM_EMPTY.getMsg());
        }
        if (null == reqDto.getNextId()) {
            throw new BizException(ItemExtExceptionCode.ITEM_NOT_MOVE_DOWN.getCode(), ItemExtExceptionCode.ITEM_NOT_MOVE_DOWN.getMsg());
        }
        ItemStatisticsEo statisticsEo = (ItemStatisticsEo)((ExtQueryChainWrapper)this.itemStatisticsDas.filter().eq((Object)"id", (Object)reqDto.getCurrentId())).one();
        if (statisticsEo == null) {
            throw new BizException(ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getMsg());
        }
        Integer currentSort = statisticsEo.getSort();
        ItemStatisticsEo statisticsEoNext = (ItemStatisticsEo)((ExtQueryChainWrapper)this.itemStatisticsDas.filter().eq((Object)"id", (Object)reqDto.getNextId())).one();
        if (statisticsEoNext == null) {
            throw new BizException(ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getMsg());
        }
        Integer nextSort = statisticsEoNext.getSort();
        statisticsEo.setSort(nextSort);
        statisticsEoNext.setSort(currentSort);
        this.itemStatisticsDas.updateSelective((BaseEo)statisticsEo);
        this.itemStatisticsDas.updateSelective((BaseEo)statisticsEoNext);
    }

    @Override
    public ItemStatisticsRespDto queryById(Long id) {
        ItemStatisticsEo itemStatisticsEo = (ItemStatisticsEo)this.itemStatisticsDas.selectByPrimaryKey(id);
        ItemStatisticsRespDto itemStatisticsRespDto = new ItemStatisticsRespDto();
        DtoHelper.eo2Dto((BaseEo)itemStatisticsEo, (BaseVo)itemStatisticsRespDto);
        return itemStatisticsRespDto;
    }

    @Override
    public PageInfo<ItemStatisticsRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemStatisticsReqDto itemStatisticsReqDto = (ItemStatisticsReqDto)JSON.parseObject((String)filter, ItemStatisticsReqDto.class);
        ItemStatisticsEo itemStatisticsEo = new ItemStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)itemStatisticsReqDto, (BaseEo)itemStatisticsEo);
        PageInfo eoPageInfo = this.itemStatisticsDas.selectPage((BaseEo)itemStatisticsEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemStatisticsRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ItemStatisticsRespDto> page(ItemQueryConditionReqDto queryConditionReqDto) {
        ArrayList statisticsRespDtos = Lists.newArrayList();
        ItemStatisticsReqVo reqVo = new ItemStatisticsReqVo();
        reqVo.setItemCode(queryConditionReqDto.getItemCode());
        reqVo.setItemName(queryConditionReqDto.getItemName());
        reqVo.setSpecContent(queryConditionReqDto.getSpecContent());
        ArrayList topList = Lists.newArrayList();
        List respVosTop = this.itemStatisticsDas.queryStatisticesTop(reqVo);
        CubeBeanUtils.copyCollection((Collection)topList, (Collection)respVosTop, ItemStatisticsRespDto.class);
        ArrayList sortList = Lists.newArrayList();
        List respVosSort = this.itemStatisticsDas.queryStatisticesSortList(reqVo);
        CubeBeanUtils.copyCollection((Collection)sortList, (Collection)respVosSort, ItemStatisticsRespDto.class);
        statisticsRespDtos.addAll(topList);
        statisticsRespDtos.addAll(sortList);
        PageInfo pageInfo = PageInfoUtil.selectPage(statisticsRespDtos, queryConditionReqDto.getPageNum(), queryConditionReqDto.getPageSize());
        return pageInfo;
    }

    @Override
    public PageInfo<ItemStatisticsRespDto> queryPage(ItemQueryConditionReqDto queryConditionReqDto) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.itemStatisticsDas.filter().orderByDesc((Object)"top");
        if (StringUtils.isNotBlank((CharSequence)queryConditionReqDto.getItemCode())) {
            sqlFilters.like((Object)"item_code", (Object)("%" + queryConditionReqDto.getItemCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)queryConditionReqDto.getItemName())) {
            ExtQueryChainWrapper sqlFilterList = this.itemDas.filter();
            sqlFilterList.like((Object)"name", (Object)("%" + queryConditionReqDto.getItemName() + "%"));
            List itemEoList = sqlFilterList.list();
            if (!CollectionUtils.isEmpty((Collection)itemEoList)) {
                List itemCodes = itemEoList.stream().map(StdItemEo::getCode).collect(Collectors.toList());
                sqlFilters.in((Object)"item_code", itemCodes);
            } else {
                sqlFilters.eq((Object)"item_code", (Object)queryConditionReqDto.getItemName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)queryConditionReqDto.getSpecContent())) {
            sqlFilters.like((Object)"spec_content", (Object)("%" + queryConditionReqDto.getSpecContent() + "%"));
        }
        PageInfo eoPageInfo = sqlFilters.page(queryConditionReqDto.getPageNum(), queryConditionReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemStatisticsRespDto.class);
        if (CollectionUtils.isEmpty(dtoList)) {
            return dtoPageInfo;
        }
        List itemEos = this.itemDas.selectByIds(dtoList.stream().map(ItemStatisticsRespDto::getItemId).collect(Collectors.toList()));
        Map itemEosMap = null;
        if (!CollectionUtils.isEmpty((Collection)itemEos)) {
            itemEosMap = itemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k2));
        }
        Map finalItemEosMap = itemEosMap;
        dtoList.stream().forEach(v -> {
            if (!CollectionUtils.isEmpty((Map)finalItemEosMap)) {
                v.setItemName(finalItemEosMap.get(v.getItemId()) == null ? null : ((ItemEo)finalItemEosMap.get(v.getItemId())).getName());
                v.setItemId(finalItemEosMap.get(v.getItemId()) == null ? null : ((ItemEo)finalItemEosMap.get(v.getItemId())).getId());
                v.setItemCode(finalItemEosMap.get(v.getItemId()) == null ? null : ((ItemEo)finalItemEosMap.get(v.getItemId())).getCode());
                v.setSpecContent(finalItemEosMap.get(v.getItemId()) == null ? null : ((ItemEo)finalItemEosMap.get(v.getItemId())).getSpecContent());
            }
            v.setEffectiveStatusName(Constant.EffectiveStatus.get((String)String.valueOf(v.getEffectiveStatus())));
            v.setIsDisableName(Constant.IsDisable.get((String)String.valueOf(v.getIsDisable())));
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<EffectiveStaticsItemRespDto> getEffectiveItem(ItemEffectiveReqDto itemEffectiveReqDto) {
        List itemStorageEos;
        List<Object> staticsItemRespDtos = new ArrayList<EffectiveStaticsItemRespDto>();
        List itemEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemDas.filter().in((Object)"id", (Collection)itemEffectiveReqDto.getItemIds())).ne((Object)"type", (Object)ItemType.GIF_ITEM.getStatus())).list();
        if (CollectionUtils.isEmpty((Collection)itemEoList)) {
            return staticsItemRespDtos;
        }
        List shelfEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shelfDas.filter().in((Object)"item_id", (Collection)itemEoList.stream().map(BaseEo::getId).collect(Collectors.toList()))).eq((Object)"status", (Object)ShelfStatusEnum.ON_SHELF.getCode())).eq((Object)"shelf_address", (Object)(StringUtils.isBlank((CharSequence)itemEffectiveReqDto.getShelfAddress()) ? ShelfAddressEnum.INTERNAL.getCode() : itemEffectiveReqDto.getShelfAddress()))).list();
        if (CollectionUtils.isEmpty((Collection)shelfEos)) {
            return staticsItemRespDtos;
        }
        PageInfo pageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemStatisticsDas.filter().eq((Object)"effective_status", (Object)StatisticsType.EFFECTIVE_STATUS.getStatus())).eq((Object)"is_disable", (Object)StatisticsType.ENABLE.getStatus())).in((Object)"item_id", (Collection)shelfEos.stream().map(StdShelfEo::getItemId).collect(Collectors.toList()))).orderByDesc((Object)"sort")).last(" limit 50")).page(Integer.valueOf(itemEffectiveReqDto.getPageNum() == null ? 1 : itemEffectiveReqDto.getPageNum()), Integer.valueOf(Integer.MAX_VALUE));
        List statisticsEoList = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)statisticsEoList)) {
            return staticsItemRespDtos;
        }
        Map<Long, List<ItemStorageEo>> itemStorageEoMap = null;
        if (this.isVirStorage && !CollectionUtils.isEmpty((Collection)(itemStorageEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemStorageDas.filter().in((Object)"item_id", (Collection)itemEffectiveReqDto.getItemIds())).orderByDesc((Object)"update_time")).list()))) {
            itemStorageEoMap = itemStorageEos.stream().collect(Collectors.groupingBy(StdItemStorageEo::getItemId));
        }
        List itemEos = this.itemDas.selectByIds(itemEffectiveReqDto.getItemIds());
        Map itemEosMap = null;
        if (!CollectionUtils.isEmpty((Collection)itemEos)) {
            itemEosMap = itemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k2));
        }
        List itemSkuEos = this.skuDas.selectByItemIds(itemEffectiveReqDto.getItemIds());
        Map itemSkuEoMap = null;
        if (!CollectionUtils.isEmpty((Collection)itemSkuEos)) {
            itemSkuEoMap = itemSkuEos.stream().collect(Collectors.toMap(StdItemSkuEo::getItemId, Function.identity(), (k1, k2) -> k2));
        }
        List itemMedias = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.mediasDas.filter().in((Object)"item_id", (Collection)itemEffectiveReqDto.getItemIds())).eq((Object)"file_type", (Object)FileType.ITEM_PIC.getStatus())).list();
        Map<Long, List<ItemMediasEo>> itemMediasMap = null;
        if (!CollectionUtils.isEmpty((Collection)itemMedias)) {
            itemMediasMap = itemMedias.stream().collect(Collectors.groupingBy(StdItemMediasEo::getItemId));
        }
        Map finalItemEosMap = itemEosMap;
        Map<Long, List<ItemMediasEo>> finalItemMediasMap = itemMediasMap;
        Map finalItemSkuEoMap = itemSkuEoMap;
        Map<Long, List<ItemStorageEo>> finalItemStorageEoMap = itemStorageEoMap;
        staticsItemRespDtos = statisticsEoList.stream().map(v -> {
            List mediasEoList;
            EffectiveStaticsItemRespDto respDto = new EffectiveStaticsItemRespDto();
            respDto.setId(v.getId());
            respDto.setItemCode(v.getItemCode());
            respDto.setItemId(v.getItemId());
            if (!CollectionUtils.isEmpty((Map)finalItemSkuEoMap)) {
                ItemSkuEo itemSkuEo = (ItemSkuEo)finalItemSkuEoMap.get(v.getItemId());
                respDto.setSkuId(itemSkuEo != null ? itemSkuEo.getId() : null);
            }
            if (!CollectionUtils.isEmpty((Map)finalItemEosMap)) {
                List rItemBundleEos;
                ItemEo itemEo = (ItemEo)finalItemEosMap.get(v.getItemId());
                respDto.setItemName(itemEo != null ? itemEo.getName() : null);
                respDto.setShopId(itemEo != null ? itemEo.getShopId() : null);
                respDto.setSalesCount(Long.valueOf(itemEo.getSalesCount() == null ? 0L : itemEo.getSalesCount()));
                respDto.setType(itemEo != null ? itemEo.getType() : null);
                if (this.isVirStorage) {
                    if (ItemType.COMB_ITEM.getStatus() == itemEo.getType()) {
                        List<RItemBundleEo> rItemBundleEos2 = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().eq((Object)"item_id", (Object)v.getItemId())).list();
                        if (!CollectionUtils.isEmpty((Collection)rItemBundleEos2)) {
                            rItemBundleEos2.forEach(i -> {
                                List itemStorageEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemStorageDas.filter().eq((Object)"shop_id", (Object)itemEo.getShopId())).eq((Object)"item_id", (Object)i.getSubItemId())).eq((Object)"sku_id", (Object)i.getSubSkuId())).orderByDesc((Object)"inventory_effective_date")).list();
                                ItemStorageEo itemStorageEo = new ItemStorageEo();
                                if (!CollectionUtils.isEmpty((Collection)itemStorageEoList)) {
                                    itemStorageEo = (ItemStorageEo)itemStorageEoList.get(0);
                                    Long num = itemStorageEo.getBalance() / (long)i.getNum().intValue();
                                    i.setNum(Integer.valueOf(num.intValue()));
                                } else {
                                    i.setNum(Integer.valueOf(0));
                                }
                            });
                            rItemBundleEos2 = rItemBundleEos2.stream().sorted(Comparator.comparing(RItemBundleEo::getNum)).collect(Collectors.toList());
                            respDto.setStorge(String.valueOf(((RItemBundleEo)rItemBundleEos2.get(0)).getNum()));
                        }
                    } else if (!CollectionUtils.isEmpty((Map)finalItemStorageEoMap)) {
                        List storageEo = (List)finalItemStorageEoMap.get(v.getItemId());
                        if (storageEo != null) {
                            respDto.setStorge(((ItemStorageEo)storageEo.get(0)).getBalance() > 0L ? String.valueOf(((ItemStorageEo)storageEo.get(0)).getBalance()) : "0");
                        } else {
                            respDto.setStorge("0");
                        }
                    }
                } else if (ItemType.COMB_ITEM.getStatus() == itemEo.getType() && !CollectionUtils.isEmpty((Collection)(rItemBundleEos = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().eq((Object)"item_id", (Object)v.getItemId())).list()))) {
                    Map<String, Integer> subItemCodeMap = rItemBundleEos.stream().collect(Collectors.toMap(eo1 -> eo1.getSubItemCode(), eo1 -> eo1.getNum(), (s, a) -> s + a));
                    respDto.setSubItemCodeMap(subItemCodeMap);
                }
            }
            if (!CollectionUtils.isEmpty((Map)finalItemMediasMap) && !CollectionUtils.isEmpty((Collection)(mediasEoList = (List)finalItemMediasMap.get(v.getItemId())))) {
                respDto.setImagePath(((ItemMediasEo)mediasEoList.get(0)).getPath1());
            }
            return respDto;
        }).collect(Collectors.toList());
        return staticsItemRespDtos;
    }
}

