/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.UnitReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemProValue;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemSycnExtReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.SapMaterialDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemAttributesService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSkuService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IUnitService;
import com.dtyunxi.yundt.cube.center.item.biz.enus.SapProductDosageFormEnum;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemExtendService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemSycnExtService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.PropValueDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.PropValueEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class IItemSycnExtServiceImpl
implements IItemSycnExtService {
    private static Logger logger = LoggerFactory.getLogger(IItemSycnExtServiceImpl.class);
    @Resource(name="${project.domain.prefix:tcbj}ItemQueryApi")
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemAttributesService iItemAttributesService;
    @Resource
    private PropValueDas propValueDas;
    @Resource(name="itemSkuQueryApi")
    private IItemSkuQueryApi iItemSkuQueryApi;
    @Resource(name="brandQueryApi")
    private IBrandQueryApi brandQueryApi;
    @Resource(name="pcpItemQueryApiImpl")
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource
    private IItemService itemService;
    @Resource(name="${project.domain.prefix:tcbj}ItemExtendService")
    private IItemExtendService itemExtendService;
    @Resource
    private IItemSkuService itemSkuService;
    @Resource
    private IUnitService unitService;
    @Resource
    private ItemExtDas itemExtDas;
    @Resource
    private ICommonsMqService commonsMqService;

    @Override
    public void updateItem(List<ItemSycnExtReqDto> itemSycnExtReqDto) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemSycnExtReqDto)) {
            itemSycnExtReqDto.stream().forEach(t -> {
                HashMap<String, Object> itemMap = new HashMap<String, Object>();
                itemMap.put("longCode", t.getLongCode());
                itemMap.put("bizType", 2);
                List itemRespDtos = ((PageInfo)this.itemQueryApi.queryByPage(JSONObject.toJSONString(itemMap), Integer.valueOf(1), Integer.valueOf(10)).getData()).getList();
                logger.info("\u67e5\u8be2\u5546\u54c1\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)itemRespDtos));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemRespDtos)) {
                    List<ItemAttributesEo> attributesEos = this.iItemAttributesService.queryByItemIds(Lists.newArrayList((Object[])new Long[]{((ItemRespDto)itemRespDtos.get(0)).getId()}));
                    logger.info("\u67e5\u8be2Attributes\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(attributesEos));
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(attributesEos)) {
                        ItemAttributesEo itemAttributesEo = new ItemAttributesEo();
                        CubeBeanUtils.copyProperties((Object)itemAttributesEo, (Object)attributesEos.get(0), (String[])new String[0]);
                        logger.info("copy \u5546\u54c1attr\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)itemAttributesEo));
                        itemAttributesEo.setAttrs(t.getAttrs());
                        this.iItemAttributesService.modifyProp(itemAttributesEo);
                    }
                    List skuRespDtos = (List)this.iItemSkuQueryApi.queryBySkuCode((List)Lists.newArrayList((Object[])new String[]{t.getLongCode()})).getData();
                    logger.info("\u67e5\u8be2sku\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)skuRespDtos));
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)skuRespDtos)) {
                        ItemBundleReqDto itemBundleReqDtos = new ItemBundleReqDto();
                        CubeBeanUtils.copyProperties((Object)itemBundleReqDtos, skuRespDtos.get(0), (String[])new String[0]);
                        logger.info("copy sku\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)itemBundleReqDtos));
                        itemBundleReqDtos.setAttr(t.getSkuAttrs());
                        this.itemSkuService.modifyBatchItemSku(Lists.newArrayList((Object[])new ItemBundleReqDto[]{itemBundleReqDtos}));
                    }
                }
            });
        } else {
            logger.info("\u5165\u53c2\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public boolean updateOrInsertItemAuth(List<ItemAuthReqDto> dtoList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dtoList)) {
            logger.info("\u65e0\u6570\u636e\u5904\u7406");
            return false;
        }
        this.itemExtDas.updateOrInsertItemAuth(dtoList);
        return true;
    }

    @Override
    public void addProValue(ItemProValue itemProValue) {
        if (Objects.isNull(itemProValue.getPropNameId()) || StringUtils.isEmpty((CharSequence)itemProValue.getName())) {
            logger.info("\u5c5e\u6027\u540did\u6216\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        PropValueEo propValueEo = new PropValueEo();
        propValueEo.setName(itemProValue.getName());
        propValueEo.setPropNameId(itemProValue.getPropNameId());
        List propValueEoList = this.propValueDas.select((BaseEo)propValueEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)propValueEoList)) {
            logger.info("\u5546\u54c1\u5c5e\u6027\u5df2\u7ecf\u5b58\u5728");
            return;
        }
        CubeBeanUtils.copyProperties((Object)propValueEo, (Object)itemProValue, (String[])new String[0]);
        this.propValueDas.insert((BaseEo)propValueEo);
    }

    @Override
    public void syncSapMaterial(SapMaterialDto sapMaterialDto) {
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty((Object)sapMaterialDto.getMatnr()), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-MATNR \u7269\u6599\u7f16\u7801 \u4e3a\u7a7a!");
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty((Object)sapMaterialDto.getMaktx()), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-MAKTX \u7269\u6599\u540d\u79f0 \u4e3a\u7a7a!");
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty((Object)sapMaterialDto.getMtart()), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-MTART \u7269\u6599\u7c7b\u578b\u4e3a\u7a7a!");
        Integer ocsType = this.getOcsMaterialType(sapMaterialDto);
        if (ocsType == null) {
            logger.info("syncDataFormSap->syncDataFormSapProductInfo\u540c\u6b65\u5546\u54c1\u4fe1\u606f,\u7269\u6599\u7c7b\u578b\u975e ZFIN  ZSFG ZGEN ZADM \u8df3\u8fc7\u3002\u3002\u3002\u540c\u6b65\u5546\u54c1\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)sapMaterialDto));
        } else {
            Long itemId = this.sapSaveItem(sapMaterialDto);
            logger.info("sap-ocs \u7269\u6599\u4e3b\u6570\u636e-\u6570\u636e\u5206\u53d1 sapSaveItem  itemId:{},\u4ea7\u54c1\u7f16\u7801:{}", (Object)itemId, (Object)sapMaterialDto.getMatnr());
            this.sapSaveItemExtend(sapMaterialDto, itemId);
            logger.info("sap-ocs \u7269\u6599\u4e3b\u6570\u636e-\u6570\u636e\u5206\u53d1 sapSaveItemExtend itemId:{},\u4ea7\u54c1\u7f16\u7801:{}", (Object)itemId, (Object)sapMaterialDto.getMatnr());
            this.sapSaveItemSku(sapMaterialDto, itemId);
            logger.info("sap-ocs \u7269\u6599\u4e3b\u6570\u636e-\u6570\u636e\u5206\u53d1 sapSaveItemSku itemId:{},\u4ea7\u54c1\u7f16\u7801:{}", (Object)itemId, (Object)sapMaterialDto.getMatnr());
            this.syncMaterialToWms(sapMaterialDto);
        }
    }

    private Integer getOcsMaterialType(SapMaterialDto sapMaterialDto) {
        Integer ocsType = null;
        String materialType = sapMaterialDto.getMtart();
        String productType = sapMaterialDto.getZPrdType();
        if (StringUtils.isNotBlank((CharSequence)materialType)) {
            if ("ZFIN".equals(materialType)) {
                ocsType = StringUtils.isNotBlank((CharSequence)productType) && ("14".equals(productType) || "15".equals(productType)) ? Integer.valueOf(2) : Integer.valueOf(1);
            }
            if ("ZSFG".equals(materialType)) {
                ocsType = 4;
            }
            if ("ZGEN".equals(materialType) || "ZADM".equals(materialType)) {
                ocsType = 3;
            }
        }
        return ocsType;
    }

    private Long sapSaveItem(SapMaterialDto sapMaterialDto) {
        Long itemId;
        List itemRespDtoList = (List)this.itemQueryApi.queryByItemLongCodes((List)Lists.newArrayList((Object[])new String[]{sapMaterialDto.getMatnr()})).getData();
        BrandRespDto brandRespDto = (BrandRespDto)this.brandQueryApi.queryByName(sapMaterialDto.getZBrand()).getData();
        if (CollectionUtils.isEmpty((Collection)itemRespDtoList)) {
            ItemChangeApplyDto changApply = new ItemChangeApplyDto();
            changApply.setItemCode(sapMaterialDto.getMatnr());
            changApply.setLongCode(sapMaterialDto.getMatnr());
            changApply.setOldLongCode(sapMaterialDto.getBismt());
            changApply.setItemName(sapMaterialDto.getMaktx());
            changApply.setDisplayName(changApply.getItemName());
            changApply.setSubType(this.getOcsMaterialType(sapMaterialDto));
            changApply.setDosageForm(SapProductDosageFormEnum.getNameByCode(sapMaterialDto.getZDosForm()));
            if (ObjectUtil.isNotEmpty((Object)sapMaterialDto.getZBrand())) {
                changApply.setBrand(sapMaterialDto.getZBrand());
                if (ObjectUtils.isNotEmpty((Object)brandRespDto)) {
                    changApply.setBrandId(brandRespDto.getId());
                }
            }
            changApply.setDirId(Long.valueOf(1288630386802423099L));
            changApply.setDirName("\u9ed8\u8ba4\u7c7b\u76ee");
            changApply.setType(Integer.valueOf(1));
            changApply.setAttrs("");
            changApply.setSellerId(Long.valueOf(0L));
            changApply.setStatus(Integer.valueOf(2));
            changApply.setCreatePerson("SAP");
            changApply.setUpdatePerson("SAP");
            changApply.setTenantId(Long.valueOf(1L));
            changApply.setInstanceId(Long.valueOf(1L));
            logger.info("sapSaveItem iItemApi.addItem  \u5546\u54c1\u4fe1\u606fchangApply:{}", (Object)JSONUtil.toJsonStr((Object)changApply));
            itemId = this.itemService.addItem(changApply);
        } else {
            ItemReqDto itemReqDto = new ItemReqDto();
            itemId = ((ItemRespDto)itemRespDtoList.get(0)).getId();
            itemReqDto.setId(itemId);
            itemReqDto.setCode(sapMaterialDto.getMatnr());
            itemReqDto.setItemCode(itemReqDto.getCode());
            itemReqDto.setLongCode(itemReqDto.getCode());
            itemReqDto.setCargoCode(itemReqDto.getCode());
            itemReqDto.setName(sapMaterialDto.getMaktx());
            itemReqDto.setOldLongCode(sapMaterialDto.getBismt());
            itemReqDto.setDosageForm(SapProductDosageFormEnum.getNameByCode(sapMaterialDto.getZDosForm()));
            itemReqDto.setSubType(this.getOcsMaterialType(sapMaterialDto));
            if (ObjectUtil.isNotEmpty((Object)sapMaterialDto.getZBrand())) {
                itemReqDto.setBrand(sapMaterialDto.getZBrand());
                if (ObjectUtils.isNotEmpty((Object)brandRespDto)) {
                    itemReqDto.setBrandId(brandRespDto.getId());
                }
            }
            itemReqDto.setUpdatePerson("SAP");
            this.itemService.modifyItem(itemReqDto);
        }
        return itemId;
    }

    private void sapSaveItemExtend(SapMaterialDto sapMaterialDto, Long itemId) {
        ItemExtendReqDto saveItemExtendReqDto = new ItemExtendReqDto();
        ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
        itemExtendReqDto.setItemCodeList(Arrays.asList(sapMaterialDto.getMatnr()));
        List<ItemExtendRespDto> dbItemExtendRespDto = this.itemExtendService.queryParam(itemExtendReqDto);
        if (CollectionUtils.isNotEmpty(dbItemExtendRespDto)) {
            ItemExtendRespDto itemExtend = dbItemExtendRespDto.get(0);
            BeanUtils.copyProperties((Object)itemExtend, (Object)saveItemExtendReqDto);
            saveItemExtendReqDto.setId(itemExtend.getId());
        }
        saveItemExtendReqDto.setItemId(itemId);
        saveItemExtendReqDto.setItemCode(sapMaterialDto.getMatnr());
        saveItemExtendReqDto.setItemName(sapMaterialDto.getMaktx());
        saveItemExtendReqDto.setBarCode(sapMaterialDto.getZBarcode());
        saveItemExtendReqDto.setInstanceId(Long.valueOf(1L));
        saveItemExtendReqDto.setTenantId(Long.valueOf(1L));
        if (saveItemExtendReqDto.getId() != null) {
            this.itemExtendService.modifyItemExtend(saveItemExtendReqDto);
        } else {
            this.itemExtendService.addItemExtend(saveItemExtendReqDto);
        }
    }

    private void sapSaveItemSku(SapMaterialDto sapMaterialDto, Long itemId) {
        ItemBundleReqDto itemBundleReqDto = new ItemBundleReqDto();
        List skuRespDtos = (List)this.iItemSkuQueryApi.queryBySkuCode((List)Lists.newArrayList((Object[])new String[]{sapMaterialDto.getMatnr()})).getData();
        logger.info("SapCenterHandleProductInfoServiceImpl \u67e5\u8be2\u5546\u54c1sku\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)skuRespDtos));
        if (CollectionUtil.isNotEmpty((Collection)skuRespDtos)) {
            ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)skuRespDtos.get(0);
            BeanUtils.copyProperties((Object)itemSkuRespDto, (Object)itemBundleReqDto);
            itemBundleReqDto.setId(itemSkuRespDto.getId());
            itemBundleReqDto.setUpdatePerson("SAP");
        } else {
            itemBundleReqDto.setMinPackage(Integer.valueOf(1));
            itemBundleReqDto.setCreatePerson("SAP");
            itemBundleReqDto.setUpdatePerson("SAP");
            itemBundleReqDto.setTenantId(Long.valueOf(1L));
            itemBundleReqDto.setInstanceId(Long.valueOf(1L));
        }
        itemBundleReqDto.setItemId(itemId);
        itemBundleReqDto.setName(sapMaterialDto.getMaktx());
        itemBundleReqDto.setCode(sapMaterialDto.getMatnr());
        itemBundleReqDto.setCargoCode(itemBundleReqDto.getCode());
        itemBundleReqDto.setBarCode(sapMaterialDto.getZBarcode());
        itemBundleReqDto.setVolume(sapMaterialDto.getZMinVol());
        itemBundleReqDto.setGrossWeight(sapMaterialDto.getZMinWgt());
        String unitCode = sapMaterialDto.getMeins();
        String unitName = sapMaterialDto.getMsehl();
        itemBundleReqDto.setAttr("{\"\u9ed8\u8ba4\":\"" + unitName + "\"}");
        if (StringUtils.isNotBlank((CharSequence)unitCode)) {
            UnitRespDto unitRespDto = this.unitService.queryByCode(unitCode);
            if (unitRespDto == null) {
                UnitReqDto unitReqDto = new UnitReqDto();
                unitReqDto.setCode(unitCode);
                unitReqDto.setName(unitName);
                unitReqDto.setEnglishName(unitName);
                unitReqDto.setType("number");
                unitReqDto.setStatus(Integer.valueOf(1));
                unitReqDto.setCreatePerson("MDM");
                unitReqDto.setTenantId(Long.valueOf(1L));
                unitReqDto.setInstanceId(Long.valueOf(1L));
                Long unitId = this.unitService.addUnit(unitReqDto);
                itemBundleReqDto.setUnit(unitId.toString());
            } else {
                itemBundleReqDto.setUnit(unitRespDto.getId().toString());
            }
        }
        if (CollectionUtil.isEmpty((Collection)skuRespDtos)) {
            logger.info("SapCenterHandleProductInfoServiceImpl =================> \u65b0\u589e\u5546\u54c1sku\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)itemBundleReqDto));
            this.itemSkuService.addBatchItemSku(Lists.newArrayList((Object[])new ItemBundleReqDto[]{itemBundleReqDto}));
        } else {
            logger.info("SapCenterHandleProductInfoServiceImpl \u5546\u54c1sku\u5df2\u5b58\u5728\uff01code:{}", (Object)sapMaterialDto.getMatnr());
            this.itemSkuService.modifyBatchItemSku(Lists.newArrayList((Object[])new ItemBundleReqDto[]{itemBundleReqDto}));
        }
    }

    private void syncMaterialToWms(SapMaterialDto sapMaterialDto) {
        logger.info("\u5e7f\u64ad\u540c\u6b65\u5546\u54c1\u6d88\u606f\uff0c\u4f9b\u5176\u4ed6\u4e2d\u5fc3\u66f4\u65b0\u5546\u54c1\u540d\u79f0\u7b49\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)sapMaterialDto.getMatnr()));
        ArrayList updateItemDtoList = new ArrayList();
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("code", sapMaterialDto.getMatnr());
        item.put("name", sapMaterialDto.getMaktx());
        updateItemDtoList.add(item);
        ArrayList<PcpItemRespDto> itemExtendRespDtoList = new ArrayList<PcpItemRespDto>();
        ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
        itemExtendReqDto.setItemCodeList(Arrays.asList(sapMaterialDto.getMatnr()));
        List<ItemExtendRespDto> csInventorySupplierRespDtos = this.itemExtendService.queryParam(itemExtendReqDto);
        logger.info("SapCenterHandleProductInfoServiceImpl \u540c\u6b65\u5546\u54c1\u67e5\u8be2\u5230\u6570\u636e:{}", (Object)JSON.toJSONString(csInventorySupplierRespDtos));
        for (ItemExtendRespDto dto : csInventorySupplierRespDtos) {
            if (dto.getId() == null) continue;
            PcpItemRespDto pcpItemRespDto = (PcpItemRespDto)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryByPrimaryKey(dto.getId()));
            itemExtendRespDtoList.add(pcpItemRespDto);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemExtendRespDtoList)) {
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)JSON.toJSONString(itemExtendRespDtoList));
            this.commonsMqService.sendSingleMessage("PRODUCT_INFORMATION_RECEIVING_LOG", (Object)messageVo);
        }
    }
}

