/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BranchQueryItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BranchItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.ItemExtListInfo;
import com.dtyunxi.yundt.cube.center.item.api.dto.OrderInfoExportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemAuthExtractCodeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemDetailBatchReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemEffectiveReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtListReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExternalReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemQueryConditionReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemRelationConditionReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemShelfQueryExtReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemTradeInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ShelfExtReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.BdItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.BuydeemItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.CombinationItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemAuthExtractCodeRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemDetailHdRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtListRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemListInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemListRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemShelfListRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemSkuRespExtDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemSplitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemTradeRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.OrderItemPopularRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ShelfListRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirService;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.QueryParamUtils;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemEmpowerService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemExtService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IShelfExtService;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ItemExtQueryApiImpl
implements IItemExtQueryApi {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IItemExtService itemExtService;
    @Resource
    private IShelfExtService shelfExtService;
    @Resource
    private IItemEmpowerService iItemEmpowerService;
    @Resource
    private IDirService dirService;

    public RestResponse<List<ItemRespDto>> queryByIds(List<Long> itemIds) {
        return new RestResponse(this.itemExtService.queryByIds(itemIds));
    }

    public RestResponse<List<ItemSkuRespDto>> queryBySkuId(List<Long> skuIds) {
        return new RestResponse(this.itemExtService.queryBySkuId(skuIds));
    }

    public RestResponse<List<ItemSkuRespDto>> queryBySkuCodeList(List<String> skuCodeList) {
        return new RestResponse(this.itemExtService.queryBySkuCodeList(skuCodeList));
    }

    public RestResponse<List<ItemSkuRespExtDto>> queryBySkuCodes(List<String> skuCodeList) {
        ArrayList list = Lists.newArrayList();
        List<ItemSkuRespDto> itemSkuRespDtos = this.itemExtService.queryBySkuCodeList(skuCodeList);
        CubeBeanUtils.copyCollection((Collection)list, itemSkuRespDtos, ItemSkuRespExtDto.class);
        return new RestResponse((Object)list);
    }

    public RestResponse<ItemShelfRespDto> queryItemShelf(Long skuId, Long shopId, String shelfAddress) {
        return new RestResponse((Object)this.itemExtService.queryItemShelf(skuId, shopId, shelfAddress));
    }

    public RestResponse<PageInfo<ItemRespDto>> queryItemsByPage(ItemQueryConditionReqDto itemQueryConditionReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.itemExtService.queryByPage(itemQueryConditionReqDto, pageNum, pageSize));
    }

    public RestResponse<PageInfo<ItemRespDto>> queryByPage(ItemQueryConditionReqDto itemQueryConditionReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.itemExtService.queryByPage(itemQueryConditionReqDto, pageNum, pageSize));
    }

    public RestResponse<ItemSkuRespDto> querySkuByCode(String code) {
        return new RestResponse((Object)this.itemExtService.querySkuByCode(code));
    }

    public RestResponse<PageInfo<ItemRespDto>> externalByPage(ItemExternalReqDto reqDto) {
        return new RestResponse(this.itemExtService.externalByPage(reqDto));
    }

    public RestResponse<PageInfo<ItemRespDto>> queryItemBySkuCode(String skuCode, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.itemExtService.queryItemBySkuCode(skuCode, pageNum, pageSize));
    }

    public RestResponse<List<ItemRespDto>> exectQueryBySkuCode(List<String> skuCodes) {
        return new RestResponse(this.itemExtService.exectQueryBySkuCode(skuCodes));
    }

    public RestResponse<ItemTradeRespDto> queryById(Long id) {
        return new RestResponse((Object)this.itemExtService.queryById(id));
    }

    public RestResponse<ItemShelfListRespDto> queryShelfPage(ItemShelfQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        this.logger.info("\u67e5\u8be2\u5546\u54c1\u6570\u636equeryShelfPage\uff0c\u5165\u53c2\uff1a{}, ", (Object)JSON.toJSONString((Object)queryReqDto));
        return new RestResponse((Object)this.itemExtService.queryShelfPage(queryReqDto, pageNum, pageSize));
    }

    public RestResponse<BdItemDetailRespDto> getItemDetail(Long itemId) {
        this.logger.info("\u67e5\u8be2\u5546\u54c1\u6570\u636egetItemDetail\uff0c\u5165\u53c2\uff1a{}, ", (Object)JSON.toJSONString((Object)itemId));
        return new RestResponse((Object)this.itemExtService.getItemDetail(itemId));
    }

    public RestResponse<ItemDetailHdRespDto> hdQueryItemDetail(Long itemId) {
        this.logger.info("\u67e5\u8be2\u5546\u54c1\u6570\u636egetItemDetail\uff0c\u5165\u53c2\uff1a{}, ", (Object)JSON.toJSONString((Object)itemId));
        return new RestResponse((Object)this.itemExtService.hdQueryItemDetail(itemId));
    }

    public RestResponse<List<ItemRespDto>> queryItemDetails(List<Long> itemIds) {
        return new RestResponse(this.itemExtService.queryItemDetails(itemIds));
    }

    public RestResponse<PageInfo<ShelfListRespDto>> notOnShelfItemPage(ItemShelfQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        this.logger.info("\u67e5\u8be2\u5546\u54c1\u6570\u636enotOnShelfItemPage\uff0c\u5165\u53c2\uff1a{}, ", (Object)JSON.toJSONString((Object)queryReqDto));
        return new RestResponse(this.itemExtService.notOnShelfItemPage(queryReqDto, pageNum, pageSize));
    }

    public RestResponse<List<ItemExtListInfo>> getItemList(String code) {
        return new RestResponse(this.itemExtService.getItemList(code));
    }

    public RestResponse<List<ItemExtListRespDto>> queryItem(ItemExtListReqDto reqDto) {
        return new RestResponse(this.itemExtService.queryItem(reqDto));
    }

    public RestResponse<List<ItemSkuRespDto>> queryItemSkuByItemId(Long itemId) {
        return new RestResponse(this.itemExtService.queryItemSkuByItemId(itemId));
    }

    public RestResponse<List<ItemListRespDto>> queryItemList(ItemPageReqDto itemPageReqDto) {
        ItemEo itemEo = new ItemEo();
        if (null != itemPageReqDto) {
            itemEo = this.authorizeItemData(itemPageReqDto);
        }
        return new RestResponse(this.itemExtService.queryItemList(itemEo));
    }

    public RestResponse<List<ItemListInfoRespDto>> queryItems(List<String> skuCodes, String shopCode, String channelCode) {
        return new RestResponse(this.itemExtService.queryItems(skuCodes, shopCode, channelCode));
    }

    public RestResponse<List<ItemListInfoRespDto>> queryItemMapping(List<String> channelItemCodes, String shopCode, String channelCode) {
        return new RestResponse(this.itemExtService.queryItemMapping(channelItemCodes, shopCode, channelCode));
    }

    public RestResponse<ItemSplitRespDto> queryItemSplit(List<String> channelItemCodes) {
        return new RestResponse((Object)this.itemExtService.queryItemSplit(channelItemCodes));
    }

    public RestResponse<List<ItemListInfoRespDto>> getMiddleItemListByItemCode(List<String> itemCodes) {
        return new RestResponse(this.itemExtService.getMiddleItemListByItemCode(itemCodes));
    }

    public RestResponse<List<ItemListInfoRespDto>> getItemListSimpleByItemCode(List<String> itemCodes) {
        return new RestResponse(this.itemExtService.getItemListSimpleByItemCode(itemCodes));
    }

    public RestResponse<ItemExtDetailRespDto> queryItemDetailById(Long itemId, Long customerId, String shelfAddress) {
        return new RestResponse((Object)this.itemExtService.queryItemDetailById(itemId, customerId, shelfAddress));
    }

    private ItemEo authorizeItemData(ItemPageReqDto itemPageReqDto) {
        List<Long> itemIds;
        ItemEo itemEo = ItemEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)itemPageReqDto, (BaseEo)itemEo);
        QueryParamUtils.columnLike((BaseEo)itemEo, "name", itemPageReqDto.getName());
        QueryParamUtils.columnLike((BaseEo)itemEo, "code", itemPageReqDto.getCode());
        ArrayList<SqlFilter> sqlFilterList = itemEo.getSqlFilters();
        if (sqlFilterList == null) {
            sqlFilterList = new ArrayList<SqlFilter>();
        }
        if (StringUtils.isNotBlank((CharSequence)itemPageReqDto.getStartTime())) {
            sqlFilterList.add(SqlFilter.ge((String)"update_time", (Object)itemPageReqDto.getStartTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)itemPageReqDto.getEndTime())) {
            sqlFilterList.add(SqlFilter.lt((String)"update_time", (Object)itemPageReqDto.getEndTime()));
        }
        if (itemPageReqDto.getCustomerId() != null && itemPageReqDto.getCustomerId() > 0L && !CollectionUtils.isEmpty(itemIds = this.iItemEmpowerService.queryItemsByCustomer(itemPageReqDto.getCustomerId()))) {
            itemPageReqDto.setItemIds(itemIds);
        }
        if (!CollectionUtils.isEmpty((Collection)itemPageReqDto.getItemIds())) {
            itemEo.setId((Long)null);
            sqlFilterList.add(SqlFilter.in((String)"id", (Object)itemPageReqDto.getItemIds()));
        }
        if (itemPageReqDto.getStatus() == null) {
            ArrayList<Integer> statusList = new ArrayList<Integer>();
            statusList.add(ItemStatus.ITEM_OFFSHELF.getStatus());
            statusList.add(ItemStatus.ITEM_ONSHELF.getStatus());
            itemPageReqDto.setStatusList(statusList);
        }
        if (!CollectionUtils.isEmpty((Collection)itemPageReqDto.getStatusList())) {
            itemEo.setStatus((Integer)null);
            sqlFilterList.add(SqlFilter.in((String)"status", (Object)itemPageReqDto.getStatusList()));
        }
        if (!CollectionUtils.isEmpty((Collection)itemPageReqDto.getCodeList())) {
            itemEo.setCode(null);
            sqlFilterList.add(SqlFilter.in((String)"code", (Object)itemPageReqDto.getCodeList()));
        }
        List<Object> dirIdList = new ArrayList();
        if (Objects.nonNull(itemPageReqDto.getDirId())) {
            dirIdList = this.dirService.getChildDirIdList(Lists.newArrayList((Object[])new Long[]{itemPageReqDto.getDirId()}), null, null);
        }
        if (!CollectionUtils.isEmpty(dirIdList)) {
            itemEo.setDirId((Long)null);
            sqlFilterList.add(SqlFilter.in((String)"dirId", dirIdList));
        }
        itemEo.setSqlFilters(sqlFilterList);
        return itemEo;
    }

    public RestResponse<PageInfo<ItemTradeInfoRespDto>> queryTradeItem(ItemQueryConditionReqDto itemQueryConditionReqDto) {
        return new RestResponse(this.itemExtService.queryTradeItem(itemQueryConditionReqDto));
    }

    public RestResponse<PageInfo<ItemRespDto>> queryItemPage(ItemRelationConditionReqDto itemQueryConditionReqDto) {
        return new RestResponse(this.itemExtService.queryItemPage(itemQueryConditionReqDto));
    }

    public RestResponse<PageInfo<ItemRespDto>> queryItemTradeShopping(ItemQueryConditionReqDto itemQueryConditionReqDto) {
        return new RestResponse(this.itemExtService.queryItemTradeShopping(itemQueryConditionReqDto));
    }

    public RestResponse<String> getItemCreateTime() {
        return new RestResponse((Object)this.itemExtService.getItemCreateTime());
    }

    public RestResponse<List<ItemMediasRespDto>> queryMediasByItemId(Long itemId) {
        return new RestResponse(this.itemExtService.queryMediasByItemId(itemId));
    }

    public RestResponse<List<ItemMediasRespDto>> queryMedias(List<Long> itemIds, Integer fileType) {
        return new RestResponse(this.itemExtService.queryMedias(itemIds, fileType));
    }

    public RestResponse<List<ItemRespDto>> queryItemByDirIds(String dirIds) {
        return new RestResponse(this.itemExtService.queryItemByDirIds(dirIds));
    }

    public RestResponse<List<ItemRespDto>> queryItemByDirIdsWithPost(String dirIds) {
        return new RestResponse(this.itemExtService.queryItemByDirIds(dirIds));
    }

    public RestResponse<PageInfo<ShelfListRespDto>> queryItemByKeywords(ItemShelfQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        this.logger.info("queryItemByKeywords\uff0c\u5165\u53c2\uff1a{}, ", (Object)JSON.toJSONString((Object)queryReqDto));
        PageInfo<ShelfListRespDto> pageInfo = this.itemExtService.queryItemByKeywords(queryReqDto, pageNum, pageSize);
        return new RestResponse(pageInfo);
    }

    public RestResponse<BranchItemRespDto> branchQueryItem(BranchQueryItemReqDto branchQueryItemReq) {
        return new RestResponse((Object)this.itemExtService.branchQueryItem(branchQueryItemReq));
    }

    public RestResponse<List<ItemStorageRespDto>> queryItemStorageByItemIds(@NotNull List<Long> itemIds) {
        return new RestResponse(this.itemExtService.queryItemStorageByItemIds(itemIds));
    }

    public RestResponse<List<CombinationItemRespDto>> queryCombinationItem(List<String> itemCodes) {
        return new RestResponse(this.itemExtService.queryCombinationItem(itemCodes));
    }

    public RestResponse<List<OrderInfoExportDto>> analysisExcelData(String url) {
        return new RestResponse(EasyPoiExportUtil.parseImportFile(url, 1, 1, 1, 2, OrderInfoExportDto.class));
    }

    public RestResponse<List<OrderItemPopularRespDto>> getPopularItem(ItemEffectiveReqDto itemEffectiveReqDto) {
        return new RestResponse(this.itemExtService.getPopularItem(itemEffectiveReqDto));
    }

    public RestResponse<BuydeemItemDetailRespDto> getBuydeemItemDetailByItemCode(String itemCode) {
        return new RestResponse((Object)this.itemExtService.getBuydeemItemDetailByItemCode(itemCode));
    }

    public RestResponse<List<BuydeemItemDetailRespDto>> batchQuerBuydeemItemDetail(Integer size) {
        return new RestResponse(this.itemExtService.batchQuerBuydeemItemDetail(size));
    }

    public RestResponse<List<ItemMediasRespDto>> batchQueryItemMedias(List<Long> itemIds) {
        return new RestResponse(this.itemExtService.batchQueryItemMedias(itemIds));
    }

    public RestResponse<List<ItemMediasRespDto>> batchQueryItemImage(List<String> itemCodes) {
        return new RestResponse(this.itemExtService.batchQueryItemImage(itemCodes));
    }

    public RestResponse<List<Map<String, ItemMediasRespDto>>> queryItemImageList(List<String> itemCodes) {
        return new RestResponse(this.itemExtService.queryItemImageList(itemCodes));
    }

    public RestResponse<List<ItemRespDto>> batchQueryItem(List<String> itemCodes) {
        return new RestResponse(this.itemExtService.batchQueryItem(itemCodes));
    }

    public RestResponse<List<ItemRespDto>> batchQueryShelfItem(List<Long> skuIds, Long shopId, String shelfAddress) {
        return new RestResponse(this.itemExtService.batchQueryShelfItem(skuIds, shopId, shelfAddress));
    }

    public RestResponse<List<ItemSkuRespDto>> queryByItemIds(List<Long> itemIds) {
        return new RestResponse(this.itemExtService.queryByItemIds(itemIds));
    }

    public RestResponse<List<String>> getItemCodes() {
        return new RestResponse(this.itemExtService.getItemCodes());
    }

    public RestResponse<PageInfo<ItemRespDto>> queryItemControlByPage(ItemQueryConditionReqDto itemQueryConditionReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.itemExtService.queryItemControlByPage(itemQueryConditionReqDto, pageNum, pageSize));
    }

    public RestResponse<List<String>> getItemCodesByControlStatus(String itemControlStatus) {
        return new RestResponse(this.itemExtService.getItemCodesByControlStatus(itemControlStatus));
    }

    public RestResponse<ItemShelfListRespDto> queryShelfPage(ItemShelfQueryReqDto queryReqDto) {
        this.logger.info("\u67e5\u8be2\u5546\u54c1\u6570\u636equeryShelfPage\uff0c\u5165\u53c2\uff1a{}, ", (Object)JSON.toJSONString((Object)queryReqDto));
        return new RestResponse((Object)this.itemExtService.queryShelfPage(queryReqDto, queryReqDto.getPageNum(), queryReqDto.getPageSize()));
    }

    public RestResponse<List<ItemRespDto>> queryAllItems() {
        return new RestResponse(this.itemExtService.queryAllItems());
    }

    public RestResponse<List<ItemRespDto>> queryByCodes(List<String> codes) {
        return new RestResponse(this.itemExtService.queryByCodes(codes));
    }

    public RestResponse<List<ItemShelfRespDto>> queryItemShelf(ShelfExtReqDto shelfExtReqDto) {
        return new RestResponse(this.itemExtService.queryItemShelf(shelfExtReqDto));
    }

    public RestResponse<List<ItemDetailRespDto>> queryItemDetailByItemIds(ItemDetailBatchReqDto itemDetailBatchReqDto) {
        return new RestResponse(this.itemExtService.queryItemDetailByItemIds(itemDetailBatchReqDto));
    }

    public RestResponse<List<ItemAuthExtractCodeRespDto>> queryExaractCodeByShelf(ItemAuthExtractCodeReqDto reqDto) {
        return new RestResponse(this.itemExtService.queryExaractCodeByShelf(reqDto));
    }

    public RestResponse<PageInfo<ItemShelfQueryRespDto>> queryShelfItemByPageByPost(ItemShelfQueryExtReqDto itemShelfQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo<ItemShelfQueryRespDto> pageInfo = this.shelfExtService.getItemShelfPage(itemShelfQueryReqDto, pageNum, pageSize);
        return new RestResponse(pageInfo);
    }
}

