/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.apiimpl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemTagApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.TagReqDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemTagService;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.TagEo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="itemTagApi")
public class ItemTagApiImpl
implements IItemTagApi {
    @Resource
    private IItemTagService itemTagService;

    public RestResponse<Void> addTagBatch(List<TagReqDto> requestTagDtos) {
        ArrayList<TagEo> tagEoList = new ArrayList<TagEo>();
        if (requestTagDtos.size() != 0) {
            DtoHelper.dtoList2EoList(requestTagDtos, tagEoList, TagEo.class);
        }
        if (this.itemTagService.addTagBatch(tagEoList) == 0) {
            return RestResponse.FAIL;
        }
        return RestResponse.VOID;
    }

    public RestResponse<Long> addTag(TagReqDto requestTagDto) {
        TagEo tagEo = TagEo.newInstance((Map)requestTagDto.getExtFields());
        if (null != requestTagDto) {
            DtoHelper.dto2Eo((BaseVo)requestTagDto, (BaseEo)tagEo);
        }
        return new RestResponse((Object)this.itemTagService.addTag(tagEo));
    }

    public RestResponse<Long> modifyTag(TagReqDto requestTag) {
        TagEo tagEo = TagEo.newInstance((Map)requestTag.getExtFields());
        if (null != requestTag) {
            DtoHelper.dto2Eo((BaseVo)requestTag, (BaseEo)tagEo);
        }
        this.itemTagService.modifyTag(tagEo);
        return new RestResponse((Object)tagEo.getId());
    }

    public RestResponse<Void> modifyTagStatus(Long id, Integer status) {
        TagEo tagEo = TagEo.newInstance();
        tagEo.setId(id);
        tagEo.setStatus(status);
        this.itemTagService.modifyTag(tagEo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeTag(String ids) {
        this.itemTagService.removeByIds(ids);
        return RestResponse.VOID;
    }
}

