/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.mq.processor;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.item.api.ISellerSkuPriceApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ProductPriceRespDto;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="ITEM_UPDATE_PRICE_TOPIC", tag="ITEM_UPDATE_PRICE_TAG")
public class ItemUpdatePriceProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(ItemUpdatePriceProcessor.class);
    @Resource(name="sellerSkuPriceApi")
    private ISellerSkuPriceApi sellerSkuPriceApi;
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public MessageResponse process(MessageVo message) {
        String reqId = UUID.randomUUID().toString().replace("-", "");
        MDC.put((String)"yes.req.requestId", (String)reqId);
        this.executorService.execute(new Thread(() -> {
            MDC.put((String)"yes.req.requestId", (String)reqId);
            logger.info("\u63a5\u6536\u5230\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message));
            if (message.getData() == null) {
                logger.info("\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u6d88\u606f\u53c2\u6570\u5f02\u5e38");
                return;
            }
            ProductPriceRespDto productPriceRespDto = (ProductPriceRespDto)message.getData();
            this.sellerSkuPriceApi.updatePriceExt(productPriceRespDto);
        }));
        return MessageResponse.SUCCESS;
    }
}

