/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.dg.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.constants.dg.ItemDgConstants;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.dg.ItemExchangeUnitDgReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.dg.ItemSkuQueryDgReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.dg.ItemDgDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.dg.ItemExchangeUnitDgRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.dg.ItemPriceDgRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.dg.ItemRoundDgRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.dg.ItemSkuDgRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.dg.ItemUnitConversionDgDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemMediasService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemExtendService;
import com.dtyunxi.yundt.cube.center.item.biz.service.dg.IItemDgService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.UnitDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtendDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemExtendEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import icu.mhb.mybatisplus.plugln.core.JoinLambdaWrapper;
import icu.mhb.mybatisplus.plugln.core.JoinWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class IItemDgServiceImpl
implements IItemDgService {
    private static final Logger logger = LoggerFactory.getLogger(IItemDgServiceImpl.class);
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemPriceDas itemPriceDas;
    @Resource
    private ItemDas itemDas;
    @Resource
    private UnitDas unitDas;
    @Resource
    private ItemExtendDas itemExtendDas;
    @Resource
    private IItemMediasService itemMediasService;
    @Resource(name="${project.domain.prefix:tcbj}ItemExtendService")
    private IItemExtendService iItemExtendService;
    @Value(value="${project.item.unit.conversion:close}")
    private String unitConversion;

    @Override
    public PageInfo<ItemSkuDgRespDto> getItemShelfPage(ItemSkuQueryDgReqDto reqDto, Integer pageNum, Integer pageSize) {
        PageInfo<PcpItemRespDto> pcpPageInfo = this.queryExtendByPage(reqDto, pageNum, pageSize);
        ArrayList<ItemSkuDgRespDto> list = new ArrayList<ItemSkuDgRespDto>();
        PageInfo dtoPageInfo = new PageInfo(list);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, pcpPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        this.getSkuDgRespDto(pcpPageInfo.getList(), list);
        this.getItemSkuDgRespDto(list);
        return dtoPageInfo;
    }

    @Override
    public List<ItemSkuDgRespDto> querySkuList(ItemSkuQueryDgReqDto reqDto) {
        List<PcpItemRespDto> pcpItemRespDtos = this.queryExtendByList(reqDto);
        ArrayList<ItemSkuDgRespDto> list = new ArrayList<ItemSkuDgRespDto>();
        this.getSkuDgRespDto(pcpItemRespDtos, list);
        this.getItemSkuDgRespDto(list);
        return list;
    }

    @Override
    public ItemExchangeUnitDgRespDto exchangeUnit(ItemExchangeUnitDgReqDto reqDto) {
        ItemExtendEo extendEo = (ItemExtendEo)((ExtQueryChainWrapper)this.itemExtendDas.filter().eq((Object)"item_code", (Object)reqDto.getSkuCode())).one();
        AssertUtils.notNull((Object)extendEo, (String)"\u5546\u54c1\u6269\u5c55\u4fe1\u606f\u4e0d\u5b58\u5728");
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(extendEo.getItemId());
        AssertUtils.notNull((Object)itemEo, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map<String, ItemUnitConversionDgDto> unitMap = new HashMap<String, ItemUnitConversionDgDto>();
        if ("close".equals(this.unitConversion)) {
            unitMap = this.getDefaultUnitList(reqDto);
        }
        return this.getexchangeUnitResp(reqDto, unitMap, itemEo, extendEo);
    }

    @Override
    public List<ItemExchangeUnitDgRespDto> batchExchangeUnit(List<ItemExchangeUnitDgReqDto> reqDtos) {
        ArrayList<ItemExchangeUnitDgRespDto> unitDgRespDtos = new ArrayList<ItemExchangeUnitDgRespDto>();
        List skuCodes = reqDtos.stream().map(ItemExchangeUnitDgReqDto::getSkuCode).collect(Collectors.toList());
        List extendEos = ((ExtQueryChainWrapper)this.itemExtendDas.filter().in((Object)"item_code", skuCodes)).list();
        ArrayList<Long> itemIds = new ArrayList<Long>();
        HashMap<String, ItemExtendEo> extendEoMap = new HashMap<String, ItemExtendEo>();
        for (ItemExtendEo extendEo : extendEos) {
            extendEoMap.put(extendEo.getItemCode(), extendEo);
            itemIds.add(extendEo.getItemId());
        }
        List itemEos = ((ExtQueryChainWrapper)this.itemDas.filter().in((Object)"id", itemIds)).list();
        Map itemEoMap = itemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (key1, key2) -> key2));
        for (ItemExchangeUnitDgReqDto reqDto : reqDtos) {
            HashMap<String, ItemUnitConversionDgDto> unitMap = new HashMap();
            if ("close".equals(this.unitConversion)) {
                unitMap = this.getDefaultUnitList(reqDto);
            }
            ItemExtendEo itemExtendEo = Objects.nonNull(extendEoMap.get(reqDto.getSkuCode())) ? (ItemExtendEo)extendEoMap.get(reqDto.getSkuCode()) : new ItemExtendEo();
            ItemEo itemEo = Objects.nonNull(itemEoMap.get(itemExtendEo.getItemId())) ? (ItemEo)itemEoMap.get(itemExtendEo.getItemId()) : new ItemEo();
            itemExtendEo.setItemCode(reqDto.getSkuCode());
            unitDgRespDtos.add(this.getexchangeUnitResp(reqDto, unitMap, itemEo, itemExtendEo));
        }
        return unitDgRespDtos;
    }

    @Override
    public List<ItemRoundDgRespDto> batchRound(List<ItemExchangeUnitDgReqDto> reqDtos) {
        ArrayList<ItemRoundDgRespDto> roundDgRespDtos = new ArrayList<ItemRoundDgRespDto>();
        List skuCodes = reqDtos.stream().map(ItemExchangeUnitDgReqDto::getSkuCode).collect(Collectors.toList());
        List extendEos = ((ExtQueryChainWrapper)this.itemExtendDas.filter().in((Object)"item_code", skuCodes)).list();
        AssertUtils.notEmpty((Collection)extendEos, (String)"\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728");
        ArrayList<Long> itemIds = new ArrayList<Long>();
        HashMap<String, ItemExtendEo> itemExtendEoMap = new HashMap<String, ItemExtendEo>();
        for (ItemExtendEo itemExtendEo : extendEos) {
            itemExtendEoMap.put(itemExtendEo.getItemCode(), itemExtendEo);
            itemIds.add(itemExtendEo.getItemId());
        }
        List itemEos = ((ExtQueryChainWrapper)this.itemDas.filter().in((Object)"id", itemIds)).list();
        Map itemEoMap = itemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (key1, key2) -> key2));
        for (ItemExchangeUnitDgReqDto reqDto : reqDtos) {
            HashMap<String, ItemUnitConversionDgDto> unitMap = new HashMap();
            if ("close".equals(this.unitConversion)) {
                unitMap = this.getDefaultUnitList(reqDto);
            }
            ItemExtendEo itemExtendEo = (ItemExtendEo)itemExtendEoMap.get(reqDto.getSkuCode());
            AssertUtils.notNull((Object)itemExtendEo, (String)(reqDto.getSkuCode() + "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728"));
            ItemEo itemEo = (ItemEo)itemEoMap.get(itemExtendEo.getItemId());
            roundDgRespDtos.add(this.getExtendResult(reqDto, unitMap, itemEo, itemExtendEo));
        }
        return roundDgRespDtos;
    }

    private ItemRoundDgRespDto getExtendResult(ItemExchangeUnitDgReqDto reqDto, Map<String, ItemUnitConversionDgDto> unitMap, ItemEo itemEo, ItemExtendEo extendEo) {
        ItemRoundDgRespDto roundDgRespDto = new ItemRoundDgRespDto();
        ItemUnitConversionDgDto unitConversionDgDto = unitMap.get(reqDto.getCurrentUnit());
        AssertUtils.notNull((Object)unitConversionDgDto, (String)(reqDto.getSkuCode() + "\u6362\u7b97\u5355\u4f4d\u4fe1\u606f\u4e0d\u5b58\u5728"));
        Long bigBox = Objects.nonNull(extendEo.getBigBox()) ? extendEo.getBigBox() : 0L;
        Long itemZhTrayNum = Objects.nonNull(extendEo.getZhTrayNum()) ? extendEo.getZhTrayNum() : 0L;
        Long zhTrayNumRatio = bigBox * itemZhTrayNum;
        Integer baseNum = Objects.nonNull(unitConversionDgDto.getConversionNum()) ? reqDto.getCurrentNum() * unitConversionDgDto.getConversionNum() : 0;
        Long bigBoxNum = bigBox > 0L ? baseNum.longValue() / bigBox : 0L;
        Long zhTrayNum = zhTrayNumRatio > 0L ? baseNum.longValue() / zhTrayNumRatio : 0L;
        roundDgRespDto.setCode(extendEo.getItemCode());
        roundDgRespDto.setName(itemEo.getName());
        roundDgRespDto.setItemId(itemEo.getId());
        roundDgRespDto.setItemCode(extendEo.getItemCode());
        roundDgRespDto.setBigBoxNum(Long.valueOf(bigBoxNum * bigBox));
        roundDgRespDto.setZhTrayNum(Long.valueOf(zhTrayNum * zhTrayNumRatio));
        return roundDgRespDto;
    }

    private ItemExchangeUnitDgRespDto getexchangeUnitResp(ItemExchangeUnitDgReqDto reqDto, Map<String, ItemUnitConversionDgDto> unitMap, ItemEo itemEo, ItemExtendEo extendEo) {
        ItemExchangeUnitDgRespDto exchangeUnitDgRespDto = new ItemExchangeUnitDgRespDto();
        ItemUnitConversionDgDto unitConversionDgDto = unitMap.get(reqDto.getCurrentUnit());
        AssertUtils.notNull((Object)unitConversionDgDto, (String)(reqDto.getSkuCode() + "\u6362\u7b97\u5355\u4f4d\u4fe1\u606f\u4e0d\u5b58\u5728"));
        Integer baseNum = Objects.nonNull(unitConversionDgDto.getConversionNum()) ? reqDto.getCurrentNum() * unitConversionDgDto.getConversionNum() : 0;
        BigDecimal bigDecimalBaseNum = new BigDecimal(baseNum);
        BigDecimal costPrice = Objects.nonNull(extendEo.getRecommendPrice()) ? extendEo.getRecommendPrice() : BigDecimal.ZERO;
        BigDecimal volume = Objects.nonNull(extendEo.getVolume()) ? extendEo.getVolume() : BigDecimal.ZERO;
        BigDecimal grossWeight = Objects.nonNull(extendEo.getGrossWeight()) ? extendEo.getGrossWeight() : BigDecimal.ZERO;
        BigDecimal netWeight = Objects.nonNull(extendEo.getNetWeight()) ? extendEo.getNetWeight() : BigDecimal.ZERO;
        costPrice = bigDecimalBaseNum.multiply(costPrice);
        volume = bigDecimalBaseNum.multiply(volume);
        grossWeight = bigDecimalBaseNum.multiply(grossWeight);
        netWeight = bigDecimalBaseNum.multiply(netWeight);
        exchangeUnitDgRespDto.setCode(extendEo.getItemCode());
        exchangeUnitDgRespDto.setCurrentUnit(reqDto.getCurrentUnit());
        exchangeUnitDgRespDto.setCurrentNum(reqDto.getCurrentNum());
        exchangeUnitDgRespDto.setName(itemEo.getName());
        exchangeUnitDgRespDto.setItemId(itemEo.getId());
        exchangeUnitDgRespDto.setItemCode(itemEo.getCode());
        exchangeUnitDgRespDto.setItemName(itemEo.getName());
        exchangeUnitDgRespDto.setDisplayName(itemEo.getDisplayName());
        exchangeUnitDgRespDto.setCostPrice(costPrice);
        exchangeUnitDgRespDto.setGrossWeight(grossWeight);
        exchangeUnitDgRespDto.setGrossWeightUnit(extendEo.getGrossWeightUnit());
        exchangeUnitDgRespDto.setNetWeight(netWeight);
        exchangeUnitDgRespDto.setNetWeightUnit(extendEo.getNetWeightUnit());
        exchangeUnitDgRespDto.setVolume(volume);
        exchangeUnitDgRespDto.setVolumeUnit(extendEo.getVolumnUnit());
        exchangeUnitDgRespDto.setBigBox(extendEo.getBigBox());
        exchangeUnitDgRespDto.setZhTrayNum(extendEo.getZhTrayNum());
        return exchangeUnitDgRespDto;
    }

    private Map<String, ItemUnitConversionDgDto> getDefaultUnitList(ItemExchangeUnitDgReqDto reqDto) {
        HashMap<String, ItemUnitConversionDgDto> unitMap = new HashMap<String, ItemUnitConversionDgDto>();
        ItemUnitConversionDgDto currentUnit = new ItemUnitConversionDgDto();
        currentUnit.setConversionUnit(reqDto.getCurrentUnit());
        currentUnit.setConversionNum(Integer.valueOf(1));
        unitMap.put(currentUnit.getConversionUnit(), currentUnit);
        return unitMap;
    }

    private ItemSkuEo getQueryParam(ItemSkuQueryDgReqDto reqDto) {
        ItemSkuEo itemSkuEo = new ItemSkuEo();
        if (Objects.nonNull(reqDto)) {
            ArrayList sqlFilters = com.google.common.collect.Lists.newArrayList();
            if (CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
                sqlFilters.add(SqlFilter.in((String)"code", (Object)reqDto.getSkuCodeList()));
            }
            if (CollectionUtil.isNotEmpty((Collection)reqDto.getSkuIds())) {
                sqlFilters.add(SqlFilter.in((String)"id", (Object)reqDto.getSkuIds()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqDto.getName())) {
                sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + StringUtils.trim((String)reqDto.getName()) + "%")));
            }
            itemSkuEo.setSqlFilters((List)sqlFilters);
        }
        itemSkuEo.setDr(0);
        return itemSkuEo;
    }

    private void getItemSkuDgRespDto(List<ItemSkuDgRespDto> list) {
        if (CollUtil.isNotEmpty(list)) {
            List<Long> itemIds = list.stream().map(ItemSkuDgRespDto::getItemId).distinct().collect(Collectors.toList());
            Map<Long, String> mainPicMap = this.itemMediasService.getMainPicByItemIds(itemIds);
            for (ItemSkuDgRespDto item : list) {
                if (!mainPicMap.containsKey(item.getItemId())) continue;
                item.setItemPic(mainPicMap.get(item.getItemId()));
            }
            this.getItemInfos(list, itemIds);
            this.getItemUnitConversions(list);
        }
    }

    private void getSkuDgRespDto(List<PcpItemRespDto> pcpItemRespDtos, List<ItemSkuDgRespDto> list) {
        if (CollectionUtil.isEmpty(pcpItemRespDtos)) {
            return;
        }
        for (PcpItemRespDto pcpItemRespDto : pcpItemRespDtos) {
            ItemSkuDgRespDto respDto = new ItemSkuDgRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)pcpItemRespDto, (String[])new String[0]);
            respDto.setVolumeUnit(pcpItemRespDto.getVolumnUnit());
            respDto.setCode(pcpItemRespDto.getItemCode());
            respDto.setName(pcpItemRespDto.getName());
            respDto.setBasicUnit(pcpItemRespDto.getUnitId());
            respDto.setItemId(pcpItemRespDto.getItemId());
            respDto.setCostPrice(pcpItemRespDto.getRecommendPrice());
            respDto.setPrice(pcpItemRespDto.getRecommendPrice());
            list.add(respDto);
        }
    }

    private void getItemInfos(List<ItemSkuDgRespDto> list, List<Long> itemIds) {
        if (CollectionUtil.isNotEmpty(itemIds)) {
            ItemDgDto itemDgDto;
            List itemEos = ((ExtQueryChainWrapper)this.itemDas.filter().in((Object)"id", itemIds)).list();
            if (CollectionUtil.isEmpty((Collection)itemEos)) {
                return;
            }
            HashMap<Long, ItemDgDto> itemMap = new HashMap<Long, ItemDgDto>();
            for (ItemEo itemEo : itemEos) {
                itemDgDto = new ItemDgDto();
                DtoHelper.eo2Dto((BaseEo)itemEo, (BaseVo)itemDgDto);
                itemMap.put(itemDgDto.getId(), itemDgDto);
            }
            for (ItemSkuDgRespDto itemSkuDgRespDto : list) {
                itemDgDto = (ItemDgDto)itemMap.get(itemSkuDgRespDto.getItemId());
                if (Objects.nonNull(itemDgDto)) {
                    itemDgDto.setCode(itemDgDto.getLongCode());
                }
                itemSkuDgRespDto.setItemDgDto(itemDgDto);
            }
        }
    }

    private void getItemPrice(List<ItemSkuDgRespDto> list) {
        if (CollectionUtil.isNotEmpty(list)) {
            List skuIds = list.stream().map(ItemSkuDgRespDto::getId).distinct().collect(Collectors.toList());
            List priceEos = ((ExtQueryChainWrapper)this.itemPriceDas.filter().in((Object)"sku_id", skuIds)).list();
            if (CollectionUtil.isEmpty((Collection)priceEos)) {
                return;
            }
            Map<Long, List<ItemPriceEo>> priceMap = priceEos.stream().collect(Collectors.groupingBy(StdItemPriceEo::getSkuId));
            for (ItemSkuDgRespDto itemSkuDgRespDto : list) {
                ArrayList itemPriceList = new ArrayList();
                List<ItemPriceEo> itemPriceEos = priceMap.get(itemSkuDgRespDto.getId());
                DtoHelper.eoList2DtoList(itemPriceEos, itemPriceList, ItemPriceDgRespDto.class);
                itemSkuDgRespDto.setItemPriceList(itemPriceList);
            }
        }
    }

    private void getItemUnitConversions(List<ItemSkuDgRespDto> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        if ("close".equals(this.unitConversion)) {
            List<ItemUnitConversionDgDto> defaultItemUnitConversions = this.getDefaultItemUnitConversions();
            for (ItemSkuDgRespDto itemSkuDgRespDto : list) {
                itemSkuDgRespDto.setItemUnitConversionDgDtos(defaultItemUnitConversions);
            }
        }
    }

    private List<ItemUnitConversionDgDto> getDefaultItemUnitConversions() {
        ArrayList itemUnitConversionDgDtos = com.google.common.collect.Lists.newArrayList();
        ItemUnitConversionDgDto unitConversionDgDto = new ItemUnitConversionDgDto();
        unitConversionDgDto.setConversionNum(ItemDgConstants.ITEM_UNIT_CONVERSION_DEFAULT_NUM);
        unitConversionDgDto.setConversionUnit("\u9ed8\u8ba4\u5355\u4f4d");
        itemUnitConversionDgDtos.add(unitConversionDgDto);
        return itemUnitConversionDgDtos;
    }

    private PageInfo<PcpItemRespDto> queryExtendByPage(ItemSkuQueryDgReqDto reqDto, Integer pageNum, Integer pageSize) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)reqDto, (String[])new String[]{"pageNum", "pageSize"}));
        if (Objects.isNull(pageNum) || Objects.isNull(pageSize)) {
            throw new BizException("\u5206\u9875\u9875\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JoinLambdaWrapper wrapper = ((JoinWrapper)((JoinWrapper)((JoinWrapper)((JoinWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)new JoinLambdaWrapper(ItemExtendEo.class).like(StringUtils.isNotBlank((CharSequence)reqDto.getSkuCode()), ItemExtendEo::getItemCode, (Object)("%" + reqDto.getSkuCode() + "%"))).in(CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodeList()), ItemExtendEo::getItemCode, (Collection)reqDto.getSkuCodeList())).eq(BaseEo::getDr, (Object)0)).selectAll()).orderByDesc(BaseEo::getId)).leftJoin(ItemEo.class, StdItemEo::getLongCode, ItemExtendEo::getItemCode).like(StringUtils.isNotBlank((CharSequence)reqDto.getName()), StdItemEo::getName, (Object)("%" + reqDto.getName() + "%"))).eq(BaseEo::getDr, (Object)0)).selectAs(a -> a.add(StdItemEo::getSubType, "itemType").add(StdItemEo::getStatus, "itemStatus").add(StdItemEo::getName, "name").add(BaseEo::getId, "itemId"))).end().leftJoin(ItemSkuEo.class, StdItemSkuEo::getCode, ItemExtendEo::getItemCode).selectAs(a -> a.add(StdItemSkuEo::getBarCode, "barCode"))).end();
        IPage page = this.iItemExtendService.joinPage((IPage)new Page((long)pageNum.intValue(), (long)pageSize.intValue()), (Wrapper)wrapper, PcpItemRespDto.class);
        return this.getPcpItemRespDtoPageInfo(pageNum, pageSize, (IPage<PcpItemRespDto>)page);
    }

    private List<PcpItemRespDto> queryExtendByList(ItemSkuQueryDgReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u53ef\u4e3a\u7a7a!");
        JoinLambdaWrapper wrapper = ((JoinWrapper)((JoinWrapper)((JoinWrapper)((JoinWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)new JoinLambdaWrapper(ItemExtendEo.class).like(StringUtils.isNotBlank((CharSequence)reqDto.getSkuCode()), ItemExtendEo::getItemCode, (Object)("%" + reqDto.getSkuCode() + "%"))).in(CollectionUtil.isNotEmpty((Collection)reqDto.getSkuCodeList()), ItemExtendEo::getItemCode, (Collection)reqDto.getSkuCodeList())).eq(BaseEo::getDr, (Object)0)).selectAll()).orderByDesc(BaseEo::getId)).leftJoin(ItemEo.class, StdItemEo::getLongCode, ItemExtendEo::getItemCode).like(StringUtils.isNotBlank((CharSequence)reqDto.getName()), StdItemEo::getName, (Object)("%" + reqDto.getName() + "%"))).eq(BaseEo::getDr, (Object)0)).selectAs(a -> a.add(StdItemEo::getSubType, "itemType").add(StdItemEo::getStatus, "itemStatus").add(StdItemEo::getName, "name").add(BaseEo::getId, "itemId"))).end().leftJoin(ItemSkuEo.class, StdItemSkuEo::getCode, ItemExtendEo::getItemCode).selectAs(a -> a.add(StdItemSkuEo::getBarCode, "barCode"))).end();
        List list = this.iItemExtendService.joinList((Wrapper)wrapper, PcpItemRespDto.class);
        return list;
    }

    private PageInfo<PcpItemRespDto> getPcpItemRespDtoPageInfo(Integer pageNum, Integer pageSize, IPage<PcpItemRespDto> page) {
        List dtoList = Optional.ofNullable(page.getRecords()).orElse(Lists.newArrayList());
        PageInfo pageInfo = new PageInfo(dtoList.stream().peek(d -> {
            d.setLongCode(d.getItemCode());
            d.setUnit(d.getUnitId());
        }).collect(Collectors.toList()));
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        pageInfo.setPages((int)page.getPages());
        pageInfo.setTotal(page.getTotal());
        return pageInfo;
    }
}

