/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirItemRelativeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirItemRelativeQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAttributesRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemShelfQueryExtReqDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemAttributesService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSearchService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfCacheService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IShelfExtService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemStorageDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfExtDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfPointsDeductionDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ShelfItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemStorageEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdShelfEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IShelfExtServiceImpl
implements IShelfExtService {
    private static Logger logger = LoggerFactory.getLogger(IShelfExtServiceImpl.class);
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private ItemPriceDas itemPriceDas;
    public static final String SHELF_ITEM = "SHELF_ITEM";
    @Resource
    private ShelfPointsDeductionDas shelfPointsDeductionDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemStorageDas itemStorageDas;
    @Autowired
    private IShelfCacheService shelfCacheService;
    @Resource
    private IItemService itemService;
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private IItemSearchService itemSearchService;
    @Resource
    private IItemAttributesService itemAttributesService;
    @Resource
    private ShelfExtDas shelfExtDas;

    @Override
    public PageInfo<ItemShelfQueryRespDto> getItemShelfPage(ItemShelfQueryExtReqDto itemShelfQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        LinkedList dtoList = Lists.newLinkedList();
        ShelfItemVo shelfItemVo = new ShelfItemVo();
        CubeBeanUtils.copyProperties((Object)shelfItemVo, (Object)itemShelfQueryReqDto, (String[])new String[0]);
        if (itemShelfQueryReqDto.getGroupBy() == null) {
            shelfItemVo.setGroupBy(Integer.valueOf(1));
        }
        if (ItemStatus.ITEM_SALE_OUT.getStatus().equals(itemShelfQueryReqDto.getItemStatus())) {
            shelfItemVo.setSellOut(Boolean.valueOf(true));
            shelfItemVo.setItemStatus((Integer)null);
        }
        if ((pageInfo = this.shelfExtDas.selectSelfItemByPage(shelfItemVo, pageNum, pageSize)) != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List<Integer> busTypes;
            List voList = pageInfo.getList();
            CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)voList, ItemShelfQueryRespDto.class);
            List<Long> shopIdList = dtoList.stream().map(ItemShelfQueryRespDto::getShopId).distinct().collect(Collectors.toList());
            List<Long> itemIdList = dtoList.stream().map(ItemShelfQueryRespDto::getItemId).distinct().collect(Collectors.toList());
            Integer busType = itemShelfQueryReqDto.getBusType();
            Map<String, List<ItemShelfSkuRespDto>> itemShelfSkuRespDtoMap = this.queryItemShelfSkuMap(shopIdList, itemIdList, busType);
            Map<Object, Object> itemMediaMap = Maps.newHashMap();
            List itemMediasEoList = this.itemMediasDas.selectByItemIds(itemIdList);
            if (CollectionUtils.isNotEmpty((Collection)itemMediasEoList)) {
                itemMediaMap = itemMediasEoList.stream().collect(Collectors.groupingBy(StdItemMediasEo::getItemId));
            }
            HashSet brandIds = Sets.newHashSet();
            HashSet dirIds = Sets.newHashSet();
            for (ItemShelfQueryRespDto itemShelfQueryRespDto : dtoList) {
                if (Objects.nonNull(itemShelfQueryRespDto.getBrandId())) {
                    brandIds.add(itemShelfQueryRespDto.getBrandId());
                }
                dirIds.add(itemShelfQueryRespDto.getDirId());
            }
            List<ItemAttributesRespDto> itemAttributesRespDtos = this.itemAttributesService.queryItemAttrByItemIdList(itemIdList);
            HashMap<Long, List<Integer>> dirListMap = new HashMap<Long, List<Integer>>();
            for (ItemAttributesRespDto itemAttributesRespDto : itemAttributesRespDtos) {
                JSONObject jsonObject = JSON.parseObject((String)itemAttributesRespDto.getAttrs());
                JSONArray backDirListJson = jsonObject.getJSONArray("backDirList");
                busTypes = backDirListJson.toJavaList(Long.class);
                dirListMap.put(itemAttributesRespDto.getItemId(), busTypes);
                dirIds.addAll(busTypes);
            }
            Map<Long, String> brandMap = this.itemService.getBrandMapByBrandIds(Lists.newArrayList((Iterable)brandIds));
            Map<Long, String> dirMap = this.itemService.getDirMapByDirIds(Lists.newArrayList((Iterable)dirIds));
            List<Long> itemIds = dtoList.stream().map(ItemShelfQueryRespDto::getItemId).collect(Collectors.toList());
            List<Long> shopIds = dtoList.stream().map(ItemShelfQueryRespDto::getShopId).collect(Collectors.toList());
            busTypes = dtoList.stream().map(ItemShelfQueryRespDto::getBusType).distinct().collect(Collectors.toList());
            List<DirItemRelativeQueryRespDto> relativeQueryRespDtos = this.itemService.queryItemDirRelativeBatch(itemIds, shopIds, busTypes);
            Map<String, List<DirItemRelativeQueryRespDto>> dirRelativeMap = relativeQueryRespDtos.stream().collect(Collectors.groupingBy(o -> "" + o.getItemId() + o.getShopId() + o.getBusType()));
            Map<Object, Object> finalItemMediaMap = itemMediaMap;
            dtoList.forEach(dto -> {
                Map<String, List<DirItemRelativeQueryRespDto>> itemFrontDirMap;
                List<DirItemRelativeQueryRespDto> dirItemRelativeQueryRespDtoList;
                List itemMediasEos = (List)finalItemMediaMap.get(dto.getItemId());
                if (CollectionUtils.isNotEmpty((Collection)itemMediasEos)) {
                    dto.setImgPath(((ItemMediasEo)itemMediasEos.get(0)).getPath1());
                }
                DirItemRelativeReqDto dirItemRelativeReqDto = new DirItemRelativeReqDto();
                dirItemRelativeReqDto.setDirType("front");
                dirItemRelativeReqDto.setItemId(dto.getItemId());
                dirItemRelativeReqDto.setShopId(dto.getShopId());
                dirItemRelativeReqDto.setBusType(dto.getBusType());
                List dirItemRelativeQueryRespDtos = (List)dirRelativeMap.get("" + dto.getItemId() + dto.getShopId() + dto.getBusType());
                if (CollectionUtils.isNotEmpty((Collection)dirItemRelativeQueryRespDtos) && CollectionUtils.isNotEmpty(dirItemRelativeQueryRespDtoList = (itemFrontDirMap = dirItemRelativeQueryRespDtos.stream().collect(Collectors.groupingBy(dirItemRelativeQueryRespDto -> dirItemRelativeQueryRespDto.getShopId() + dirItemRelativeQueryRespDto.getItemId() + ""))).get(dto.getShopId() + dto.getItemId() + ""))) {
                    dto.setFrontDirIdList(dirItemRelativeQueryRespDtoList.stream().map(DirItemRelativeQueryRespDto::getDirId).distinct().collect(Collectors.toList()));
                    dto.setFrontDirNameList(dirItemRelativeQueryRespDtoList.stream().map(DirItemRelativeQueryRespDto::getDirName).distinct().collect(Collectors.toList()));
                }
                List skuList = (List)itemShelfSkuRespDtoMap.get("" + dto.getShopId() + dto.getItemId());
                dto.setSkuList(skuList);
                if (Objects.nonNull(dto.getBrandId())) {
                    String brand = (String)brandMap.get(dto.getBrandId());
                    dto.setBrand(brand);
                }
                dto.setDirName((String)dirMap.get(dto.getDirId()));
                List dirIdList = (List)dirListMap.get(dto.getItemId());
                dto.setDirIdList(dirIdList);
                ArrayList<String> dirNameList = new ArrayList<String>();
                dto.setDirNameList(dirNameList);
                if (CollectionUtils.isNotEmpty((Collection)dirIdList)) {
                    for (Long dirId : dirIdList) {
                        String dirName = (String)dirMap.get(dirId);
                        dirNameList.add(dirName);
                    }
                }
            });
        }
        PageInfo resultPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)resultPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        resultPageInfo.setList((List)dtoList);
        return resultPageInfo;
    }

    private Map<String, List<ItemShelfSkuRespDto>> queryItemShelfSkuMap(List<Long> shopIdList, List<Long> itemIdList, Integer busType) {
        Map<Object, Object> itemShelfSkuMap = Maps.newHashMap();
        List shelfEoList = this.shelfDas.selectByParam(shopIdList, itemIdList, (List)null, busType);
        if (CollectionUtils.isNotEmpty((Collection)shelfEoList)) {
            List itemPriceEoList;
            List itemStorageEoList;
            List<ItemShelfSkuRespDto> itemShelfSkuRespDtoList = shelfEoList.stream().map(shelfEo -> {
                ItemShelfSkuRespDto itemShelfSkuRespDto = new ItemShelfSkuRespDto();
                itemShelfSkuRespDto.setShopId(shelfEo.getShopId());
                itemShelfSkuRespDto.setItemId(shelfEo.getItemId());
                itemShelfSkuRespDto.setId(shelfEo.getSkuId());
                itemShelfSkuRespDto.setPrice(shelfEo.getPrice());
                return itemShelfSkuRespDto;
            }).collect(Collectors.toList());
            List skuIdList = shelfEoList.stream().map(StdShelfEo::getSkuId).distinct().collect(Collectors.toList());
            List itemSkuEoList = this.itemSkuDas.selectItemSkuByIds(skuIdList);
            if (CollectionUtils.isNotEmpty((Collection)itemSkuEoList)) {
                Map itemSkuEoMap = itemSkuEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
                itemShelfSkuRespDtoList.forEach(itemShelfSkuRespDto -> {
                    ItemSkuEo itemSkuEo = (ItemSkuEo)itemSkuEoMap.get(itemShelfSkuRespDto.getId());
                    if (itemSkuEo != null) {
                        itemShelfSkuRespDto.setCode(itemSkuEo.getCode());
                        itemShelfSkuRespDto.setName(itemSkuEo.getName());
                        itemShelfSkuRespDto.setCspuid(itemSkuEo.getCspuid());
                        itemShelfSkuRespDto.setAttr(itemSkuEo.getAttr());
                        itemShelfSkuRespDto.setCargoCode(itemSkuEo.getCargoCode());
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(itemStorageEoList = this.itemStorageDas.selectByParam(shopIdList, itemIdList, skuIdList)))) {
                Map<String, List<ItemStorageEo>> itemStorageEoMap = itemStorageEoList.stream().filter(itemStorageEo -> itemStorageEo.getShopId() != null && itemStorageEo.getItemId() != null && itemStorageEo.getSkuId() != null).collect(Collectors.groupingBy(itemStorageEo -> "" + itemStorageEo.getShopId() + itemStorageEo.getItemId() + itemStorageEo.getSkuId()));
                itemShelfSkuRespDtoList.forEach(itemShelfSkuRespDto -> {
                    List itemStorageEos = (List)itemStorageEoMap.get("" + itemShelfSkuRespDto.getShopId() + itemShelfSkuRespDto.getItemId() + itemShelfSkuRespDto.getId());
                    if (CollectionUtils.isNotEmpty((Collection)itemStorageEos)) {
                        itemShelfSkuRespDto.setBalance(((ItemStorageEo)itemStorageEos.get(0)).getBalance());
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(itemPriceEoList = this.itemPriceDas.selectBySkuIds(skuIdList)))) {
                ArrayList itemPriceRespDtoList = Lists.newArrayList();
                DtoHelper.eoList2DtoList((Collection)itemPriceEoList, (Collection)itemPriceRespDtoList, ItemPriceRespDto.class);
                Map itemPriceRespDtoMap = itemPriceRespDtoList.stream().collect(Collectors.groupingBy(ItemPriceRespDto::getSkuId, Collectors.toList()));
                itemShelfSkuRespDtoList.forEach(itemShelfSkuRespDto -> itemShelfSkuRespDto.setItemPriceList((List)itemPriceRespDtoMap.get(itemShelfSkuRespDto.getId())));
            }
            itemShelfSkuMap = itemShelfSkuRespDtoList.stream().collect(Collectors.groupingBy(itemShelfSkuRespDto -> "" + itemShelfSkuRespDto.getShopId() + itemShelfSkuRespDto.getItemId()));
        }
        return itemShelfSkuMap;
    }
}

