/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.aliyun.openservices.shade.com.google.common.base.Throwables;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.BusType;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemConstant;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemExtExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemType;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.Status;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ImportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemBundlesExcelReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemBundlesReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendOnShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemQueryConditionReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.RItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.BundlesRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.DirCategoryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemBundlesRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemBundlesSupplyPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.RItemBundleQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.RItemBundleRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.item.biz.enus.GenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemChannelService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IRItemRundleSupplyPriceService;
import com.dtyunxi.yundt.cube.center.item.biz.service.ItemExtShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.service.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.item.biz.service.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.item.biz.service.impl.AbstractRItemBundleServiceImpl;
import com.dtyunxi.yundt.cube.center.item.biz.utils.Assert;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.RItemBundleDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.RItemRundleSupplyPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.RItemBundleEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.RItemRundleSupplyPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="vattiRItemBundleService")
public class VattiRItemBundleServiceImpl
extends AbstractRItemBundleServiceImpl {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private RItemBundleDas rItemBundleDas;
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private DirDas dirDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    private Environment environment;
    @Resource
    private ICacheService cacheService;
    @Value(value="${item.dir.frontId:1287289350349201415}")
    private Long FRONT_CATEGORY_ID;
    @Resource
    private ItemExtShelfDas itemExtShelfDas;
    @Resource
    private ItemExtShelfService itemExtShelfService;
    @Resource
    private IItemChannelService iItemChannelService;
    @Resource
    private IRItemRundleSupplyPriceService irItemRundleSupplyPriceService;
    @Resource
    private RItemRundleSupplyPriceDas rItemRundleSupplyPriceDas;

    @Override
    public PageInfo<ItemRespDto> selectItemPage(ItemQueryConditionReqDto queryConditionReqDto) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.itemDas.filter().orderByDesc((Object)"update_time");
        if (StringUtils.isNotBlank((CharSequence)queryConditionReqDto.getItemName())) {
            sqlFilters.like((Object)"name", (Object)("%" + queryConditionReqDto.getItemName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)queryConditionReqDto.getItemCode())) {
            sqlFilters.like((Object)"code", (Object)("%" + queryConditionReqDto.getItemCode() + "%"));
        }
        if (queryConditionReqDto.getDirId() != null) {
            sqlFilters.eq((Object)"dir_id", (Object)queryConditionReqDto.getDirId());
        }
        if (queryConditionReqDto.getDirPrefixId() != null) {
            sqlFilters.eq((Object)"dir_prefix_id", (Object)queryConditionReqDto.getDirPrefixId());
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(ItemType.GENERAL_ITEM.getStatus());
        list.add(ItemType.GIF_ITEM.getStatus());
        list.add(ItemType.V_ITEM.getStatus());
        sqlFilters.in((Object)"type", list);
        PageInfo eoPageInfo = sqlFilters.page(queryConditionReqDto.getPageNum(), queryConditionReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemRespDto.class);
        dtoList.stream().forEach(v -> {
            v.setItemId(v.getId());
            v.setItemCode(v.getCode());
            v.setItemName(v.getName());
            ArrayList skuRespDtoList = new ArrayList();
            List skuEoList = this.itemSkuDas.selectByItemId(v.getId());
            CubeBeanUtils.copyCollection(skuRespDtoList, (Collection)skuEoList, ItemSkuRespDto.class);
            v.setItemSkuList(skuRespDtoList);
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public Long addRItemBundle(RItemBundleReqDto addReqDto) {
        RItemBundleEo rItemBundleEo = new RItemBundleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)rItemBundleEo);
        this.rItemBundleDas.insert((BaseEo)rItemBundleEo);
        return rItemBundleEo.getId();
    }

    @Override
    public void modifyRItemBundle(RItemBundleReqDto modifyReqDto) {
        RItemBundleEo rItemBundleEo = new RItemBundleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)rItemBundleEo);
        this.rItemBundleDas.updateSelective((BaseEo)rItemBundleEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRItemBundle(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.rItemBundleDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public RItemBundleRespDto queryById(Long id) {
        RItemBundleEo rItemBundleEo = (RItemBundleEo)this.rItemBundleDas.selectByPrimaryKey(id);
        RItemBundleRespDto rItemBundleRespDto = new RItemBundleRespDto();
        DtoHelper.eo2Dto((BaseEo)rItemBundleEo, (BaseVo)rItemBundleRespDto);
        return rItemBundleRespDto;
    }

    @Override
    public ItemBundlesRespDto queryBundleItemByItemCode(String itemCode) {
        ItemBundlesRespDto respDto = new ItemBundlesRespDto();
        ItemEo eo = ItemEo.newInstance();
        eo.setCode(itemCode);
        ItemEo itemEo = (ItemEo)this.itemDas.selectOne((BaseEo)eo);
        if (itemEo == null) {
            throw new BizException(ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getMsg());
        }
        CubeBeanUtils.copyProperties((Object)respDto, (Object)itemEo, (String[])new String[0]);
        respDto.setId(itemEo.getId());
        respDto.setItemId(itemEo.getId());
        respDto.setItemCode(itemEo.getCode());
        respDto.setItemName(itemEo.getName());
        ArrayList bundleReqDtos = new ArrayList();
        List bundleEos = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().eq((Object)"item_id", (Object)itemEo.getId())).list();
        CubeBeanUtils.copyCollection(bundleReqDtos, (Collection)bundleEos, RItemBundleRespDto.class);
        respDto.setBundleReqDtos(bundleReqDtos);
        return respDto;
    }

    @Override
    public ItemBundlesRespDto queryBundleItem(ItemBundlesReqDto bundlesReqDto) {
        ItemBundlesRespDto respDto = new ItemBundlesRespDto();
        ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"id", (Object)bundlesReqDto.getItemId())).one();
        if (itemEo == null) {
            throw new BizException(ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getMsg());
        }
        this.assembleItemBundlesRespDto(respDto, itemEo);
        return respDto;
    }

    @Override
    public List<ItemBundlesRespDto> queryBundleItemByCodes(List<String> itemCodes) {
        this.logger.info("queryBundleItemByCodes\u67e5\u8be2\u7ec4\u5408\u5546\u54c1\u96c6\u5408\u5165\u53c2:{}", (Object)JSON.toJSONString(itemCodes));
        List itemEos = ((ExtQueryChainWrapper)this.itemDas.filter().in((Object)"code", itemCodes)).list();
        ArrayList<ItemBundlesRespDto> respDtoList = new ArrayList<ItemBundlesRespDto>();
        if (CollectionUtil.isNotEmpty((Collection)itemEos)) {
            itemEos.stream().forEach(eo -> {
                ItemBundlesRespDto respDto = new ItemBundlesRespDto();
                this.assembleItemBundlesRespDto(respDto, (ItemEo)eo);
                respDtoList.add(respDto);
            });
        }
        return respDtoList;
    }

    @Override
    public PageInfo<RItemBundleRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        RItemBundleReqDto rItemBundleReqDto = (RItemBundleReqDto)JSON.parseObject((String)filter, RItemBundleReqDto.class);
        RItemBundleEo rItemBundleEo = new RItemBundleEo();
        DtoHelper.dto2Eo((BaseVo)rItemBundleReqDto, (BaseEo)rItemBundleEo);
        PageInfo eoPageInfo = this.rItemBundleDas.selectPage((BaseEo)rItemBundleEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, RItemBundleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addItemBundle(ItemExtBundleReqDto itemExtBundleReqDto) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BundlesRespDto addItemExtBundles(ItemBundlesReqDto reqDto) {
        IGenerateCodeService strategy;
        this.checkIncoming(reqDto);
        this.logger.info("addItemExtBundles------>\u65b0\u589e\u7ec4\u5408\u5546\u54c1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        String itemCode = null;
        itemCode = reqDto.getItemCode();
        if (StringUtils.isBlank((CharSequence)itemCode) && Objects.nonNull(strategy = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.ITEM_BUNDLE.getCode()))) {
            itemCode = strategy.getCode();
        }
        this.checkItemCode(itemCode);
        ItemEo itemEo = ItemEo.newInstance();
        itemEo.setCode(itemCode);
        this.setBundleItem(itemEo, reqDto);
        itemEo.setSaleGroup(reqDto.getSaleGroup());
        itemEo.setProdLargeClass(reqDto.getProdLargeClass());
        this.logger.info("addItemExtBundles--->\u5546\u54c1\u4e3b\u8868\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)itemEo));
        this.itemDas.insert((BaseEo)itemEo);
        ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
        itemSkuEo.setItemId(itemEo.getId());
        itemSkuEo.setCode(itemCode);
        itemSkuEo.setName(reqDto.getItemName());
        itemSkuEo.setAttr(JSON.toJSONString((Object)itemEo));
        itemSkuEo.setAdvanceSale(Status.ADVANCE_SALE.getCode());
        this.logger.info("addItemExtBundles--->\u5546\u54c1\u89c4\u683c\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)itemSkuEo));
        this.itemSkuDas.insert((BaseEo)itemSkuEo);
        ArrayList mEoList = new ArrayList();
        CubeBeanUtils.copyCollection(mEoList, (Collection)reqDto.getMedias(), ItemMediasEo.class);
        mEoList.forEach(v -> {
            v.setItemId(itemEo.getId());
            v.setSkuId(itemSkuEo.getId());
        });
        this.logger.info("addItemExtBundles--->\u5546\u54c1\u591a\u5a92\u4f53\u4fe1\u606f:{}", (Object)JSON.toJSONString(mEoList));
        this.itemMediasDas.insertBatch(mEoList);
        ArrayList mediasRespDtos = new ArrayList();
        CubeBeanUtils.copyCollection(mediasRespDtos, mEoList, ItemMediasRespDto.class);
        List<RItemBundleEo> bundleEos = this.saveSubItemBundle(reqDto, itemEo, itemSkuEo);
        this.logger.info("addItemExtBundles--->\u7ec4\u5408\u5546\u54c1\u5b50\u5546\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString(bundleEos));
        BundlesRespDto bundlesRespDto = new BundlesRespDto();
        bundlesRespDto.setItemId(itemEo.getId());
        bundlesRespDto.setItemCode(itemCode);
        bundlesRespDto.setSkuId(itemSkuEo.getId());
        bundlesRespDto.setSkuCode(itemCode);
        bundlesRespDto.setDirPrefixId(reqDto.getDirPrefixId());
        this.cacheService.delCacheByPattern("item_", "*");
        this.cacheService.delCacheByPattern("item_trade_", "*");
        return bundlesRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long editItemExtBundles(ItemBundlesReqDto reqDto) {
        List supplyPriceEos;
        this.checkIncoming(reqDto);
        this.logger.info("\u7ec4\u5408\u5546\u54c1\u7f16\u8f91\u5165\u53c2editItemExtBundles:{}", (Object)JSON.toJSONString((Object)reqDto));
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(reqDto.getItemId());
        if (itemEo == null) {
            throw new BizException(ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getMsg());
        }
        ItemSkuEo itemSkuEo = (ItemSkuEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemSkuDas.filter().eq((Object)"item_id", (Object)itemEo.getId())).eq((Object)"dr", (Object)0)).one();
        this.setBundleItem(itemEo, reqDto);
        this.logger.info("editItemExtBundles---->\u5546\u54c1\u4e3b\u8868\u4fe1\u606fitemEo:{}", (Object)JSON.toJSONString((Object)itemEo));
        this.itemDas.updateSelective((BaseEo)itemEo);
        List medias = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemMediasDas.filter().eq((Object)"item_id", (Object)itemEo.getId())).eq((Object)"dr", (Object)0)).list();
        if (CollectionUtil.isNotEmpty((Collection)medias)) {
            this.itemMediasDas.deleteBatchMedias(medias.stream().filter(o -> o.getId() != null).map(BaseEo::getId).collect(Collectors.toList()));
        }
        ArrayList mEoList = new ArrayList();
        CubeBeanUtils.copyCollection(mEoList, (Collection)reqDto.getMedias(), ItemMediasEo.class);
        mEoList.forEach(v -> {
            v.setItemId(itemEo.getId());
            v.setSkuId(itemSkuEo.getId());
        });
        this.logger.info("editItemExtBundles---->\u5546\u54c1\u7684\u591a\u5a92\u4f53\u4fe1\u606f:{}", (Object)JSON.toJSONString(mEoList));
        this.itemMediasDas.insertBatch(mEoList);
        List bundleEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.rItemBundleDas.filter().eq((Object)"dr", (Object)0)).eq((Object)"item_id", (Object)itemEo.getId())).list();
        if (CollectionUtil.isNotEmpty((Collection)bundleEoList)) {
            this.rItemBundleDas.logicDeleteByIds(bundleEoList.stream().filter(bundleEo -> bundleEo.getId() != null).map(BaseEo::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)(supplyPriceEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.rItemRundleSupplyPriceDas.filter().eq((Object)"dr", (Object)0)).eq((Object)"item_code", (Object)itemEo.getCode())).list()))) {
            this.rItemRundleSupplyPriceDas.logicDeleteByIds(supplyPriceEos.stream().filter(supplyPriceEo -> supplyPriceEo.getId() != null).map(BaseEo::getId).collect(Collectors.toList()));
        }
        List<RItemBundleEo> bundleEos = this.saveSubItemBundle(reqDto, itemEo, itemSkuEo);
        this.logger.info("editItemExtBundles---->\u7ec4\u5408\u5546\u54c1\u5b50\u5546\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString(bundleEos));
        itemSkuEo.setBundles(JSON.toJSONString(bundleEos));
        itemSkuEo.setName(reqDto.getItemName());
        this.itemSkuDas.updateSelective((BaseEo)itemSkuEo);
        this.logger.info("editItemExtBundles---->\u5546\u54c1\u89c4\u683c\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)itemSkuEo));
        this.cacheService.delCacheByPattern("item_", "*");
        this.cacheService.delCacheByPattern("item_trade_", "*");
        return itemEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBundleItem(Long id, Long itemId) {
        ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"id", (Object)itemId)).one();
        if (itemEo == null) {
            throw new BizException(ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getMsg());
        }
        if (null != itemEo.getItemUse() && ItemConstant.ITEM_USE == itemEo.getItemUse()) {
            throw new BizException("\u7ec4\u5408\u5546\u54c1\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        ShelfEo shelfEo = (ShelfEo)this.shelfDas.selectByPrimaryKey(id);
        if (shelfEo == null) {
            throw new BizException(ItemExtExceptionCode.ITEM_NOT_SHELF_EXIST.getCode(), ItemExtExceptionCode.ITEM_NOT_SHELF_EXIST.getMsg());
        }
        List shelfEos = ((ExtQueryChainWrapper)this.shelfDas.filter().eq((Object)"item_id", (Object)itemId)).list();
        Iterator iterator = shelfEos.iterator();
        while (iterator.hasNext()) {
            ShelfEo eo = (ShelfEo)iterator.next();
            if (Long.compare(eo.getId(), id) != 0) continue;
            this.shelfDas.logicDeleteById(id);
            iterator.remove();
        }
        if (CollectionUtils.isEmpty((Collection)shelfEos)) {
            this.itemDas.logicDeleteById(itemId);
            ItemSkuEo skuEo = new ItemSkuEo();
            skuEo.setItemId(itemId);
            this.itemSkuDas.logicDelete((BaseEo)skuEo);
            RItemBundleEo itemBundleEo = new RItemBundleEo();
            itemBundleEo.setItemId(itemId);
            this.rItemBundleDas.logicDelete((BaseEo)itemBundleEo);
        }
        this.cacheService.delCacheByPattern("item_trade_", "*");
    }

    @Override
    @Transactional
    public String removeVattiBundleItem(Long id) {
        ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"id", (Object)id)).one();
        if (itemEo == null) {
            throw new BizException(ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DATA_NOT_EXIST.getMsg());
        }
        this.itemDas.deleteById(id);
        List rItemBundleEos = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().eq((Object)"item_id", (Object)id)).list();
        if (CollectionUtil.isNotEmpty((Collection)rItemBundleEos)) {
            rItemBundleEos.forEach(rItemBundleEo -> this.rItemBundleDas.deleteById(rItemBundleEo.getId()));
        }
        return itemEo.getCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String importAndShelfItem(ImportDto importDto) {
        List<ItemBundlesExcelReqDto> excelReqDtoList = null;
        try {
            excelReqDtoList = EasyPoiExportUtil.parseImportFile(importDto.getUrl(), ItemBundlesExcelReqDto.class);
        }
        catch (Exception e) {
            this.logger.error(ItemExtExceptionCode.ITEM_BUNDLES_IMPORT_PARSING_ERROR.getMsg(), (Object)Throwables.getStackTraceAsString((Throwable)e));
            throw new BizException(ItemExtExceptionCode.ITEM_BUNDLES_IMPORT_PARSING_ERROR.getMsg(), e.getMessage());
        }
        Iterator<ItemBundlesExcelReqDto> iterator = excelReqDtoList.iterator();
        while (iterator.hasNext()) {
            ItemBundlesExcelReqDto it = iterator.next();
            if (!StringUtils.isBlank((CharSequence)it.getItemCode()) || !StringUtils.isBlank((CharSequence)it.getItemName()) || !StringUtils.isBlank((CharSequence)it.getSubItemCode()) || !StringUtils.isBlank((CharSequence)it.getNum())) continue;
            iterator.remove();
        }
        Assert.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(excelReqDtoList), ItemExtExceptionCode.ITEM_BUNDLES_IMPORT_ERROR);
        Map<String, List<ItemBundlesExcelReqDto>> itemBundlesExcelRedDtoMap = excelReqDtoList.stream().filter(m -> StringUtils.isNotBlank((CharSequence)m.getItemCode())).collect(Collectors.groupingBy(ItemBundlesExcelReqDto::getItemCode));
        ArrayList bundlesExcelReqDtos = Lists.newArrayList();
        StringBuffer resultMsg = new StringBuffer();
        HashMap itemMap = new HashMap();
        itemBundlesExcelRedDtoMap.forEach((k, v) -> {
            List excelReqDtos = v;
            List subItemCodes = excelReqDtos.stream().map(e -> e.getSubItemCode()).collect(Collectors.toList());
            long count = subItemCodes.stream().distinct().count();
            if ((long)subItemCodes.size() != count) {
                resultMsg.append("\u7ec4\u5408\u5546\u54c1\uff1a" + k + " \u5bfc\u5165\u7684\u5546\u54c1\u7f16\u7801\u5b58\u5728\u76f8\u540c\u5b50\u5546\u54c1\u7f16\u7801,\u8bf7\u68c0\u67e5\uff01");
                return;
            }
            excelReqDtos.forEach(i -> {
                if (StringUtils.isBlank((CharSequence)i.getSubItemCode())) {
                    resultMsg.append("\u7ec4\u5408\u5546\u54c1\uff1a" + k + " \u5bf9\u5e94\u7684\u5b50\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a\uff1b");
                    itemMap.put(k, v);
                    return;
                }
                ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"code", (Object)i.getSubItemCode())).one();
                if (null == itemEo) {
                    resultMsg.append("\u7ec4\u5408\u5546\u54c1\uff1a" + k + " \u5bf9\u5e94\u7684\u5b50\u5546\u54c1\uff1a" + i.getSubItemCode() + " \u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\uff1b");
                    itemMap.put(k, v);
                    return;
                }
                if (StringUtils.isBlank((CharSequence)i.getNum())) {
                    resultMsg.append("\u7ec4\u5408\u5546\u54c1\uff1a" + k + " \u5bf9\u5e94\u7684\u5b50\u5546\u54c1\uff1a" + i.getSubItemCode() + " \u6570\u91cf\u4e3a\u7a7a\uff1b");
                    itemMap.put(k, v);
                    return;
                }
                if (!i.getNum().matches("[0-9]*")) {
                    resultMsg.append("\u7ec4\u5408\u5546\u54c1\uff1a" + k + " \u5bf9\u5e94\u7684\u5b50\u5546\u54c1\uff1a" + i.getSubItemCode() + " \u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57\uff1b");
                    itemMap.put(k, v);
                    return;
                }
            });
        });
        itemBundlesExcelRedDtoMap.forEach((k, v) -> {
            if (!itemMap.containsKey(k)) {
                List excelReqDtos = v;
                excelReqDtos.forEach(i -> {
                    ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"code", (Object)i.getSubItemCode())).one();
                    ItemSkuEo itemSkuEo = (ItemSkuEo)((ExtQueryChainWrapper)this.itemSkuDas.filter().eq((Object)"code", (Object)i.getSubItemCode())).one();
                    i.setSubSkuId(itemSkuEo.getId());
                    i.setSubItemCode(itemEo.getCode());
                    i.setSubItemId(itemEo.getId());
                    i.setSubItemName(itemEo.getName());
                    bundlesExcelReqDtos.add(i);
                });
            }
        });
        this.importBumdlesItemsAndOnShelf(bundlesExcelReqDtos);
        if (resultMsg.length() > 0) {
            return resultMsg.toString();
        }
        return "0";
    }

    @Override
    public void batchOnShelfItem(List<ItemExtendOnShelfReqDto> extendOnShelfReqDtos) {
        List<Long> ids;
        ArrayList<ItemShelfReqDto> lists = new ArrayList<ItemShelfReqDto>();
        extendOnShelfReqDtos.forEach(v -> ItemConstant.SHELF_ADDRESS.forEach(i -> {
            ItemShelfReqDto itemShelfReqDto = new ItemShelfReqDto();
            itemShelfReqDto.setType(ShelfTypeEnum.NORMAL.getType());
            itemShelfReqDto.setBusType(BusType.COMMON_ITEM.getCode());
            itemShelfReqDto.setItemId(v.getItemId());
            itemShelfReqDto.setItemType(ItemTypeEnum.BUNDLE.getType());
            itemShelfReqDto.setShopId(ItemConstant.SHOP_ID);
            itemShelfReqDto.setSellerId(ItemConstant.SELLER_ID);
            itemShelfReqDto.setShelfAddress(i);
            itemShelfReqDto.setDirId(v.getDirPrefixId());
            itemShelfReqDto.setSkuId(v.getSkuId());
            lists.add(itemShelfReqDto);
        }));
        if (!CollectionUtils.isEmpty(lists)) {
            this.itemExtShelfService.onShelfOperation(lists, false, null);
        }
        if (!CollectionUtils.isEmpty(ids = extendOnShelfReqDtos.stream().map(ItemExtendOnShelfReqDto::getItemId).collect(Collectors.toList()))) {
            ids.forEach(v -> {
                ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"id", v)).one();
                itemEo.setShopId(ItemConstant.SHOP_ID);
                itemEo.setStatus(ItemStatus.ON_LINE.getStatus());
                this.itemDas.updateSelective((BaseEo)itemEo);
            });
        }
        ExecutorUtils.execute(() -> extendOnShelfReqDtos.forEach(v -> {
            List shelfEos = ((ExtQueryChainWrapper)this.shelfDas.filter().in((Object)"item_id", new Object[]{v.getItemId()})).list();
            if (!CollectionUtils.isEmpty((Collection)shelfEos)) {
                this.iItemChannelService.batchAddItemPlatform(v.getItemId(), v.getSkuId(), shelfEos.stream().map(BaseEo::getId).collect(Collectors.toList()));
            }
        }));
    }

    @Override
    public void batchShelfItemByCode(List<String> codes) {
        ArrayList<ItemShelfReqDto> lists = new ArrayList<ItemShelfReqDto>();
        List itemEoList = ((ExtQueryChainWrapper)this.itemDas.filter().in((Object)"code", codes)).list();
        List itemSkuEoList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)itemEoList)) {
            DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(this.FRONT_CATEGORY_ID);
            itemSkuEoList = ((ExtQueryChainWrapper)this.itemSkuDas.filter().in((Object)"code", codes)).list();
            Map itemSkuEoMap = itemSkuEoList.stream().collect(Collectors.toMap(StdItemSkuEo::getItemId, Function.identity(), (k1, k2) -> k1));
            itemEoList.forEach(v -> ItemConstant.SHELF_ADDRESS.forEach(i -> {
                ItemShelfReqDto itemShelfReqDto = new ItemShelfReqDto();
                itemShelfReqDto.setType(ShelfTypeEnum.NORMAL.getType());
                itemShelfReqDto.setBusType(BusType.COMMON_ITEM.getCode());
                itemShelfReqDto.setItemId(v.getId());
                itemShelfReqDto.setItemType(v.getType());
                itemShelfReqDto.setShopId(ItemConstant.SHOP_ID);
                itemShelfReqDto.setSellerId(ItemConstant.SELLER_ID);
                itemShelfReqDto.setShelfAddress(i);
                itemShelfReqDto.setDirId(dirEo.getId());
                itemShelfReqDto.setSkuId(((ItemSkuEo)itemSkuEoMap.get(v.getId())).getId());
                lists.add(itemShelfReqDto);
            }));
            if (!CollectionUtils.isEmpty(lists)) {
                this.itemExtShelfService.onShelfOperation(lists, false, null);
            }
        }
    }

    @Override
    public void itemUse(Long itemId) {
        ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"id", (Object)itemId)).one();
        if (null != itemEo && ItemConstant.ITEM_USE == itemEo.getItemUse()) {
            throw new BizException("\u7ec4\u5408\u5546\u54c1\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
    }

    @Override
    public List<RItemBundleRespDto> queryRItemBundleByItemIds(List<Long> itemIdList) {
        ArrayList<RItemBundleRespDto> bundleReqDtos = new ArrayList<RItemBundleRespDto>();
        List bundleEos = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().in((Object)"item_id", itemIdList)).list();
        CubeBeanUtils.copyCollection(bundleReqDtos, (Collection)bundleEos, RItemBundleRespDto.class);
        return bundleReqDtos;
    }

    @Override
    public List<RItemBundleQueryRespDto> queryRItemBundleBySkuCodes(List<String> skuCodeList) {
        this.logger.info("queryRItemBundleBySkuCodes query skuCodeList={}", skuCodeList);
        ArrayList<RItemBundleQueryRespDto> retDtoList = new ArrayList<RItemBundleQueryRespDto>();
        List itemSkuEoList = ((ExtQueryChainWrapper)this.itemSkuDas.filter().in((Object)"code", skuCodeList)).list();
        List itemIdList = itemSkuEoList.stream().map(sku -> sku.getItemId()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(itemIdList)) {
            List bundleEos = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().in((Object)"item_id", itemIdList)).list();
            bundleEos.forEach(bundleEo -> {
                RItemBundleQueryRespDto retDto = new RItemBundleQueryRespDto();
                DtoHelper.eo2Dto((BaseEo)bundleEo, (BaseVo)retDto);
                retDto.setUnitPrice(Objects.isNull(bundleEo.getUnitPrice()) ? BigDecimal.ZERO : bundleEo.getUnitPrice());
                Optional<ItemSkuEo> sku = itemSkuEoList.stream().filter(skuEo -> skuEo.getId().equals(bundleEo.getSkuId())).findFirst();
                if (sku.isPresent()) {
                    retDto.setSkuCode(sku.get().getCode());
                }
                retDtoList.add(retDto);
            });
        } else {
            this.logger.info("queryRItemBundleBySkuCodes get itemids null");
        }
        return retDtoList;
    }

    @Override
    public List<RItemBundleQueryRespDto> queryBundleItemSku(List<String> skuCodeList) {
        this.logger.info("queryRItemBundleBySkuCodes query skuCodeList={}", skuCodeList);
        ArrayList<RItemBundleQueryRespDto> retDtoList = new ArrayList<RItemBundleQueryRespDto>();
        List itemEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemDas.filter().select(new String[]{"id", "code"}).in((Object)"code", skuCodeList)).eq((Object)"type", (Object)ItemType.COMB_ITEM.getStatus())).list();
        List itemIds = itemEoList.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(itemIds)) {
            List bundleEos = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().in((Object)"item_id", itemIds)).list();
            bundleEos.forEach(bundleEo -> {
                RItemBundleQueryRespDto retDto = new RItemBundleQueryRespDto();
                DtoHelper.eo2Dto((BaseEo)bundleEo, (BaseVo)retDto);
                retDto.setUnitPrice(Objects.isNull(bundleEo.getUnitPrice()) ? BigDecimal.ZERO : bundleEo.getUnitPrice());
                Optional<ItemEo> sku = itemEoList.stream().filter(skuEo -> skuEo.getId().equals(bundleEo.getItemId())).findFirst();
                if (sku.isPresent()) {
                    retDto.setSkuCode(sku.get().getCode());
                }
                retDtoList.add(retDto);
            });
        } else {
            this.logger.info("queryRItemBundleBySkuCodes get itemids null");
        }
        return retDtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchImportBundleItem(List<ItemBundlesReqDto> reqDtos) {
        if (CollectionUtils.isEmpty(reqDtos)) {
            throw new BizException(ItemExtExceptionCode.ITEM_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_NOT_EXIST.getMsg());
        }
        ArrayList itemEos = new ArrayList();
        ArrayList itemSkuEos = new ArrayList();
        ArrayList rItemBundleEos = new ArrayList();
        ArrayList onShelfReqDtos = Lists.newArrayList();
        reqDtos.forEach(v -> {
            ItemExtendOnShelfReqDto onShelfReqDto = new ItemExtendOnShelfReqDto();
            ItemEo itemEo = new ItemEo();
            itemEo.setId(this.getId());
            itemEo.setCode(v.getItemCode());
            itemEo.setName(v.getItemName());
            itemEo.setDisplayName(v.getItemName());
            itemEo.setStatus(ItemStatus.PUBLISHED.getStatus());
            itemEo.setType(ItemType.COMB_ITEM.getStatus());
            itemEos.add(itemEo);
            ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
            itemSkuEo.setId(this.getId());
            itemSkuEo.setItemId(itemEo.getId());
            itemSkuEo.setCode(v.getItemCode());
            itemSkuEo.setName(v.getItemName());
            itemSkuEo.setAttr(JSON.toJSONString((Object)itemEo));
            itemSkuEo.setAdvanceSale(Status.ADVANCE_SALE.getCode());
            itemSkuEos.add(itemSkuEo);
            ArrayList bundleEos = new ArrayList();
            CubeBeanUtils.copyCollection(bundleEos, (Collection)v.getBundleReqDtos(), RItemBundleEo.class);
            bundleEos.forEach(j -> {
                j.setItemId(itemEo.getId());
                j.setSkuId(itemSkuEo.getId());
            });
            rItemBundleEos.addAll(bundleEos);
            onShelfReqDto.setItemId(itemEo.getId());
            onShelfReqDto.setItemCode(itemEo.getCode());
            onShelfReqDto.setSkuId(itemSkuEo.getId());
            onShelfReqDtos.add(onShelfReqDto);
        });
        if (!CollectionUtils.isEmpty(itemEos)) {
            this.itemDas.insertBatch(itemEos);
            this.itemSkuDas.insertBatch(itemSkuEos);
            this.rItemBundleDas.insertBatch(rItemBundleEos);
        }
        this.logger.info("onShelfReqDtos:{}", JSON.toJSON((Object)onShelfReqDtos));
        if (!CollectionUtils.isEmpty((Collection)onShelfReqDtos)) {
            this.saveShelfRecord(onShelfReqDtos);
        }
    }

    private void checkIncoming(ItemBundlesReqDto reqDto) {
        if (null == reqDto) {
            throw new BizException(ItemExtExceptionCode.ITEM_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_NOT_EXIST.getMsg());
        }
        if (CollectionUtil.isEmpty((Collection)reqDto.getBundleReqDtos())) {
            throw new BizException(ItemExtExceptionCode.ITEM_NOT_BUNDLE_EXIST.getCode(), ItemExtExceptionCode.ITEM_NOT_BUNDLE_EXIST.getMsg());
        }
    }

    private void judgeItemBundleRepeat(List<RItemBundleReqDto> bundleReqDtos, String groupName) {
        List subItemCodes = bundleReqDtos.stream().map(RItemBundleReqDto::getSubItemCode).collect(Collectors.toList());
        List resultItems = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.rItemBundleDas.filter().in((Object)"sub_item_code", subItemCodes)).groupBy((Object)"item_id")).list();
        if (CollectionUtil.isEmpty((Collection)resultItems)) {
            return;
        }
        Map groupItemMap = resultItems.stream().collect(Collectors.groupingBy(RItemBundleEo::getSubItemCode, Collectors.mapping(RItemBundleEo::getNum, Collectors.toSet())));
        StringBuffer errorSb = new StringBuffer();
        for (RItemBundleReqDto bundleReqDto : bundleReqDtos) {
            Set nums = groupItemMap.getOrDefault(bundleReqDto.getSubItemCode(), new HashSet());
            if (!nums.contains(bundleReqDto.getNum())) continue;
            errorSb.append(groupName).append("\u5957\u9910\u5546\u54c1").append(bundleReqDto.getSubItemCode()).append(":\u5df2\u5b58\u5728\u540c\u6837\u7684\u5b50\u5546\u54c1").append("\u3002");
        }
        Assert.isTrue((errorSb.length() < 1 ? 1 : 0) != 0, (String)"5000", (String)errorSb.toString());
    }

    private List<RItemBundleEo> saveSubItemBundle(ItemBundlesReqDto reqDto, ItemEo itemEo, ItemSkuEo itemSkuEo) {
        ArrayList<RItemBundleEo> bundleEos = new ArrayList<RItemBundleEo>();
        for (RItemBundleReqDto bundleReqDto : reqDto.getBundleReqDtos()) {
            RItemBundleEo rItemBundleEo = new RItemBundleEo();
            BeanUtils.copyProperties((Object)bundleReqDto, (Object)rItemBundleEo);
            rItemBundleEo.setItemId(itemEo.getId());
            rItemBundleEo.setSkuId(itemSkuEo.getId());
            List skuEoList = this.itemSkuDas.selectByItemId(rItemBundleEo.getSubItemId());
            rItemBundleEo.setSubSkuId(CollectionUtils.isEmpty((Collection)skuEoList) ? null : ((ItemSkuEo)skuEoList.get(0)).getId());
            BigDecimal num = Objects.isNull(rItemBundleEo.getNum()) ? BigDecimal.ZERO : new BigDecimal(rItemBundleEo.getNum());
            BigDecimal unitPrice = Objects.isNull(rItemBundleEo.getUnitPrice()) ? BigDecimal.ZERO : rItemBundleEo.getUnitPrice();
            rItemBundleEo.setTotalPrice(num.multiply(unitPrice).setScale(2, 4));
            bundleEos.add(rItemBundleEo);
            if (!CollectionUtil.isNotEmpty((Collection)bundleReqDto.getSupplyPriceList())) continue;
            ArrayList supplyPriceEos = new ArrayList();
            CubeBeanUtils.copyCollection(supplyPriceEos, (Collection)bundleReqDto.getSupplyPriceList(), RItemRundleSupplyPriceEo.class);
            for (RItemRundleSupplyPriceEo eo : supplyPriceEos) {
                eo.setItemCode(reqDto.getItemCode());
                eo.setSubItemId(bundleReqDto.getSubItemId());
                eo.setSubItemCode(bundleReqDto.getSubItemCode());
            }
            this.logger.info("[%s]\u7ec4\u5408\u5546\u54c1\u7684[%s]\u5b50\u5546\u54c1\u7684\u4f9b\u8d27\u4ef7\u4fe1\u606f:{}", new Object[]{reqDto.getItemCode(), bundleReqDto.getSubItemCode(), JSON.toJSONString(supplyPriceEos)});
            this.rItemRundleSupplyPriceDas.insertBatch(supplyPriceEos);
        }
        this.rItemBundleDas.insertBatch(bundleEos);
        return bundleEos;
    }

    private void setBundleItem(ItemEo itemEo, ItemBundlesReqDto reqDto) {
        List dirEos;
        Map dirEoMap;
        DirEo dirEo;
        itemEo.setName(reqDto.getItemName());
        itemEo.setDisplayName(reqDto.getItemName());
        itemEo.setBrief(reqDto.getBrief());
        itemEo.setDetail(reqDto.getBrief());
        itemEo.setStatus(ItemStatus.PUBLISHED.getStatus());
        itemEo.setType(ItemType.COMB_ITEM.getStatus());
        itemEo.setBusType(BusType.COMMON_ITEM.getCode());
        itemEo.setDomesticB2b(reqDto.getDomesticB2b());
        itemEo.setInternalB2b(reqDto.getInternalB2b());
        itemEo.setSpecContent(reqDto.getSpecContent());
        if (!CollectionUtils.isEmpty((Collection)reqDto.getDirIds())) {
            List dirIds = reqDto.getDirIds();
            if (dirIds.size() == 1) {
                itemEo.setDirId(Long.valueOf((String)dirIds.get(0)));
                dirEo = (DirEo)this.dirDas.selectByPrimaryKey(Long.valueOf((String)dirIds.get(0)));
                if (dirEo != null) {
                    itemEo.setDirName(dirEo.getName());
                    itemEo.setProdLargeClass(dirEo.getName());
                    itemEo.setProdLargeCode(dirEo.getCode());
                    itemEo.setProdSecCode(dirEo.getCode());
                    itemEo.setProdSecClassify(dirEo.getName());
                    itemEo.setProdClassCode(dirEo.getCode());
                    itemEo.setProdClassName(dirEo.getName());
                    itemEo.setProdThrCode(dirEo.getCode());
                    itemEo.setProdThrClassify(dirEo.getName());
                }
            } else if (dirIds.size() > 1 && !CollectionUtils.isEmpty(dirEoMap = (dirEos = this.dirDas.selectByIds(dirIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1)))) {
                itemEo.setProdLargeCode(dirEoMap.get(Long.valueOf((String)dirIds.get(0))) != null ? ((DirEo)dirEoMap.get(Long.valueOf((String)dirIds.get(0)))).getCode() : null);
                itemEo.setProdLargeClass(dirEoMap.get(Long.valueOf((String)dirIds.get(0))) != null ? ((DirEo)dirEoMap.get(Long.valueOf((String)dirIds.get(0)))).getName() : null);
                itemEo.setProdSecCode(dirEoMap.get(Long.valueOf((String)dirIds.get(1))) != null ? ((DirEo)dirEoMap.get(Long.valueOf((String)dirIds.get(1)))).getCode() : null);
                itemEo.setProdSecClassify(dirEoMap.get(Long.valueOf((String)dirIds.get(1))) != null ? ((DirEo)dirEoMap.get(Long.valueOf((String)dirIds.get(1)))).getName() : null);
                itemEo.setProdThrCode(dirEoMap.get(Long.valueOf((String)dirIds.get(dirIds.size() - 2))) != null ? ((DirEo)dirEoMap.get(Long.valueOf((String)dirIds.get(1)))).getCode() : null);
                itemEo.setProdThrClassify(dirEoMap.get(Long.valueOf((String)dirIds.get(dirIds.size() - 2))) != null ? ((DirEo)dirEoMap.get(Long.valueOf((String)dirIds.get(1)))).getName() : null);
                itemEo.setDirId(dirEoMap.get(Long.valueOf((String)dirIds.get(dirIds.size() - 1))) != null ? ((DirEo)dirEoMap.get(Long.valueOf((String)dirIds.get(dirIds.size() - 1)))).getId() : null);
                itemEo.setDirName(dirEoMap.get(Long.valueOf((String)dirIds.get(dirIds.size() - 1))) != null ? ((DirEo)dirEoMap.get(Long.valueOf((String)dirIds.get(dirIds.size() - 1)))).getName() : null);
                itemEo.setProdClassCode(dirEoMap.get(Long.valueOf((String)dirIds.get(dirIds.size() - 1))) != null ? ((DirEo)dirEoMap.get(Long.valueOf((String)dirIds.get(dirIds.size() - 1)))).getCode() : null);
                itemEo.setProdClassName(dirEoMap.get(Long.valueOf((String)dirIds.get(dirIds.size() - 1))) != null ? ((DirEo)dirEoMap.get(Long.valueOf((String)dirIds.get(dirIds.size() - 1)))).getName() : null);
            }
            itemEo.setDirLevel(String.join((CharSequence)",", reqDto.getDirIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getDirPrefixIds())) {
            List dirPrefixIds = reqDto.getDirPrefixIds();
            if (dirPrefixIds.size() == 1) {
                dirEo = (DirEo)this.dirDas.selectByPrimaryKey(Long.valueOf((String)dirPrefixIds.get(0)));
                if (dirEo != null) {
                    itemEo.setDirPrefixId(dirEo.getId());
                    itemEo.setDirPrefixName(dirEo.getName());
                }
            } else if (dirPrefixIds.size() > 1 && !CollectionUtils.isEmpty(dirEoMap = (dirEos = this.dirDas.selectByIds(dirPrefixIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1)))) {
                itemEo.setDirPrefixId(dirEoMap.get(Long.valueOf((String)dirPrefixIds.get(dirPrefixIds.size() - 1))) != null ? ((DirEo)dirEoMap.get(Long.valueOf((String)dirPrefixIds.get(dirPrefixIds.size() - 1)))).getId() : null);
                itemEo.setDirPrefixName(dirEoMap.get(Long.valueOf((String)dirPrefixIds.get(dirPrefixIds.size() - 1))) != null ? ((DirEo)dirEoMap.get(Long.valueOf((String)dirPrefixIds.get(dirPrefixIds.size() - 1)))).getName() : null);
            }
            itemEo.setDirPrefixLevel(String.join((CharSequence)",", reqDto.getDirPrefixIds()));
        }
    }

    @Override
    public void importBumdlesItemsAndOnShelf(List<ItemBundlesExcelReqDto> excelReqDtoList) {
        this.logger.info("\u7ec4\u5408\u5546\u54c1\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(excelReqDtoList));
        List<ItemBundlesReqDto> bundlesReqDtos = this.dealBundlesExcelData(excelReqDtoList);
        List<ItemExtendOnShelfReqDto> extendOnShelfReqDtos = this.saveBatchBundlesItem(bundlesReqDtos);
        this.logger.info("extendOnShelfReqDtos\uff1a{}", (Object)JSON.toJSONString(extendOnShelfReqDtos));
        this.batchOnShelfItem(extendOnShelfReqDtos);
    }

    private void checkItemCode(String itemCode) {
        if (StringUtils.isBlank((CharSequence)itemCode)) {
            throw new BizException("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String pattern = "^[0-9A-Z]{1,64}";
        boolean isMatch = Pattern.matches(pattern, itemCode);
        if (!isMatch) {
            throw new BizException("\u8bf7\u6b63\u786e\u8f93\u5165\u5546\u54c1\u7f16\u7801\uff0c\u6700\u5927\u652f\u630164\u4f4d\u6570\u5b57\u6216\u5927\u5199\u5b57\u6bcd\u3002");
        }
        List itemEos = ((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"code", (Object)itemCode)).list();
        if (CollectionUtil.isNotEmpty((Collection)itemEos)) {
            throw new BizException("\u5546\u54c1\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002");
        }
    }

    private void assembleItemBundlesRespDto(ItemBundlesRespDto respDto, ItemEo itemEo) {
        BeanUtils.copyProperties((Object)itemEo, (Object)respDto);
        respDto.setId(itemEo.getId());
        respDto.setItemId(itemEo.getId());
        respDto.setItemCode(itemEo.getCode());
        respDto.setItemName(itemEo.getName());
        respDto.setDirId(itemEo.getDirId());
        DirEo dirEo = (DirEo)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"id", (Object)itemEo.getDirId())).one();
        respDto.setDirName(dirEo != null ? dirEo.getName() : null);
        respDto.setDirPrefixId(itemEo.getDirPrefixId());
        DirEo dirPrefixEo = (DirEo)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"id", (Object)itemEo.getDirPrefixId())).one();
        respDto.setDirPrefixName(dirPrefixEo != null ? dirPrefixEo.getName() : null);
        respDto.setDomesticB2b(itemEo.getDomesticB2b());
        respDto.setInternalB2b(itemEo.getInternalB2b());
        respDto.setSpecContent(itemEo.getSpecContent());
        respDto.setBrief(itemEo.getBrief());
        respDto.setDirIds(StringUtils.isNotBlank((CharSequence)itemEo.getDirLevel()) ? Arrays.asList(itemEo.getDirLevel().split(",")) : null);
        respDto.setDirPrefixIds(StringUtils.isNotBlank((CharSequence)itemEo.getDirPrefixLevel()) ? Arrays.asList(itemEo.getDirPrefixLevel().split(",")) : null);
        if (StringUtils.isNotBlank((CharSequence)itemEo.getSaleGroup())) {
            respDto.setSaleGroup(itemEo.getSaleGroup());
        }
        respDto.setProdLargeClass(itemEo.getProdLargeClass());
        ArrayList mediasRespDtos = new ArrayList();
        List mediasEos = ((ExtQueryChainWrapper)this.itemMediasDas.filter().eq((Object)"item_id", (Object)itemEo.getId())).list();
        CubeBeanUtils.copyCollection(mediasRespDtos, (Collection)mediasEos, ItemMediasRespDto.class);
        respDto.setMedias(mediasRespDtos);
        ArrayList bundleReqDtos = new ArrayList();
        List bundleEos = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().eq((Object)"item_id", (Object)itemEo.getId())).list();
        CubeBeanUtils.copyCollection(bundleReqDtos, (Collection)bundleEos, RItemBundleRespDto.class);
        bundleReqDtos.stream().forEach(o -> {
            List<ItemBundlesSupplyPriceRespDto> supplyPriceRespDtos = this.irItemRundleSupplyPriceService.queryBySubItemId(o.getSubItemCode(), itemEo.getCode());
            o.setSupplyPriceList(supplyPriceRespDtos);
        });
        respDto.setBundleReqDtos(bundleReqDtos);
    }

    private Long getId() {
        return IdGenrator.getDistributedId();
    }

    private List<ItemBundlesReqDto> dealBundlesExcelData(List<ItemBundlesExcelReqDto> excelReqDtoList) {
        int i;
        ArrayList bundlesReqDtos = Lists.newArrayList();
        HashMap composeItem = new HashMap(16);
        ArrayList composeItemList = Lists.newArrayList();
        HashMap subItem = new HashMap(16);
        ArrayList subItemList = Lists.newArrayList();
        excelReqDtoList.forEach(v -> {
            String randId;
            String itemCode = v.getItemCode();
            if (composeItem.get(itemCode) == null) {
                HashMap<String, Object> compose = new HashMap<String, Object>(16);
                compose.put("itemCode", itemCode);
                compose.put("itemName", v.getItemName());
                compose.put("dirId", v.getDirId());
                compose.put("dirName", v.getDirName());
                composeItemList.add(compose);
                composeItem.put(itemCode, composeItemList);
            }
            if (subItem.get(randId = String.valueOf(this.getId())) == null) {
                HashMap<String, Object> sub = new HashMap<String, Object>(16);
                sub.put("itemCode", itemCode);
                sub.put("randId", randId);
                sub.put("subItemCode", v.getSubItemCode());
                sub.put("subItemName", v.getSubItemName());
                sub.put("subItemId", v.getSubItemId());
                sub.put("subSkuId", v.getSubSkuId());
                sub.put("num", v.getNum());
                subItemList.add(sub);
                subItem.put(randId, subItemList);
            }
        });
        ArrayList<Map> result = new ArrayList<Map>();
        for (i = 0; i < composeItemList.size(); ++i) {
            Map parent = (Map)composeItemList.get(i);
            ArrayList<Map> children = new ArrayList<Map>();
            for (int j = 0; j < subItemList.size(); ++j) {
                Map child = (Map)subItemList.get(j);
                if (!Convert.toStr(parent.get("itemCode")).equals(Convert.toStr(child.get("itemCode")))) continue;
                child.remove("itemCode");
                child.remove("randId");
                children.add(child);
            }
            parent.put("bundleReqDtos", children);
            result.add(parent);
        }
        this.logger.info("\u6570\u636e\u8f6c\u6362\u7ed3\u679creulst\uff1a{}", (Object)JSON.toJSONString(result));
        if (!CollectionUtils.isEmpty(result)) {
            for (i = 0; i < result.size(); ++i) {
                Map map = (Map)result.get(i);
                ItemBundlesReqDto reqDto = (ItemBundlesReqDto)JSON.parseObject((String)JSON.toJSONString((Object)map), ItemBundlesReqDto.class);
                List reqDtoList = JSONArray.parseArray((String)JSON.toJSONString(map.get("bundleReqDtos")), RItemBundleReqDto.class);
                reqDto.setBundleReqDtos(reqDtoList);
                bundlesReqDtos.add(reqDto);
            }
        }
        this.logger.info("bundlesReqDtos\uff1a{}", (Object)JSON.toJSONString((Object)bundlesReqDtos));
        return bundlesReqDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ItemExtendOnShelfReqDto> saveBatchBundlesItem(List<ItemBundlesReqDto> reqDtoList) {
        ArrayList extendOnShelfReqDtos = Lists.newArrayList();
        DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(this.FRONT_CATEGORY_ID);
        ArrayList itemEoList = Lists.newArrayList();
        ArrayList itemSkuEoList = Lists.newArrayList();
        ArrayList rItemBundleEoList = Lists.newArrayList();
        reqDtoList.forEach(v -> {
            ItemExtendOnShelfReqDto onShelfReqDto = new ItemExtendOnShelfReqDto();
            ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"code", (Object)v.getItemCode())).one();
            boolean flag = false;
            if (null == itemEo) {
                itemEo = ItemEo.newInstance();
                itemEo.setId(this.getId());
                flag = true;
            }
            itemEo.setCode(v.getItemCode());
            itemEo.setName(v.getItemName());
            itemEo.setDisplayName(v.getItemName());
            itemEo.setStatus(ItemStatus.PUBLISHED.getStatus());
            itemEo.setType(ItemType.COMB_ITEM.getStatus());
            itemEo.setBusType(BusType.COMMON_ITEM.getCode());
            List parentCategory = JSON.parseArray((String)JSON.toJSONString((Object)this.itemExtShelfDas.queryParentCategorys(this.FRONT_CATEGORY_ID)), DirCategoryRespDto.class);
            List prefixIds = parentCategory.stream().map(DirCategoryRespDto::getId).distinct().collect(Collectors.toList()).stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
            Collections.reverse(prefixIds);
            itemEo.setDirPrefixId(this.FRONT_CATEGORY_ID);
            itemEo.setDirPrefixName(dirEo != null ? dirEo.getName() : null);
            itemEo.setDirPrefixLevel(String.join((CharSequence)",", prefixIds));
            itemEo.setShopId(ItemConstant.SHOP_ID);
            if (!flag) {
                this.itemDas.updateSelective((BaseEo)itemEo);
            } else {
                itemEoList.add(itemEo);
            }
            ItemSkuEo itemSkuEo = (ItemSkuEo)((ExtQueryChainWrapper)this.itemSkuDas.filter().eq((Object)"code", (Object)v.getItemCode())).one();
            boolean skuFlag = false;
            if (null == itemSkuEo) {
                itemSkuEo = ItemSkuEo.newInstance();
                itemSkuEo.setId(this.getId());
                skuFlag = true;
            }
            itemSkuEo.setItemId(itemEo.getId());
            itemSkuEo.setCode(v.getItemCode());
            itemSkuEo.setName(v.getItemName());
            itemSkuEo.setAttr(JSON.toJSONString((Object)itemEo));
            itemSkuEo.setAdvanceSale(Status.ADVANCE_SALE.getCode());
            if (!skuFlag) {
                this.itemSkuDas.updateSelective((BaseEo)itemSkuEo);
            } else {
                itemSkuEoList.add(itemSkuEo);
            }
            RItemBundleEo rItemBundleEo = new RItemBundleEo();
            rItemBundleEo.setItemId(itemEo.getId());
            this.rItemBundleDas.delete((BaseEo)rItemBundleEo);
            ArrayList bundleEos = new ArrayList();
            CubeBeanUtils.copyCollection(bundleEos, (Collection)v.getBundleReqDtos(), RItemBundleEo.class);
            ItemEo finalItemEo = itemEo;
            ItemSkuEo finalItemSkuEo = itemSkuEo;
            bundleEos.forEach(i -> {
                i.setItemId(finalItemEo.getId());
                i.setSkuId(finalItemSkuEo.getId());
            });
            rItemBundleEoList.addAll(bundleEos);
            onShelfReqDto.setDirPrefixId(dirEo != null ? dirEo.getId() : this.FRONT_CATEGORY_ID);
            onShelfReqDto.setItemId(itemEo.getId());
            onShelfReqDto.setSkuId(itemSkuEo.getId());
            onShelfReqDto.setItemCode(v.getItemCode());
            extendOnShelfReqDtos.add(onShelfReqDto);
        });
        if (!CollectionUtils.isEmpty((Collection)itemEoList)) {
            this.itemDas.insertBatch((List)itemEoList);
            this.itemSkuDas.insertBatch((List)itemSkuEoList);
        }
        this.rItemBundleDas.insertBatch((List)rItemBundleEoList);
        this.cacheService.delCacheByPattern("item_trade_", "*");
        return extendOnShelfReqDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveShelfRecord(List<ItemExtendOnShelfReqDto> onShelfReqDtos) {
        ArrayList lists = new ArrayList();
        onShelfReqDtos.forEach(v -> ItemConstant.SHELF_ADDRESS.forEach(i -> {
            ItemShelfReqDto itemShelfReqDto = new ItemShelfReqDto();
            itemShelfReqDto.setType(ShelfTypeEnum.NORMAL.getType());
            itemShelfReqDto.setBusType(BusType.COMMON_ITEM.getCode());
            itemShelfReqDto.setItemId(v.getItemId());
            itemShelfReqDto.setItemType(ItemTypeEnum.BUNDLE.getType());
            itemShelfReqDto.setShopId(ItemConstant.SHOP_ID);
            itemShelfReqDto.setSellerId(ItemConstant.SELLER_ID);
            itemShelfReqDto.setShelfAddress(i);
            itemShelfReqDto.setSkuId(v.getSkuId());
            lists.add(itemShelfReqDto);
        }));
        ArrayList shelfReqDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)shelfReqDtos, lists, ShelfReqDto.class);
        this.saveShelf(shelfReqDtos, ItemStatus.OFF_SHELF.getStatus());
        List<Long> ids = onShelfReqDtos.stream().map(ItemExtendOnShelfReqDto::getItemId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(ids)) {
            ids.forEach(v -> {
                ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"id", v)).one();
                itemEo.setShopId(ItemConstant.SHOP_ID);
                itemEo.setStatus(ItemStatus.OFF_SHELF.getStatus());
                this.itemDas.updateSelective((BaseEo)itemEo);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ShelfEo> saveShelf(List<ShelfReqDto> shelfReqDtos, Integer itemStatus) {
        Map<String, ShelfReqDto> shelfMap = shelfReqDtos.stream().collect(Collectors.toMap(shelfReqDto -> shelfReqDto.getShopId() + shelfReqDto.getItemId() + shelfReqDto.getSkuId().toString() + shelfReqDto.getShelfAddress(), e -> e, (e1, e2) -> e1));
        ArrayList<ShelfEo> shelfEoList = new ArrayList<ShelfEo>();
        Date shelfTime = new Date();
        shelfMap.forEach((k, shelfReqDto) -> {
            ShelfEo shelfQuery = new ShelfEo();
            ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"id", (Object)shelfReqDto.getItemId())).one();
            shelfQuery.setItemId(shelfReqDto.getItemId());
            shelfQuery.setSkuId(shelfReqDto.getSkuId());
            shelfQuery.setFreightTemplateId(shelfReqDto.getFreightTemplateId());
            shelfQuery.setShopId(shelfReqDto.getShopId());
            shelfQuery.setInstanceId(itemEo.getInstanceId());
            shelfQuery.setTenantId(itemEo.getTenantId());
            shelfQuery.setSellerId(shelfReqDto.getSellerId());
            shelfQuery.setDistribution(shelfReqDto.getDistribution());
            shelfQuery.setItemType(shelfReqDto.getItemType());
            shelfQuery.setBusType(shelfReqDto.getBusType());
            shelfQuery.setPointsDeduction(shelfReqDto.getPointsDeduction());
            shelfQuery.setOrganizationId(shelfReqDto.getOrganizationId());
            shelfQuery.setOrganizationName(shelfReqDto.getOrganizationName());
            shelfQuery.setShelfTime(shelfTime);
            shelfQuery.setStatus(itemStatus);
            shelfQuery.setType(shelfReqDto.getType());
            shelfQuery.setVersionId(itemEo.getVersion());
            shelfQuery.setShelfAddress(shelfReqDto.getShelfAddress());
            shelfEoList.add(shelfQuery);
        });
        if (!CollectionUtils.isEmpty(shelfEoList)) {
            this.shelfDas.insertBatch(shelfEoList);
        }
        return shelfEoList;
    }
}

