/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.util;

import com.dtyunxi.yundt.cube.center.item.api.constants.LengthUnitEnum;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LengthUnitUtils {
    private static Logger logger = LoggerFactory.getLogger(LengthUnitUtils.class);

    public static BigDecimal totalVolume(BigDecimal length, BigDecimal wide, BigDecimal high, String unit) {
        return LengthUnitUtils.totalVolume(length, wide, high, unit, LengthUnitEnum.M.getUnit());
    }

    public static BigDecimal totalVolume(BigDecimal length, BigDecimal wide, BigDecimal high, String unit, String toUnit) {
        logger.info("\u5355\u4f4d\u8f6c\u6362 length = {}, wide = {},high = {},unit = {},toUnit = {}", new Object[]{length, wide, high, unit, toUnit});
        if (null == length || length.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        if (null == wide || wide.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        if (null == high || high.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        LengthUnitEnum unitEnum = LengthUnitEnum.getEnumByUnit((String)unit);
        if (null == unitEnum) {
            return BigDecimal.ZERO;
        }
        LengthUnitEnum toUnitEnum = LengthUnitEnum.getEnumByUnit((String)toUnit);
        if (null == toUnitEnum) {
            return BigDecimal.ZERO;
        }
        BigDecimal it = length.multiply(unitEnum.getConversionNum()).multiply(wide).multiply(unitEnum.getConversionNum()).multiply(high).multiply(unitEnum.getConversionNum()).divide(unitEnum.getBaseNum(), 10, 6);
        BigDecimal toIt = toUnitEnum.getConversionNum().divide(toUnitEnum.getBaseNum(), 10, 6);
        BigDecimal totalVolume = it.divide(toIt, 10, 6).setScale(10, 1);
        logger.info("\u5355\u4f4d\u8f6c\u6362 totalVolume = {}", (Object)totalVolume);
        return totalVolume;
    }

    public static BigDecimal length(BigDecimal length, String unit, String toUnit) {
        if (null == length || length.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        LengthUnitEnum unitEnum = LengthUnitEnum.getUnit((String)unit);
        if (null == unitEnum) {
            return BigDecimal.ZERO;
        }
        LengthUnitEnum toUnitEnum = LengthUnitEnum.getUnit((String)toUnit);
        if (null == toUnitEnum) {
            return BigDecimal.ZERO;
        }
        BigDecimal it = length.multiply(unitEnum.getConversionNum()).divide(unitEnum.getBaseNum(), 6, 6);
        return it;
    }

    public static void main(String[] args) {
        BigDecimal totalVolume = LengthUnitUtils.length(new BigDecimal(2), "MM", "CM");
        System.out.println(totalVolume);
    }
}

