/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemExtExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.AccountingCategoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.DirCategoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.DirCategoryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemCategoryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemSapFrontlClassDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemSapMaterialClassDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryItemService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemCategoryService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirIndexDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.CategoryAttributesDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.CategoryAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class IItemCategoryServiceImpl
implements IItemCategoryService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private DirIndexDas dirIndexDas;
    @Resource
    private DirDas dirDas;
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemExtShelfDas extShelfDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private CategoryAttributesDas categoryAttributesDas;
    @Value(value="${item.dir.parentId:1230317884640037892}")
    private Long PARENT_ID;
    @Value(value="${item.dir.frontParentId:1230318625350978670}")
    private Long FRONT_PARENT_ID;
    @Resource
    private IDirectoryItemService directoryItemService;
    @Resource
    private ICacheService cacheService;
    private List<Long> parentIds = new ArrayList<Long>();
    private List<Long> childrenIds = new ArrayList<Long>();

    @Override
    public List<ItemCategoryRespDto> getCategoryList() {
        ArrayList<ItemCategoryRespDto> categoryRespDtoList = new ArrayList<ItemCategoryRespDto>();
        DirItemRelationEo relationEo = new DirItemRelationEo();
        relationEo.setStatus(ItemStatus.ON_LINE.getStatus());
        List dirItemRelationEos = this.dirItemRelationDas.select((BaseEo)relationEo);
        if (CollectionUtils.isEmpty((Collection)dirItemRelationEos)) {
            return categoryRespDtoList;
        }
        List dirIds = dirItemRelationEos.stream().map(StdDirItemRelationEo::getDirId).collect(Collectors.toList());
        List itemIds = dirItemRelationEos.stream().map(StdDirItemRelationEo::getItemId).collect(Collectors.toList());
        List dirEos = this.dirDas.selectByIds(dirIds);
        Map dirMap = dirEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k2));
        List itemEos = this.itemDas.selectByIds(itemIds);
        Map itemEoMap = itemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k2));
        dirItemRelationEos.stream().forEach(v -> {
            ItemCategoryRespDto respDto = new ItemCategoryRespDto();
            respDto.setId(v.getId());
            respDto.setDirId(v.getDirId());
            respDto.setCode(((DirEo)dirMap.get(v.getDirId())).getCode());
            respDto.setName(((DirEo)dirMap.get(v.getDirId())).getName());
            respDto.setItemId(v.getItemId());
            respDto.setItemCode(((ItemEo)itemEoMap.get(v.getItemId())).getCode());
            respDto.setItemName(((ItemEo)itemEoMap.get(v.getItemId())).getName());
            categoryRespDtoList.add(respDto);
        });
        if (!CollectionUtils.isEmpty(categoryRespDtoList)) {
            categoryRespDtoList.stream().forEach(v -> {
                ItemCategoryRespDto respDto = new ItemCategoryRespDto();
                respDto.setId(v.getId());
                respDto.setDirId(v.getDirId());
                respDto.setCode(v.getCode());
                respDto.setName(v.getName());
            });
        }
        return categoryRespDtoList;
    }

    @Override
    public DirectoryItemRespDto queryDirectoryByCode(String code) {
        ExtQueryChainWrapper sqlFilters = this.dirDas.filter();
        sqlFilters.eq((Object)"code", (Object)code);
        DirEo dirEo = (DirEo)sqlFilters.one();
        DirectoryItemRespDto directoryItemRespDto = new DirectoryItemRespDto();
        DtoHelper.eo2Dto((BaseEo)dirEo, (BaseVo)directoryItemRespDto);
        return directoryItemRespDto;
    }

    @Override
    public PageInfo<ItemRespDto> getItemByDirCategory(DirCategoryReqDto reqDto) {
        PageInfo dtoPageInfo = new PageInfo();
        ArrayList dirIds = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)reqDto.getDirIds())) {
            return dtoPageInfo;
        }
        reqDto.getDirIds().stream().forEach(v -> {
            List<DirCategoryRespDto> respDtos = this.queryParentAndChildCategorys(Long.valueOf(v));
            if (!CollectionUtils.isEmpty(respDtos)) {
                dirIds.addAll(respDtos.stream().map(DirCategoryRespDto::getId).collect(Collectors.toList()));
            }
        });
        if (!CollectionUtils.isEmpty((Collection)dirIds)) {
            ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.itemDas.filter().orderByDesc((Object)"update_time");
            sqlFilters.in((Object)"dir_id", (Collection)dirIds);
            if (StringUtils.isNotBlank((CharSequence)reqDto.getItemCode())) {
                sqlFilters.in((Object)"code", new Object[]{reqDto.getItemCode()});
            }
            if (StringUtils.isNotBlank((CharSequence)reqDto.getItemName())) {
                sqlFilters.like((Object)"name", (Object)("%" + reqDto.getItemName() + "%"));
            }
            PageInfo eoPageInfo = sqlFilters.page(reqDto.getPageNum(), reqDto.getPageSize());
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList dtoList = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemRespDto.class);
            if (CollectionUtils.isEmpty(dtoList)) {
                return dtoPageInfo;
            }
            List itemIds = dtoList.stream().map(ItemRespDto::getId).collect(Collectors.toList());
            List skuEoList = ((ExtQueryChainWrapper)this.itemSkuDas.filter().in((Object)"item_id", itemIds)).list();
            Map<Long, List<ItemSkuEo>> skuEoMap = null;
            if (!CollectionUtils.isEmpty((Collection)skuEoList)) {
                skuEoMap = skuEoList.stream().collect(Collectors.groupingBy(StdItemSkuEo::getItemId));
            }
            Map<Long, List<ItemSkuEo>> finalSkuEoMap = skuEoMap;
            dtoList.stream().forEach(v -> {
                v.setItemName(v.getName());
                v.setItemCode(v.getCode());
                v.setItemId(v.getId());
                ArrayList skuRespDtos = new ArrayList();
                if (!CollectionUtils.isEmpty((Map)finalSkuEoMap)) {
                    List skuEos = (List)finalSkuEoMap.get(v.getId());
                    CubeBeanUtils.copyCollection(skuRespDtos, (Collection)skuEos, ItemSkuRespDto.class);
                    v.setItemSkuList(skuRespDtos);
                }
            });
            dtoPageInfo.setList(dtoList);
        }
        return dtoPageInfo;
    }

    @Override
    public List<ItemRespDto> getBackDirCategory(DirCategoryReqDto reqDto) {
        if (CollectionUtils.isEmpty((Collection)reqDto.getDirIds())) {
            throw new BizException(ItemExtExceptionCode.ITEM_DIR_COLLECTION_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DIR_COLLECTION_NOT_EXIST.getMsg());
        }
        ArrayList<ItemRespDto> dtoList = new ArrayList<ItemRespDto>();
        ArrayList dirIds = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)reqDto.getDirIds())) {
            return dtoList;
        }
        String cachKey = "item_" + String.join((CharSequence)"-", reqDto.getDirIds());
        List itemRespDtoList = (List)this.cacheService.getCache("item_", cachKey, (TypeReference)new TypeReference<List<ItemRespDto>>(){});
        if (!CollectionUtils.isEmpty((Collection)itemRespDtoList)) {
            return itemRespDtoList;
        }
        reqDto.getDirIds().stream().forEach(v -> {
            List<DirCategoryRespDto> respDtos = this.queryParentAndChildCategorys(Long.valueOf(v));
            if (!CollectionUtils.isEmpty(respDtos)) {
                dirIds.addAll(respDtos.stream().map(DirCategoryRespDto::getId).collect(Collectors.toList()));
            }
        });
        if (!CollectionUtils.isEmpty((Collection)dirIds)) {
            ItemEo itemEo = new ItemEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"dir_id", (Object)dirIds));
            itemEo.setSqlFilters(sqlFilters);
            itemEo.setOrderByDesc("update_time");
            List itemEoList = this.itemDas.select((BaseEo)itemEo);
            CubeBeanUtils.copyCollection(dtoList, (Collection)itemEoList, ItemRespDto.class);
            Map<Long, List<ItemSkuEo>> skuEoMap = null;
            if (!CollectionUtils.isEmpty(dtoList)) {
                List itemIds = dtoList.stream().map(ItemRespDto::getId).collect(Collectors.toList());
                List skuEoList = ((ExtQueryChainWrapper)this.itemSkuDas.filter().in((Object)"item_id", itemIds)).list();
                if (!CollectionUtils.isEmpty((Collection)skuEoList)) {
                    skuEoMap = skuEoList.stream().collect(Collectors.groupingBy(StdItemSkuEo::getItemId));
                }
            }
            Map<Long, List<ItemSkuEo>> finalSkuEoMap = skuEoMap;
            dtoList.stream().forEach(v -> {
                v.setItemName(v.getName());
                v.setItemCode(v.getCode());
                v.setItemId(v.getId());
                ArrayList skuRespDtos = new ArrayList();
                if (!CollectionUtils.isEmpty((Map)finalSkuEoMap)) {
                    List skuEos = (List)finalSkuEoMap.get(v.getId());
                    CubeBeanUtils.copyCollection(skuRespDtos, (Collection)skuEos, ItemSkuRespDto.class);
                    v.setItemSkuList(skuRespDtos);
                }
            });
            if (!CollectionUtils.isEmpty(dtoList)) {
                this.cacheService.setCache("item_", cachKey, dtoList);
            }
        }
        return dtoList;
    }

    @Override
    public PageInfo<ItemRespDto> getItemByFrontCategory(DirCategoryReqDto reqDto) {
        PageInfo dtoPageInfo = new PageInfo();
        ArrayList dirPrefixIds = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)reqDto.getDirIds())) {
            return dtoPageInfo;
        }
        reqDto.getDirIds().stream().forEach(v -> {
            List<DirCategoryRespDto> respDtos = this.queryParentAndChildCategorys(Long.valueOf(v));
            if (!CollectionUtils.isEmpty(respDtos)) {
                dirPrefixIds.addAll(respDtos.stream().map(DirCategoryRespDto::getId).collect(Collectors.toList()));
            }
        });
        if (!CollectionUtils.isEmpty((Collection)dirPrefixIds)) {
            ItemEo itemEo = new ItemEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"dir_prefix_id", (Object)dirPrefixIds));
            itemEo.setSqlFilters(sqlFilters);
            itemEo.setOrderByDesc("update_time");
            PageInfo eoPageInfo = this.itemDas.selectPage((BaseEo)itemEo, reqDto.getPageNum(), reqDto.getPageSize());
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList dtoList = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemRespDto.class);
            if (CollectionUtils.isEmpty(dtoList)) {
                return dtoPageInfo;
            }
            dtoList.stream().forEach(v -> {
                v.setItemName(v.getName());
                v.setItemCode(v.getCode());
                v.setItemId(v.getId());
                ArrayList skuRespDtos = new ArrayList();
                List skuEoList = this.itemSkuDas.selectByItemId(v.getId());
                CubeBeanUtils.copyCollection(skuRespDtos, (Collection)skuEoList, ItemSkuRespDto.class);
                v.setItemSkuList(skuRespDtos);
            });
            dtoPageInfo.setList(dtoList);
        }
        return dtoPageInfo;
    }

    private List<DirCategoryRespDto> queryParentAndChildCategorys(Long id) {
        List childList;
        ArrayList respDtos = new ArrayList();
        List parentList = this.extShelfDas.queryParentCategorys(id);
        if (!CollectionUtils.isEmpty((Collection)parentList)) {
            ArrayList parentCategory = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)parentCategory, (Collection)parentList, DirCategoryRespDto.class);
            respDtos.addAll(parentCategory);
        }
        if (!CollectionUtils.isEmpty((Collection)(childList = this.extShelfDas.queryChildCategorys(id)))) {
            ArrayList childCategory = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)childCategory, (Collection)childList, DirCategoryRespDto.class);
            respDtos.addAll(childCategory);
        }
        List result = respDtos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DirCategoryRespDto>(Comparator.comparing(DirCategoryRespDto::getCode))), ArrayList::new));
        return result;
    }

    @Override
    public PageInfo<ItemRespDto> queryItemByDirCategoryId(Long id, Integer pageNum, Integer pageSize) {
        PageInfo dtoPageInfo = new PageInfo();
        List<Long> dirIds = this.getDirCategory(id);
        ItemEo itemEo = new ItemEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"dir_id", dirIds));
        itemEo.setSqlFilters(sqlFilters);
        itemEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.itemDas.selectPage((BaseEo)itemEo, pageNum, pageSize);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemRespDto.class);
        if (CollectionUtils.isEmpty(dtoList)) {
            return dtoPageInfo;
        }
        List itemIds = dtoList.stream().map(ItemRespDto::getId).collect(Collectors.toList());
        List skuEoList = this.itemSkuDas.selectByItemIds(itemIds);
        Map<Long, List<ItemSkuEo>> skuEoMap = null;
        if (!CollectionUtils.isEmpty((Collection)skuEoList)) {
            skuEoMap = skuEoList.stream().collect(Collectors.groupingBy(StdItemSkuEo::getItemId));
        }
        Map<Long, List<ItemSkuEo>> finalSkuEoMap = skuEoMap;
        dtoList.stream().forEach(v -> {
            v.setItemName(v.getName());
            v.setItemCode(v.getCode());
            v.setItemId(v.getId());
            if (!CollectionUtils.isEmpty((Map)finalSkuEoMap)) {
                List skuEos = (List)finalSkuEoMap.get(v.getId());
                ArrayList skuRespDtos = new ArrayList();
                CubeBeanUtils.copyCollection(skuRespDtos, (Collection)skuEos, ItemSkuRespDto.class);
                v.setItemSkuList(skuRespDtos);
            }
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void materialClassSync(List<ItemSapMaterialClassDto> materialClassDtos) {
        Long parentId = this.PARENT_ID;
        if (CollectionUtils.isEmpty(materialClassDtos)) {
            return;
        }
        Integer count = 0;
        DirEo parent = (DirEo)this.dirDas.selectByPrimaryKey(parentId);
        for (ItemSapMaterialClassDto v : materialClassDtos) {
            DirEo oneEo = new DirEo();
            oneEo.setRootId(parentId);
            oneEo.setParentId(parentId);
            oneEo.setCode(v.getProdOneClass());
            oneEo.setName(v.getProdOneClassName());
            oneEo.setLv(parent.getRv());
            oneEo.setRv(Integer.valueOf(parent.getRv() + 1));
            oneEo.setStatus(Integer.valueOf(1));
            oneEo.setInstanceId(parent.getInstanceId());
            oneEo.setTenantId(parent.getTenantId());
            DirEo parentEo = new DirEo();
            parentEo.setParentId(parent.getParentId());
            parentEo.setInstanceId(parent.getInstanceId());
            parentEo.setTenantId(parent.getTenantId());
            oneEo.setSort(Integer.valueOf(this.dirDas.count((BaseEo)parent)));
            this.dirDas.insert((BaseEo)oneEo);
            for (ItemSapMaterialClassDto.TwoList e : v.getTwoList()) {
                DirEo twoEo = new DirEo();
                twoEo.setRootId(parentId);
                twoEo.setParentId(oneEo.getId());
                twoEo.setCode(e.getProdTwoClass());
                twoEo.setName(e.getProdTwoClassName());
                twoEo.setLv(oneEo.getRv());
                twoEo.setRv(Integer.valueOf(oneEo.getRv() + 1));
                twoEo.setStatus(Integer.valueOf(1));
                twoEo.setInstanceId(parent.getInstanceId());
                twoEo.setTenantId(parent.getTenantId());
                DirEo parentTwoEo = new DirEo();
                parentTwoEo.setParentId(parent.getParentId());
                parentTwoEo.setInstanceId(parent.getInstanceId());
                parentTwoEo.setTenantId(parent.getTenantId());
                twoEo.setSort(Integer.valueOf(this.dirDas.count((BaseEo)parentTwoEo)));
                this.dirDas.insert((BaseEo)twoEo);
                for (ItemSapMaterialClassDto.TwoList.ThirdList i : e.getThirdList()) {
                    DirEo thirdEo = new DirEo();
                    thirdEo.setRootId(parentId);
                    thirdEo.setParentId(twoEo.getId());
                    thirdEo.setCode(i.getProdThirdClass());
                    thirdEo.setName(i.getProdThirdClassName());
                    thirdEo.setLv(twoEo.getRv());
                    thirdEo.setRv(Integer.valueOf(twoEo.getRv() + 1));
                    thirdEo.setStatus(Integer.valueOf(1));
                    thirdEo.setInstanceId(parent.getInstanceId());
                    thirdEo.setTenantId(parent.getTenantId());
                    DirEo parentThirdEo = new DirEo();
                    parentThirdEo.setParentId(parent.getParentId());
                    parentThirdEo.setInstanceId(parent.getInstanceId());
                    parentThirdEo.setTenantId(parent.getTenantId());
                    thirdEo.setSort(Integer.valueOf(this.dirDas.count((BaseEo)parentThirdEo)));
                    this.dirDas.insert((BaseEo)thirdEo);
                    for (ItemSapMaterialClassDto.TwoList.ThirdList.ProdList k : i.getProdList()) {
                        DirEo prodEo = new DirEo();
                        prodEo.setRootId(parentId);
                        prodEo.setParentId(thirdEo.getId());
                        prodEo.setCode(k.getProdClassCode());
                        prodEo.setName(k.getProdClassName());
                        prodEo.setLv(thirdEo.getRv());
                        prodEo.setRv(Integer.valueOf(thirdEo.getRv() + 1));
                        prodEo.setStatus(Integer.valueOf(1));
                        prodEo.setInstanceId(parent.getInstanceId());
                        prodEo.setTenantId(parent.getTenantId());
                        DirEo parentProdEo = new DirEo();
                        parentProdEo.setParentId(parent.getParentId());
                        parentProdEo.setInstanceId(parent.getInstanceId());
                        parentProdEo.setTenantId(parent.getTenantId());
                        prodEo.setSort(Integer.valueOf(this.dirDas.count((BaseEo)parentProdEo)));
                        this.dirDas.insert((BaseEo)prodEo);
                        Integer n = count;
                        Integer n2 = count = Integer.valueOf(count + 1);
                    }
                }
            }
        }
        parent.setRv(Integer.valueOf(parent.getRv() + count));
        this.dirDas.updateSelective((BaseEo)parent);
    }

    @Override
    public void syncDirFrontClass(List<ItemSapFrontlClassDto> frontlClassDtos) {
        this.logger.info("SAP\u540c\u6b65\u7684\u76ee\u5f55\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(frontlClassDtos));
        Long frontParentId = this.FRONT_PARENT_ID;
        if (frontParentId == null) {
            throw new BizException(ItemExtExceptionCode.ITEM_DIR_PARENT_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DIR_PARENT_NOT_EXIST.getMsg());
        }
        if (CollectionUtils.isEmpty(frontlClassDtos)) {
            throw new BizException(ItemExtExceptionCode.ITEM_DIR_COLLECTION_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DIR_COLLECTION_NOT_EXIST.getMsg());
        }
        DirEo parent = (DirEo)this.dirDas.selectByPrimaryKey(frontParentId);
        if (null == parent) {
            throw new BizException(ItemExtExceptionCode.ITEM_DIR_PARENT_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DIR_PARENT_NOT_EXIST.getMsg());
        }
        frontlClassDtos.forEach(v -> {
            DirEo oneEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)v.getProdOneClass())).eq((Object)"root_id", (Object)frontParentId)).one();
            if (Objects.nonNull(oneEo)) {
                oneEo.setName(v.getProdOneClassName());
                this.dirDas.updateSelective((BaseEo)oneEo);
                v.getTwoList().forEach(e -> {
                    DirEo twoEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)e.getProdTwoClass())).eq((Object)"root_id", (Object)frontParentId)).one();
                    if (Objects.nonNull(twoEo)) {
                        twoEo.setName(e.getProdTwoClassName());
                        this.dirDas.updateSelective((BaseEo)twoEo);
                        e.getThirdList().forEach(i -> {
                            DirEo thirdEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)i.getProdThirdClass())).eq((Object)"root_id", (Object)frontParentId)).one();
                            if (Objects.nonNull(thirdEo)) {
                                thirdEo.setName(i.getProdThirdClassName());
                                this.dirDas.updateSelective((BaseEo)thirdEo);
                            } else {
                                this.saveDirCategory(i.getProdThirdClass(), i.getProdThirdClassName(), twoEo.getId(), frontParentId, parent.getInstanceId(), parent.getTenantId());
                            }
                        });
                    } else {
                        Long twoId = this.saveDirCategory(e.getProdTwoClass(), e.getProdTwoClassName(), oneEo.getId(), frontParentId, parent.getInstanceId(), parent.getTenantId());
                        e.getThirdList().forEach(i -> {
                            DirEo thirdEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)i.getProdThirdClass())).eq((Object)"root_id", (Object)frontParentId)).one();
                            if (Objects.nonNull(thirdEo)) {
                                thirdEo.setName(i.getProdThirdClassName());
                                this.dirDas.updateSelective((BaseEo)thirdEo);
                            } else {
                                this.saveDirCategory(i.getProdThirdClass(), i.getProdThirdClassName(), twoId, frontParentId, parent.getInstanceId(), parent.getTenantId());
                            }
                        });
                    }
                });
            } else {
                Long oneId = this.saveDirCategory(v.getProdOneClass(), v.getProdOneClassName(), frontParentId, frontParentId, parent.getInstanceId(), parent.getTenantId());
                v.getTwoList().forEach(e -> {
                    DirEo twoEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)e.getProdTwoClass())).eq((Object)"root_id", (Object)frontParentId)).one();
                    if (Objects.nonNull(twoEo)) {
                        twoEo.setName(e.getProdTwoClassName());
                        this.dirDas.updateSelective((BaseEo)twoEo);
                        e.getThirdList().forEach(i -> {
                            DirEo thirdEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)i.getProdThirdClass())).eq((Object)"root_id", (Object)frontParentId)).one();
                            if (Objects.nonNull(thirdEo)) {
                                thirdEo.setName(i.getProdThirdClassName());
                                this.dirDas.updateSelective((BaseEo)thirdEo);
                            } else {
                                this.saveDirCategory(i.getProdThirdClass(), i.getProdThirdClassName(), twoEo.getId(), frontParentId, parent.getInstanceId(), parent.getTenantId());
                            }
                        });
                    } else {
                        Long twoId = this.saveDirCategory(e.getProdTwoClass(), e.getProdTwoClassName(), oneId, frontParentId, parent.getInstanceId(), parent.getTenantId());
                        e.getThirdList().forEach(i -> {
                            DirEo thirdEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)i.getProdThirdClass())).eq((Object)"root_id", (Object)frontParentId)).one();
                            if (Objects.nonNull(thirdEo)) {
                                thirdEo.setName(i.getProdThirdClassName());
                                this.dirDas.updateSelective((BaseEo)thirdEo);
                            } else {
                                this.saveDirCategory(i.getProdThirdClass(), i.getProdThirdClassName(), twoId, frontParentId, parent.getInstanceId(), parent.getTenantId());
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncDirCategoryClass(List<ItemSapMaterialClassDto> materialClassDtos) {
        this.logger.info("SAP\u540c\u6b65\u7684\u76ee\u5f55\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(materialClassDtos));
        Long parentId = this.PARENT_ID;
        if (parentId == null) {
            throw new BizException(ItemExtExceptionCode.ITEM_DIR_PARENT_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DIR_PARENT_NOT_EXIST.getMsg());
        }
        if (CollectionUtils.isEmpty(materialClassDtos)) {
            throw new BizException(ItemExtExceptionCode.ITEM_DIR_COLLECTION_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DIR_COLLECTION_NOT_EXIST.getMsg());
        }
        DirEo parent = (DirEo)this.dirDas.selectByPrimaryKey(parentId);
        if (null == parent) {
            throw new BizException(ItemExtExceptionCode.ITEM_DIR_PARENT_NOT_EXIST.getCode(), ItemExtExceptionCode.ITEM_DIR_PARENT_NOT_EXIST.getMsg());
        }
        HashSet<AccountingCategoryReqDto> categoryReqDtos = new HashSet<AccountingCategoryReqDto>();
        for (ItemSapMaterialClassDto v2 : materialClassDtos) {
            DirEo prodEo;
            Object thirdId;
            DirEo thirdEo;
            ItemSapMaterialClassDto.TwoList.ThirdList i;
            DirEo prodEo2;
            ItemSapMaterialClassDto.TwoList.ThirdList.ProdList k22;
            ItemSapMaterialClassDto.TwoList.ThirdList i22;
            DirEo oneEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)v2.getProdOneClass())).eq((Object)"root_id", (Object)parentId)).one();
            if (oneEo != null) {
                oneEo.setName(v2.getProdOneClassName());
                this.dirDas.updateSelective((BaseEo)oneEo);
                for (ItemSapMaterialClassDto.TwoList e : v2.getTwoList()) {
                    ItemSapMaterialClassDto.TwoList.ThirdList.ProdList k32;
                    DirEo twoEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)e.getProdTwoClass())).eq((Object)"root_id", (Object)parentId)).one();
                    if (twoEo != null) {
                        twoEo.setName(e.getProdTwoClassName());
                        this.dirDas.updateSelective((BaseEo)twoEo);
                        for (ItemSapMaterialClassDto.TwoList.ThirdList i22 : e.getThirdList()) {
                            categoryReqDtos.addAll(this.getAccountCategory(i22.getProdList()));
                            DirEo thirdEo2 = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)i22.getProdThirdClass())).eq((Object)"root_id", (Object)parentId)).one();
                            if (thirdEo2 != null) {
                                thirdEo2.setName(i22.getProdThirdClassName());
                                this.dirDas.updateSelective((BaseEo)thirdEo2);
                                for (ItemSapMaterialClassDto.TwoList.ThirdList.ProdList k32 : i22.getProdList()) {
                                    DirEo prodEo3 = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)k32.getProdClassCode())).eq((Object)"root_id", (Object)parentId)).one();
                                    if (prodEo3 != null) {
                                        prodEo3.setName(k32.getProdClassName());
                                        this.dirDas.updateSelective((BaseEo)prodEo3);
                                        continue;
                                    }
                                    this.saveDirCategory(k32.getProdClassCode(), k32.getProdClassName(), thirdEo2.getId(), parentId, parent.getInstanceId(), parent.getTenantId());
                                }
                                continue;
                            }
                            Long thirdId2 = this.saveDirCategory(i22.getProdThirdClass(), i22.getProdThirdClassName(), twoEo.getId(), parentId, parent.getInstanceId(), parent.getTenantId());
                            k32 = i22.getProdList().iterator();
                            while (k32.hasNext()) {
                                k22 = (ItemSapMaterialClassDto.TwoList.ThirdList.ProdList)k32.next();
                                prodEo2 = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)k22.getProdClassCode())).eq((Object)"root_id", (Object)parentId)).one();
                                if (prodEo2 != null) {
                                    prodEo2.setName(k22.getProdClassName());
                                    this.dirDas.updateSelective((BaseEo)prodEo2);
                                    continue;
                                }
                                this.saveDirCategory(k22.getProdClassCode(), k22.getProdClassName(), thirdId2, parentId, parent.getInstanceId(), parent.getTenantId());
                            }
                        }
                        continue;
                    }
                    Long twoId = this.saveDirCategory(e.getProdTwoClass(), e.getProdTwoClassName(), oneEo.getId(), parentId, parent.getInstanceId(), parent.getTenantId());
                    i22 = e.getThirdList().iterator();
                    while (i22.hasNext()) {
                        i = (ItemSapMaterialClassDto.TwoList.ThirdList)i22.next();
                        categoryReqDtos.addAll(this.getAccountCategory(i.getProdList()));
                        thirdEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)i.getProdThirdClass())).eq((Object)"root_id", (Object)parentId)).one();
                        if (thirdEo != null) {
                            thirdEo.setName(i.getProdThirdClassName());
                            this.dirDas.updateSelective((BaseEo)thirdEo);
                            k32 = i.getProdList().iterator();
                            while (k32.hasNext()) {
                                k22 = (ItemSapMaterialClassDto.TwoList.ThirdList.ProdList)k32.next();
                                prodEo2 = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)k22.getProdClassCode())).eq((Object)"root_id", (Object)parentId)).one();
                                if (prodEo2 != null) {
                                    prodEo2.setName(k22.getProdClassName());
                                    this.dirDas.updateSelective((BaseEo)prodEo2);
                                    continue;
                                }
                                this.saveDirCategory(k22.getProdClassCode(), k22.getProdClassName(), thirdEo.getId(), parentId, parent.getInstanceId(), parent.getTenantId());
                            }
                            continue;
                        }
                        thirdId = this.saveDirCategory(i.getProdThirdClass(), i.getProdThirdClassName(), twoId, parentId, parent.getInstanceId(), parent.getTenantId());
                        for (ItemSapMaterialClassDto.TwoList.ThirdList.ProdList k4 : i.getProdList()) {
                            prodEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)k4.getProdClassCode())).eq((Object)"root_id", (Object)parentId)).one();
                            if (prodEo != null) {
                                prodEo.setName(k4.getProdClassName());
                                this.dirDas.updateSelective((BaseEo)prodEo);
                                continue;
                            }
                            this.saveDirCategory(k4.getProdClassCode(), k4.getProdClassName(), (Long)thirdId, parentId, parent.getInstanceId(), parent.getTenantId());
                        }
                    }
                }
                continue;
            }
            Long oneId = this.saveDirCategory(v2.getProdOneClass(), v2.getProdOneClassName(), parentId, parentId, parent.getInstanceId(), parent.getTenantId());
            for (ItemSapMaterialClassDto.TwoList e : v2.getTwoList()) {
                ItemSapMaterialClassDto.TwoList.ThirdList.ProdList k4;
                DirEo twoEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)e.getProdTwoClass())).eq((Object)"root_id", (Object)parentId)).one();
                if (twoEo != null) {
                    twoEo.setName(e.getProdTwoClassName());
                    this.dirDas.updateSelective((BaseEo)twoEo);
                    i22 = e.getThirdList().iterator();
                    while (i22.hasNext()) {
                        i = (ItemSapMaterialClassDto.TwoList.ThirdList)i22.next();
                        categoryReqDtos.addAll(this.getAccountCategory(i.getProdList()));
                        thirdEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)i.getProdThirdClass())).eq((Object)"root_id", (Object)parentId)).one();
                        if (thirdEo != null) {
                            thirdEo.setName(i.getProdThirdClassName());
                            this.dirDas.updateSelective((BaseEo)thirdEo);
                            for (ItemSapMaterialClassDto.TwoList.ThirdList.ProdList k22 : i.getProdList()) {
                                prodEo2 = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)k22.getProdClassCode())).eq((Object)"root_id", (Object)parentId)).one();
                                if (prodEo2 != null) {
                                    prodEo2.setName(k22.getProdClassName());
                                    this.dirDas.updateSelective((BaseEo)prodEo2);
                                    continue;
                                }
                                this.saveDirCategory(k22.getProdClassCode(), k22.getProdClassName(), thirdEo.getId(), parentId, parent.getInstanceId(), parent.getTenantId());
                            }
                            continue;
                        }
                        thirdId = this.saveDirCategory(i.getProdThirdClass(), i.getProdThirdClassName(), twoEo.getId(), parentId, parent.getInstanceId(), parent.getTenantId());
                        k22 = i.getProdList().iterator();
                        while (k22.hasNext()) {
                            k4 = (ItemSapMaterialClassDto.TwoList.ThirdList.ProdList)k22.next();
                            prodEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)k4.getProdClassCode())).eq((Object)"root_id", (Object)parentId)).one();
                            if (prodEo != null) {
                                prodEo.setName(k4.getProdClassName());
                                this.dirDas.updateSelective((BaseEo)prodEo);
                                continue;
                            }
                            this.saveDirCategory(k4.getProdClassCode(), k4.getProdClassName(), (Long)thirdId, parentId, parent.getInstanceId(), parent.getTenantId());
                        }
                    }
                    continue;
                }
                Long twoId = this.saveDirCategory(e.getProdTwoClass(), e.getProdTwoClassName(), oneId, parentId, parent.getInstanceId(), parent.getTenantId());
                for (ItemSapMaterialClassDto.TwoList.ThirdList i3 : e.getThirdList()) {
                    categoryReqDtos.addAll(this.getAccountCategory(i3.getProdList()));
                    DirEo thirdEo3 = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)i3.getProdThirdClass())).eq((Object)"root_id", (Object)parentId)).one();
                    if (thirdEo3 != null) {
                        thirdEo3.setName(i3.getProdThirdClassName());
                        this.dirDas.updateSelective((BaseEo)thirdEo3);
                        k22 = i3.getProdList().iterator();
                        while (k22.hasNext()) {
                            k4 = (ItemSapMaterialClassDto.TwoList.ThirdList.ProdList)k22.next();
                            prodEo = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)k4.getProdClassCode())).eq((Object)"root_id", (Object)parentId)).one();
                            if (prodEo != null) {
                                prodEo.setName(k4.getProdClassName());
                                this.dirDas.updateSelective((BaseEo)prodEo);
                                continue;
                            }
                            this.saveDirCategory(k4.getProdClassCode(), k4.getProdClassName(), thirdEo3.getId(), parentId, parent.getInstanceId(), parent.getTenantId());
                        }
                        continue;
                    }
                    Long thirdId3 = this.saveDirCategory(i3.getProdThirdClass(), i3.getProdThirdClassName(), twoId, parentId, parent.getInstanceId(), parent.getTenantId());
                    for (ItemSapMaterialClassDto.TwoList.ThirdList.ProdList k5 : i3.getProdList()) {
                        DirEo prodEo4 = (DirEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", (Object)k5.getProdClassCode())).eq((Object)"root_id", (Object)parentId)).one();
                        if (prodEo4 != null) {
                            prodEo4.setName(k5.getProdClassName());
                            this.dirDas.updateSelective((BaseEo)prodEo4);
                            continue;
                        }
                        this.saveDirCategory(k5.getProdClassCode(), k5.getProdClassName(), thirdId3, parentId, parent.getInstanceId(), parent.getTenantId());
                    }
                }
            }
        }
        this.logger.info("\u4ea7\u54c1\u578b\u53f7\u4e0e\u6838\u7b97\u54c1\u7c7b\u5173\u7cfb\uff1a{}", (Object)JSON.toJSONString(categoryReqDtos));
        if (!CollectionUtils.isEmpty(categoryReqDtos)) {
            Map<String, List<AccountingCategoryReqDto>> categoryReqDtoListMap = new ArrayList(categoryReqDtos).stream().collect(Collectors.groupingBy(AccountingCategoryReqDto::getProdClassCode));
            HashMap addAttributesMap = Maps.newHashMap();
            HashMap updateAttributesMap = Maps.newHashMap();
            categoryReqDtoListMap.forEach((k, v) -> {
                CategoryAttributesEo attributesEo = (CategoryAttributesEo)((ExtQueryChainWrapper)this.categoryAttributesDas.filter().eq((Object)"prod_class_code", k)).one();
                if (Objects.nonNull(attributesEo)) {
                    CubeBeanUtils.copyProperties((Object)attributesEo, v.get(0), (String[])new String[0]);
                    updateAttributesMap.put(k, attributesEo);
                } else {
                    attributesEo = new CategoryAttributesEo();
                    CubeBeanUtils.copyProperties((Object)attributesEo, v.get(0), (String[])new String[0]);
                    addAttributesMap.put(k, attributesEo);
                }
            });
            ArrayList attributesEos = new ArrayList(addAttributesMap.values());
            if (!CollectionUtils.isEmpty(attributesEos)) {
                this.categoryAttributesDas.insertBatch(attributesEos);
            }
            updateAttributesMap.forEach((k, v) -> this.categoryAttributesDas.updateSelective((BaseEo)v));
        }
    }

    private Set<AccountingCategoryReqDto> getAccountCategory(List<ItemSapMaterialClassDto.TwoList.ThirdList.ProdList> prodLists) {
        HashSet<AccountingCategoryReqDto> categoryReqDtos = new HashSet<AccountingCategoryReqDto>();
        prodLists.forEach(v -> {
            if (StringUtils.isNotBlank((CharSequence)v.getAccountingCategoryCode())) {
                AccountingCategoryReqDto reqDto = new AccountingCategoryReqDto();
                reqDto.setProdClassCode(v.getProdClassCode());
                reqDto.setAccountingCategoryCode(v.getAccountingCategoryCode());
                reqDto.setAccountingCategoryName(v.getAccountingCategoryName());
                categoryReqDtos.add(reqDto);
            }
        });
        return categoryReqDtos;
    }

    @Override
    public List<DirCategoryRespDto> queryParentCategorys(Long id) {
        ArrayList<DirCategoryRespDto> parentCategory = new ArrayList<DirCategoryRespDto>();
        List parentList = this.extShelfDas.queryParentCategorys(id);
        if (!CollectionUtils.isEmpty((Collection)parentList)) {
            CubeBeanUtils.copyCollection(parentCategory, (Collection)parentList, DirCategoryRespDto.class);
        }
        return parentCategory;
    }

    @Override
    public List<DirCategoryRespDto> queryChildCategorys(Long id) {
        ArrayList<DirCategoryRespDto> childCategory = new ArrayList<DirCategoryRespDto>();
        List childList = this.extShelfDas.queryChildCategorys(id);
        if (!CollectionUtils.isEmpty((Collection)childList)) {
            CubeBeanUtils.copyCollection(childCategory, (Collection)childList, DirCategoryRespDto.class);
        }
        return childCategory;
    }

    @Override
    public List<DirectoryItemRespDto> queryDirByCodes(List<String> codes) {
        ArrayList list = Lists.newArrayList();
        List dirEos = ((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"code", codes)).list();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)dirEos, DirectoryItemRespDto.class);
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long saveDirCategory(String code, String name, Long parentId, Long rootId, Long instanceId, Long tenantId) {
        DirEo dirEo = new DirEo();
        dirEo.setCode(code);
        dirEo.setName(name);
        dirEo.setParentId(parentId);
        dirEo.setRootId(rootId);
        dirEo.setInstanceId(instanceId);
        dirEo.setTenantId(tenantId);
        return this.directoryItemService.saveDirectoryItem(dirEo, null);
    }

    private List<Long> getDirCategory(Long id) {
        ArrayList<Long> list = new ArrayList<Long>();
        List dirEoList = this.dirDas.selectAll();
        DirEo dirEo = (DirEo)((ExtQueryChainWrapper)this.dirDas.filter().eq((Object)"id", (Object)id)).one();
        if (dirEo.getParentId() == 0L || dirEo.getParentId() == null) {
            this.parentIds.add(dirEo.getId());
        }
        list.addAll(this.parentIds);
        this.getParentCategory(dirEoList, dirEo.getParentId());
        if (dirEo.getParentId() == 0L || dirEo.getParentId() == null) {
            this.childrenIds.add(dirEo.getId());
        }
        this.getChildrenCategory(dirEoList, dirEo.getId());
        list.addAll(this.childrenIds);
        return list;
    }

    private void getParentCategory(List<DirEo> dirEoList, Long id) {
        for (DirEo dirEo : dirEoList) {
            if (dirEo.getParentId() == 0L || dirEo.getParentId() == null || Long.compare(dirEo.getId(), id) != 0) continue;
            this.parentIds.add(dirEo.getId());
            this.getParentCategory(dirEoList, dirEo.getParentId());
        }
    }

    private void getChildrenCategory(List<DirEo> dirEoList, Long id) {
        for (DirEo dirEo : dirEoList) {
            if (dirEo.getParentId() == 0L || dirEo.getParentId() == null || Long.compare(id, dirEo.getParentId()) != 0) continue;
            this.childrenIds.add(dirEo.getId());
            this.getChildrenCategory(dirEoList, dirEo.getId());
        }
    }
}

